/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.client.protocol.rest.OperationItem;
import io.camunda.zeebe.client.protocol.rest.ProcessInstanceReferenceItem;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Base properties for ProcessInstanceItem
 */
@JsonPropertyOrder({
  ProcessInstanceItemBase.JSON_PROPERTY_PROCESS_DEFINITION_NAME,
  ProcessInstanceItemBase.JSON_PROPERTY_PROCESS_DEFINITION_VERSION,
  ProcessInstanceItemBase.JSON_PROPERTY_BPMN_PROCESS_ID,
  ProcessInstanceItemBase.JSON_PROPERTY_START_DATE,
  ProcessInstanceItemBase.JSON_PROPERTY_END_DATE,
  ProcessInstanceItemBase.JSON_PROPERTY_STATE,
  ProcessInstanceItemBase.JSON_PROPERTY_INCIDENT,
  ProcessInstanceItemBase.JSON_PROPERTY_HAS_ACTIVE_OPERATION,
  ProcessInstanceItemBase.JSON_PROPERTY_TENANT_ID,
  ProcessInstanceItemBase.JSON_PROPERTY_ROOT_INSTANCE_ID,
  ProcessInstanceItemBase.JSON_PROPERTY_OPERATIONS,
  ProcessInstanceItemBase.JSON_PROPERTY_CALL_HIERARCHY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-04-01T08:58:27.371823074Z[GMT]", comments = "Generator version: 7.8.0")
public class ProcessInstanceItemBase {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_NAME = "processDefinitionName";
  private String processDefinitionName;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
  private Integer processDefinitionVersion;

  public static final String JSON_PROPERTY_BPMN_PROCESS_ID = "bpmnProcessId";
  private String bpmnProcessId;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private String startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private String endDate;

  /**
   * Gets or Sets state
   */
  public enum StateEnum {
    ACTIVE("ACTIVE"),
    
    INCIDENT("INCIDENT"),
    
    COMPLETED("COMPLETED"),
    
    CANCELED("CANCELED"),
    
    UNKNOWN("UNKNOWN"),
    
    UNSPECIFIED("UNSPECIFIED"),
    
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  private StateEnum state;

  public static final String JSON_PROPERTY_INCIDENT = "incident";
  private Boolean incident;

  public static final String JSON_PROPERTY_HAS_ACTIVE_OPERATION = "hasActiveOperation";
  private Boolean hasActiveOperation;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private String tenantId;

  public static final String JSON_PROPERTY_ROOT_INSTANCE_ID = "rootInstanceId";
  private String rootInstanceId;

  public static final String JSON_PROPERTY_OPERATIONS = "operations";
  private List<OperationItem> operations = new ArrayList<>();

  public static final String JSON_PROPERTY_CALL_HIERARCHY = "callHierarchy";
  private List<ProcessInstanceReferenceItem> callHierarchy = new ArrayList<>();

  public ProcessInstanceItemBase() {
  }

  public ProcessInstanceItemBase processDefinitionName(String processDefinitionName) {
    
    this.processDefinitionName = processDefinitionName;
    return this;
  }

  /**
   * The process name.
   * @return processDefinitionName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionName() {
    return processDefinitionName;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionName(String processDefinitionName) {
    this.processDefinitionName = processDefinitionName;
  }

  public ProcessInstanceItemBase processDefinitionVersion(Integer processDefinitionVersion) {
    
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * Get processDefinitionVersion
   * @return processDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public ProcessInstanceItemBase bpmnProcessId(String bpmnProcessId) {
    
    this.bpmnProcessId = bpmnProcessId;
    return this;
  }

  /**
   * Get bpmnProcessId
   * @return bpmnProcessId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BPMN_PROCESS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBpmnProcessId() {
    return bpmnProcessId;
  }


  @JsonProperty(JSON_PROPERTY_BPMN_PROCESS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBpmnProcessId(String bpmnProcessId) {
    this.bpmnProcessId = bpmnProcessId;
  }

  public ProcessInstanceItemBase startDate(String startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Get startDate
   * @return startDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }

  public ProcessInstanceItemBase endDate(String endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * Get endDate
   * @return endDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(String endDate) {
    this.endDate = endDate;
  }

  public ProcessInstanceItemBase state(StateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(StateEnum state) {
    this.state = state;
  }

  public ProcessInstanceItemBase incident(Boolean incident) {
    
    this.incident = incident;
    return this;
  }

  /**
   * Get incident
   * @return incident
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncident() {
    return incident;
  }


  @JsonProperty(JSON_PROPERTY_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncident(Boolean incident) {
    this.incident = incident;
  }

  public ProcessInstanceItemBase hasActiveOperation(Boolean hasActiveOperation) {
    
    this.hasActiveOperation = hasActiveOperation;
    return this;
  }

  /**
   * Get hasActiveOperation
   * @return hasActiveOperation
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HAS_ACTIVE_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasActiveOperation() {
    return hasActiveOperation;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ACTIVE_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasActiveOperation(Boolean hasActiveOperation) {
    this.hasActiveOperation = hasActiveOperation;
  }

  public ProcessInstanceItemBase tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * Get tenantId
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public ProcessInstanceItemBase rootInstanceId(String rootInstanceId) {
    
    this.rootInstanceId = rootInstanceId;
    return this;
  }

  /**
   * Get rootInstanceId
   * @return rootInstanceId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ROOT_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRootInstanceId() {
    return rootInstanceId;
  }


  @JsonProperty(JSON_PROPERTY_ROOT_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRootInstanceId(String rootInstanceId) {
    this.rootInstanceId = rootInstanceId;
  }

  public ProcessInstanceItemBase operations(List<OperationItem> operations) {
    
    this.operations = operations;
    return this;
  }

  public ProcessInstanceItemBase addOperationsItem(OperationItem operationsItem) {
    if (this.operations == null) {
      this.operations = new ArrayList<>();
    }
    this.operations.add(operationsItem);
    return this;
  }

  /**
   * Get operations
   * @return operations
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPERATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationItem> getOperations() {
    return operations;
  }


  @JsonProperty(JSON_PROPERTY_OPERATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperations(List<OperationItem> operations) {
    this.operations = operations;
  }

  public ProcessInstanceItemBase callHierarchy(List<ProcessInstanceReferenceItem> callHierarchy) {
    
    this.callHierarchy = callHierarchy;
    return this;
  }

  public ProcessInstanceItemBase addCallHierarchyItem(ProcessInstanceReferenceItem callHierarchyItem) {
    if (this.callHierarchy == null) {
      this.callHierarchy = new ArrayList<>();
    }
    this.callHierarchy.add(callHierarchyItem);
    return this;
  }

  /**
   * Get callHierarchy
   * @return callHierarchy
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CALL_HIERARCHY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ProcessInstanceReferenceItem> getCallHierarchy() {
    return callHierarchy;
  }


  @JsonProperty(JSON_PROPERTY_CALL_HIERARCHY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCallHierarchy(List<ProcessInstanceReferenceItem> callHierarchy) {
    this.callHierarchy = callHierarchy;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceItemBase processInstanceItemBase = (ProcessInstanceItemBase) o;
    return Objects.equals(this.processDefinitionName, processInstanceItemBase.processDefinitionName) &&
        Objects.equals(this.processDefinitionVersion, processInstanceItemBase.processDefinitionVersion) &&
        Objects.equals(this.bpmnProcessId, processInstanceItemBase.bpmnProcessId) &&
        Objects.equals(this.startDate, processInstanceItemBase.startDate) &&
        Objects.equals(this.endDate, processInstanceItemBase.endDate) &&
        Objects.equals(this.state, processInstanceItemBase.state) &&
        Objects.equals(this.incident, processInstanceItemBase.incident) &&
        Objects.equals(this.hasActiveOperation, processInstanceItemBase.hasActiveOperation) &&
        Objects.equals(this.tenantId, processInstanceItemBase.tenantId) &&
        Objects.equals(this.rootInstanceId, processInstanceItemBase.rootInstanceId) &&
        Objects.equals(this.operations, processInstanceItemBase.operations) &&
        Objects.equals(this.callHierarchy, processInstanceItemBase.callHierarchy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinitionName, processDefinitionVersion, bpmnProcessId, startDate, endDate, state, incident, hasActiveOperation, tenantId, rootInstanceId, operations, callHierarchy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceItemBase {\n");
    sb.append("    processDefinitionName: ").append(toIndentedString(processDefinitionName)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    bpmnProcessId: ").append(toIndentedString(bpmnProcessId)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    incident: ").append(toIndentedString(incident)).append("\n");
    sb.append("    hasActiveOperation: ").append(toIndentedString(hasActiveOperation)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    rootInstanceId: ").append(toIndentedString(rootInstanceId)).append("\n");
    sb.append("    operations: ").append(toIndentedString(operations)).append("\n");
    sb.append("    callHierarchy: ").append(toIndentedString(callHierarchy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processDefinitionName` to the URL query string
    if (getProcessDefinitionName() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionVersion` to the URL query string
    if (getProcessDefinitionVersion() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `bpmnProcessId` to the URL query string
    if (getBpmnProcessId() != null) {
      try {
        joiner.add(String.format("%sbpmnProcessId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBpmnProcessId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startDate` to the URL query string
    if (getStartDate() != null) {
      try {
        joiner.add(String.format("%sstartDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `endDate` to the URL query string
    if (getEndDate() != null) {
      try {
        joiner.add(String.format("%sendDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEndDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incident` to the URL query string
    if (getIncident() != null) {
      try {
        joiner.add(String.format("%sincident%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncident()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `hasActiveOperation` to the URL query string
    if (getHasActiveOperation() != null) {
      try {
        joiner.add(String.format("%shasActiveOperation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHasActiveOperation()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rootInstanceId` to the URL query string
    if (getRootInstanceId() != null) {
      try {
        joiner.add(String.format("%srootInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRootInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `operations` to the URL query string
    if (getOperations() != null) {
      for (int i = 0; i < getOperations().size(); i++) {
        if (getOperations().get(i) != null) {
          joiner.add(getOperations().get(i).toUrlQueryString(String.format("%soperations%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `callHierarchy` to the URL query string
    if (getCallHierarchy() != null) {
      for (int i = 0; i < getCallHierarchy().size(); i++) {
        if (getCallHierarchy().get(i) != null) {
          joiner.add(getCallHierarchy().get(i).toUrlQueryString(String.format("%scallHierarchy%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

