/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.json.async.NonBlockingByteBufferJsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import io.camunda.zeebe.client.impl.http.ApiEntity;
import io.camunda.zeebe.client.protocol.rest.ProblemDetail;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public interface TypedApiEntityConsumer<T> {
    public ApiEntity<T> generateContent() throws IOException;

    public void consumeData(ByteBuffer var1, boolean var2) throws IOException;

    public void releaseResources();

    public int getBufferedBytes();

    public static class RawApiEntityConsumer<T>
    implements TypedApiEntityConsumer<T> {
        private final boolean isResponse;
        private byte[] body = new byte[1024];
        private int bufferedBytes;

        public RawApiEntityConsumer(boolean isResponse) {
            this.isResponse = isResponse;
        }

        @Override
        public ApiEntity<T> generateContent() {
            if (this.bufferedBytes == 0) {
                return null;
            }
            if (this.isResponse) {
                return ApiEntity.of(new String(this.body, 0, this.bufferedBytes, StandardCharsets.UTF_8));
            }
            return ApiEntity.of(ByteBuffer.wrap(this.body, 0, this.bufferedBytes));
        }

        @Override
        public void consumeData(ByteBuffer src, boolean endOfStream) {
            int offset = this.bufferedBytes;
            this.bufferedBytes += src.remaining();
            if (this.body.length < this.bufferedBytes) {
                this.body = Arrays.copyOf(this.body, this.body.length + 1024);
            }
            src.get(this.body, offset, src.remaining());
        }

        @Override
        public void releaseResources() {
            this.bufferedBytes = 0;
        }

        @Override
        public int getBufferedBytes() {
            return this.bufferedBytes;
        }
    }

    public static class JsonApiEntityConsumer<T>
    implements TypedApiEntityConsumer<T> {
        private final ObjectMapper json;
        private final Class<T> type;
        private final NonBlockingByteBufferJsonParser parser;
        private final TokenBuffer buffer;
        private final boolean isResponse;
        private int bufferedBytes;

        public JsonApiEntityConsumer(ObjectMapper json, Class<T> type, boolean isResponse) throws IOException {
            this.json = json;
            this.type = type;
            this.isResponse = isResponse;
            this.parser = (NonBlockingByteBufferJsonParser)json.getFactory().createNonBlockingByteBufferParser();
            this.buffer = new TokenBuffer((JsonParser)this.parser, json.getDeserializationContext());
        }

        @Override
        public ApiEntity<T> generateContent() throws IOException {
            this.buffer.asParserOnFirstToken();
            if (this.isResponse) {
                return ApiEntity.of(this.json.readValue(this.buffer.asParserOnFirstToken(), this.type));
            }
            return ApiEntity.of((ProblemDetail)this.json.readValue(this.buffer.asParserOnFirstToken(), ProblemDetail.class));
        }

        @Override
        public void consumeData(ByteBuffer src, boolean endOfStream) throws IOException {
            this.bufferedBytes += src.remaining();
            this.parser.feedInput(src);
            JsonToken jsonToken = this.parser.nextToken();
            while (jsonToken != null && jsonToken != JsonToken.NOT_AVAILABLE) {
                this.buffer.copyCurrentEvent((JsonParser)this.parser);
                jsonToken = this.parser.nextToken();
            }
            if (endOfStream) {
                this.parser.endOfInput();
            }
        }

        @Override
        public void releaseResources() {
            try {
                this.parser.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.buffer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bufferedBytes = 0;
        }

        @Override
        public int getBufferedBytes() {
            return this.bufferedBytes;
        }
    }
}

