/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.api.command;

import io.camunda.zeebe.client.api.command.MigrationPlan;
import io.camunda.zeebe.client.api.command.MigrationPlanImpl;
import java.util.ArrayList;
import java.util.List;

public final class MigrationPlanBuilderImpl
implements MigrationPlan.MigrationPlanBuilderStep1,
MigrationPlan.MigrationPlanBuilderStep2,
MigrationPlan.MigrationPlanBuilderFinalStep {
    private long targetProcessDefinitionKey;
    private final List<MappingInstruction> mappingInstructions = new ArrayList<MappingInstruction>();

    @Override
    public MigrationPlan.MigrationPlanBuilderStep2 withTargetProcessDefinitionKey(long targetProcessDefinitionKey) {
        this.targetProcessDefinitionKey = targetProcessDefinitionKey;
        return this;
    }

    @Override
    public MigrationPlan.MigrationPlanBuilderFinalStep addMappingInstruction(String sourceElementId, String targetElementId) {
        this.mappingInstructions.add(new MappingInstruction(sourceElementId, targetElementId));
        return this;
    }

    @Override
    public MigrationPlan build() {
        return new MigrationPlanImpl(this.targetProcessDefinitionKey, this.mappingInstructions);
    }

    public static class MappingInstruction {
        private final String sourceElementId;
        private final String targetElementId;

        public MappingInstruction(String sourceElementId, String targetElementId) {
            this.sourceElementId = sourceElementId;
            this.targetElementId = targetElementId;
        }

        public String getSourceElementId() {
            return this.sourceElementId;
        }

        public String getTargetElementId() {
            return this.targetElementId;
        }
    }
}

