/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.tenant;

import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public interface TenantService {
    public AuthenticatedTenants getAuthenticatedTenants();

    public boolean isTenantValid(String var1);

    public boolean isMultiTenancyEnabled();

    public static enum TenantAccessType {
        TENANT_ACCESS_ALL,
        TENANT_ACCESS_ASSIGNED,
        TENANT_ACCESS_NONE;

    }

    public record AuthenticatedTenants(TenantAccessType tenantAccessType, List<String> ids) {
        public TenantAccessType getTenantAccessType() {
            return this.tenantAccessType;
        }

        public List<String> getTenantIds() {
            return this.ids;
        }

        public boolean contains(String tenantId) {
            return this.ids.contains(tenantId);
        }

        public static AuthenticatedTenants allTenants() {
            return new AuthenticatedTenants(TenantAccessType.TENANT_ACCESS_ALL, Collections.emptyList());
        }

        public static AuthenticatedTenants noTenantsAssigned() {
            return new AuthenticatedTenants(TenantAccessType.TENANT_ACCESS_NONE, Collections.emptyList());
        }

        public static AuthenticatedTenants assignedTenants(List<String> tenants) {
            return new AuthenticatedTenants(TenantAccessType.TENANT_ACCESS_ASSIGNED, tenants);
        }
    }
}

