/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.se;

import io.camunda.tasklist.webapp.security.Permission;
import io.camunda.tasklist.webapp.security.se.Role;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class RolePermissionService {
    private final Map<Role, List<Permission>> roles2permissions = new EnumMap<Role, List<Permission>>(Role.class);

    @PostConstruct
    public void init() {
        this.roles2permissions.put(Role.READER, List.of(Permission.READ));
        this.roles2permissions.put(Role.OPERATOR, List.of(Permission.READ, Permission.WRITE));
        this.roles2permissions.put(Role.OWNER, List.of(Permission.READ, Permission.WRITE));
    }

    public List<Permission> getPermissions(List<Role> roles) {
        return roles.stream().map(this::getPermissionsForRole).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Permission> getPermissionsForRole(Role role) {
        return this.roles2permissions.get((Object)role);
    }
}

