/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security;

import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.webapp.graphql.entity.UserDTO;
import io.camunda.tasklist.webapp.rest.exception.UnauthenticatedUserException;
import java.util.List;
import java.util.Optional;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public interface UserReader {
    public static final String DEFAULT_ORGANIZATION = "null";
    public static final String DEFAULT_USER = "No name";

    default public UserDTO getCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof AnonymousAuthenticationToken) {
            throw new UnauthenticatedUserException("User is not authenticated");
        }
        return this.getCurrentUserBy(authentication).orElseThrow(() -> new TasklistRuntimeException(String.format("Could not build UserDTO from authentication %s", authentication)));
    }

    public Optional<UserDTO> getCurrentUserBy(Authentication var1);

    public String getCurrentOrganizationId();

    default public String getCurrentUserId() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || authentication.getPrincipal() == null) {
            return DEFAULT_USER;
        }
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwt = (JwtAuthenticationToken)authentication;
            return authentication.getName();
        }
        return authentication.getPrincipal().toString();
    }

    public List<UserDTO> getUsersByUsernames(List<String> var1);

    default public String getUserToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof AnonymousAuthenticationToken) {
            throw new UnauthenticatedUserException("User is not authenticated");
        }
        return this.getUserToken(authentication).orElseThrow(() -> new TasklistRuntimeException(String.format("Could not build UserDTO from authentication %s", authentication)));
    }

    public Optional<String> getUserToken(Authentication var1);
}

