/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es.tenant;

import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.tenant.TenantCheckApplier;
import io.camunda.tasklist.util.OpenSearchUtil;
import io.camunda.tasklist.webapp.security.tenant.TenantService;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.util.ObjectBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpenSearchCondition.class})
@Component
public class OpenSearchTenantCheckApplier
implements TenantCheckApplier<SearchRequest.Builder> {
    @Autowired
    private TenantService tenantService;

    public void apply(SearchRequest.Builder searchRequest) {
        TenantService.AuthenticatedTenants tenants = this.tenantService.getAuthenticatedTenants();
        TenantService.TenantAccessType tenantCheckQueryType = tenants.getTenantAccessType();
        List<String> searchByTenantIds = tenants.getTenantIds();
        this.applyTenantCheckOnQuery(searchRequest, tenantCheckQueryType, searchByTenantIds);
    }

    public void apply(SearchRequest.Builder searchRequest, Collection<String> tenantIds) {
        TenantService.AuthenticatedTenants tenants = this.tenantService.getAuthenticatedTenants();
        TenantService.TenantAccessType tenantCheckQueryType = tenants.getTenantAccessType();
        Set<String> authorizedTenantIds = Set.copyOf(tenants.getTenantIds());
        Set<String> searchByTenantIds = tenantIds.stream().filter(authorizedTenantIds::contains).collect(Collectors.toSet());
        this.applyTenantCheckOnQuery(searchRequest, tenantCheckQueryType, searchByTenantIds);
    }

    private void applyTenantCheckOnQuery(SearchRequest.Builder searchRequest, TenantService.TenantAccessType tenantCheckQueryType, Collection<String> searchByTenantIds) {
        Query actualQuery = this.getQueryFromSearchRequestBuilder(searchRequest);
        switch (tenantCheckQueryType) {
            case TENANT_ACCESS_ASSIGNED: {
                Query finalQuery;
                if (CollectionUtils.isEmpty(searchByTenantIds)) {
                    finalQuery = OpenSearchUtil.createMatchNoneQuery();
                } else {
                    ObjectBuilder tenantTermsQuery = new Query.Builder().terms(terms -> terms.field("tenantId").terms(values -> values.value(searchByTenantIds.stream().map(FieldValue::of).collect(Collectors.toList()))));
                    finalQuery = OpenSearchUtil.joinWithAnd((Query[])new Query[]{(Query)tenantTermsQuery.build(), actualQuery});
                }
                searchRequest.query(finalQuery);
                break;
            }
            case TENANT_ACCESS_NONE: {
                searchRequest.query(OpenSearchUtil.createMatchNoneQuery());
                break;
            }
            case TENANT_ACCESS_ALL: {
                searchRequest.query(actualQuery);
                break;
            }
            default: {
                String message = String.format("Unexpected tenant check query type %s", new Object[]{tenantCheckQueryType});
                throw new TasklistRuntimeException(message);
            }
        }
    }

    private Query getQueryFromSearchRequestBuilder(SearchRequest.Builder searchRequest) {
        try {
            Field privateField = SearchRequest.Builder.class.getDeclaredField("query");
            privateField.setAccessible(true);
            return (Query)privateField.get(searchRequest);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

