/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.es;

import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.exceptions.NoSuchIndexException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.camunda.tasklist.zeebe.ImportValueType;
import io.camunda.tasklist.zeebeimport.ImportBatch;
import io.camunda.tasklist.zeebeimport.RecordsReaderAbstract;
import io.camunda.tasklist.zeebeimport.es.ImportBatchElasticSearch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Conditional(value={ElasticSearchCondition.class})
public class RecordsReaderElasticSearch
extends RecordsReaderAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordsReaderElasticSearch.class);
    @Autowired
    @Qualifier(value="tasklistZeebeEsClient")
    private RestHighLevelClient zeebeEsClient;

    public RecordsReaderElasticSearch(int partitionId, ImportValueType importValueType, int queueSize) {
        super(partitionId, importValueType, queueSize);
    }

    private SearchHit[] withTimerSearchHits(Callable<SearchHit[]> callable) throws Exception {
        return (SearchHit[])this.metrics.getTimer("tasklist.import.query", new String[]{"type", this.importValueType.name(), "partition", String.valueOf(this.partitionId)}).recordCallable(callable);
    }

    private ImportBatchElasticSearch createImportBatch(SearchResponse searchResponse) {
        SearchHit[] hits = searchResponse.getHits().getHits();
        String indexName = null;
        if (hits.length > 0) {
            indexName = hits[hits.length - 1].getIndex();
        }
        return new ImportBatchElasticSearch(this.partitionId, this.importValueType, Arrays.asList(hits), indexName);
    }

    private ImportBatchElasticSearch createImportBatch(SearchHit[] hits) {
        String indexName = null;
        if (hits.length > 0) {
            indexName = hits[hits.length - 1].getIndex();
        }
        return new ImportBatchElasticSearch(this.partitionId, this.importValueType, Arrays.asList(hits), indexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchHit[] read(SearchRequest searchRequest, boolean scrollNeeded) throws IOException {
        SearchHit[] searchHitArray;
        block6: {
            String scrollId = null;
            try {
                ArrayList<SearchHit> searchHits = new ArrayList<SearchHit>();
                if (scrollNeeded) {
                    searchRequest.scroll(TimeValue.timeValueMillis((long)60000L));
                }
                SearchResponse response = this.zeebeEsClient.search(searchRequest, RequestOptions.DEFAULT);
                searchHits.addAll(List.of(response.getHits().getHits()));
                if (scrollNeeded) {
                    scrollId = response.getScrollId();
                    do {
                        SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
                        scrollRequest.scroll(TimeValue.timeValueMillis((long)60000L));
                        response = this.zeebeEsClient.scroll(scrollRequest, RequestOptions.DEFAULT);
                        scrollId = response.getScrollId();
                        searchHits.addAll(List.of(response.getHits().getHits()));
                    } while (response.getHits().getHits().length != 0);
                }
                searchHitArray = searchHits.toArray(new SearchHit[0]);
                if (scrollId == null) break block6;
            }
            catch (Throwable throwable) {
                if (scrollId != null) {
                    ElasticsearchUtil.clearScroll(scrollId, (RestHighLevelClient)this.zeebeEsClient);
                }
                throw throwable;
            }
            ElasticsearchUtil.clearScroll((String)scrollId, (RestHighLevelClient)this.zeebeEsClient);
        }
        return searchHitArray;
    }

    @Override
    public ImportBatch readNextBatchByPositionAndPartition(long positionFrom, Long positionTo) throws NoSuchIndexException {
        String aliasName = this.importValueType.getAliasName(this.tasklistProperties.getZeebeElasticsearch().getPrefix());
        try {
            SearchRequest searchRequest = this.createSearchQuery(aliasName, positionFrom, positionTo);
            SearchResponse searchResponse = this.withTimer(() -> this.zeebeEsClient.search(searchRequest, RequestOptions.DEFAULT));
            return this.createImportBatch(searchResponse);
        }
        catch (ElasticsearchStatusException ex) {
            if (ex.getMessage().contains("no such index")) {
                LOGGER.debug("No index found for alias {}", (Object)aliasName);
                throw new NoSuchIndexException();
            }
            String message = String.format("Exception occurred for alias [%s], while obtaining next Zeebe records batch: %s", aliasName, ex.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)ex);
        }
        catch (Exception e) {
            String message = String.format("Exception occurred for alias [%s], while obtaining next Zeebe records batch: %s", aliasName, e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public ImportBatch readNextBatchBySequence(Long fromSequence, Long toSequence) throws NoSuchIndexException {
        long lessThanEqualsSequence;
        int maxNumberOfHits;
        String aliasName = this.importValueType.getAliasName(this.tasklistProperties.getZeebeElasticsearch().getPrefix());
        int batchSize = this.tasklistProperties.getZeebeElasticsearch().getBatchSize();
        if (toSequence != null && toSequence > 0L) {
            maxNumberOfHits = (int)((toSequence - fromSequence) * 2L);
            lessThanEqualsSequence = toSequence;
            LOGGER.debug("Import batch reread was called. Data type {}, partitionId {}, sequence {}, lastSequence {}, maxNumberOfHits {}.", new Object[]{this.importValueType, this.partitionId, fromSequence, toSequence, maxNumberOfHits});
        } else {
            maxNumberOfHits = batchSize;
            if (this.countEmptyRuns == this.tasklistProperties.getImporter().getMaxEmptyRuns()) {
                lessThanEqualsSequence = this.maxPossibleSequence;
                this.countEmptyRuns = 0;
                LOGGER.debug("Max empty runs reached. Data type {}, partitionId {}, sequence {}, lastSequence {}, maxNumberOfHits {}.", new Object[]{this.importValueType, this.partitionId, fromSequence, lessThanEqualsSequence, maxNumberOfHits});
            } else {
                lessThanEqualsSequence = fromSequence + (long)batchSize;
            }
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().sort("sequence", SortOrder.ASC).query((QueryBuilder)QueryBuilders.rangeQuery((String)"sequence").gt((Object)fromSequence).lte((Object)lessThanEqualsSequence)).size(maxNumberOfHits >= 10000 ? 10000 : maxNumberOfHits);
        SearchRequest searchRequest = new SearchRequest(new String[]{aliasName}).source(searchSourceBuilder).routing(String.valueOf(this.partitionId)).requestCache(Boolean.valueOf(false));
        try {
            SearchHit[] hits = this.withTimerSearchHits(() -> this.read(searchRequest, maxNumberOfHits >= 10000));
            this.countEmptyRuns = hits.length == 0 ? ++this.countEmptyRuns : 0;
            return this.createImportBatch(hits);
        }
        catch (ElasticsearchStatusException ex) {
            if (ex.getMessage().contains("no such index")) {
                throw new NoSuchIndexException();
            }
            String message = String.format("Exception occurred, while obtaining next Zeebe records batch: %s", ex.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)ex);
        }
        catch (Exception e) {
            String message = String.format("Exception occurred, while obtaining next Zeebe records batch: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    private SearchResponse withTimer(Callable<SearchResponse> callable) throws Exception {
        return (SearchResponse)this.metrics.getTimer("tasklist.import.query", new String[0]).recordCallable(callable);
    }

    private SearchRequest createSearchQuery(String aliasName, long positionFrom, Long positionTo) {
        RangeQueryBuilder positionQ = QueryBuilders.rangeQuery((String)"position").gt((Object)positionFrom);
        if (positionTo != null) {
            positionQ = positionQ.lte((Object)positionTo);
        }
        QueryBuilder queryBuilder = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{positionQ, QueryBuilders.termQuery((String)"partitionId", (int)this.partitionId)});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(queryBuilder).sort("position", SortOrder.ASC);
        if (positionTo == null) {
            searchSourceBuilder = searchSourceBuilder.size(this.tasklistProperties.getZeebeElasticsearch().getBatchSize());
        } else {
            LOGGER.debug("Import batch reread was called. Data type {}, partitionId {}, positionFrom {}, positionTo {}.", new Object[]{this.importValueType, this.partitionId, positionFrom, positionTo});
            int size = (int)(positionTo - positionFrom);
            searchSourceBuilder = searchSourceBuilder.size(size <= 0 || size > 10000 ? 10000 : size);
        }
        return new SearchRequest(new String[]{aliasName}).source(searchSourceBuilder).routing(String.valueOf(this.partitionId)).requestCache(Boolean.valueOf(false));
    }
}

