/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.es;

import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.entities.meta.ImportPositionEntity;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.camunda.tasklist.zeebeimport.ImportBatch;
import io.camunda.tasklist.zeebeimport.ImportJobAbstract;
import io.camunda.tasklist.zeebeimport.es.ImportBatchElasticSearch;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Conditional(value={ElasticSearchCondition.class})
public class ImportJobElasticSearch
extends ImportJobAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportJobElasticSearch.class);
    @Autowired
    @Qualifier(value="tasklistZeebeEsClient")
    private RestHighLevelClient zeebeEsClient;

    public ImportJobElasticSearch(ImportBatch importBatch, ImportPositionEntity previousPosition) {
        this.importBatch = importBatch;
        this.previousPosition = previousPosition;
        this.creationTime = OffsetDateTime.now();
    }

    @Override
    public List<ImportBatch> createSubBatchesPerIndexName() {
        ArrayList<ImportBatch> subBatches = new ArrayList<ImportBatch>();
        if (this.importBatch.getHits().size() <= 1) {
            subBatches.add(this.importBatch);
            return subBatches;
        }
        String previousIndexName = null;
        ArrayList<SearchHit> subBatchHits = new ArrayList<SearchHit>();
        List importResult = this.importBatch.getHits();
        for (SearchHit hit : importResult) {
            String indexName = hit.getIndex();
            if (previousIndexName != null && !indexName.equals(previousIndexName)) {
                subBatches.add((ImportBatch)new ImportBatchElasticSearch(this.importBatch.getPartitionId(), this.importBatch.getImportValueType(), subBatchHits, previousIndexName));
                subBatchHits = new ArrayList();
            }
            subBatchHits.add(hit);
            previousIndexName = indexName;
        }
        subBatches.add((ImportBatch)new ImportBatchElasticSearch(this.importBatch.getPartitionId(), this.importBatch.getImportValueType(), subBatchHits, previousIndexName));
        return subBatches;
    }

    @Override
    public void refreshZeebeIndices() {
        String indexPattern = this.importBatch.getImportValueType().getIndicesPattern(this.tasklistProperties.getZeebeElasticsearch().getPrefix());
        ElasticsearchUtil.refreshIndicesFor((RestHighLevelClient)this.zeebeEsClient, (String)indexPattern);
    }
}

