/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.Metrics;
import io.camunda.tasklist.entities.meta.ImportPositionEntity;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.ImportPositionIndex;
import io.camunda.tasklist.util.Either;
import io.camunda.tasklist.zeebeimport.ImportPositionHolder;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public abstract class ImportPositionHolderAbstract
implements ImportPositionHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportPositionHolderAbstract.class);
    protected Map<String, ImportPositionEntity> lastScheduledPositions = new HashMap<String, ImportPositionEntity>();
    protected Map<String, ImportPositionEntity> pendingProcessedPositions = new HashMap<String, ImportPositionEntity>();
    protected Map<String, ImportPositionEntity> inflightProcessedPositions = new HashMap<String, ImportPositionEntity>();
    protected ScheduledFuture<?> scheduledTask;
    protected ReentrantLock inflightImportPositionLock = new ReentrantLock();
    @Autowired
    protected ImportPositionIndex importPositionType;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    protected ObjectMapper objectMapper;
    @Autowired
    protected TasklistProperties tasklistProperties;
    @Autowired
    protected Metrics metrics;
    @Autowired
    @Qualifier(value="tasklistImportPositionUpdateThreadPoolExecutor")
    protected ThreadPoolTaskScheduler importPositionUpdateExecutor;

    @PostConstruct
    private void init() {
        LOGGER.info("INIT: Start import position updater...");
        this.scheduleImportPositionUpdateTask();
    }

    @Override
    public void scheduleImportPositionUpdateTask() {
        int interval = this.tasklistProperties.getImporter().getImportPositionUpdateInterval();
        this.scheduledTask = this.importPositionUpdateExecutor.schedule(this::updateImportPositions, OffsetDateTime.now().plus(interval, ChronoUnit.MILLIS).toInstant());
    }

    @Override
    public CompletableFuture<Void> cancelScheduledImportPositionUpdateTask() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.importPositionUpdateExecutor.submit(() -> {
            if (this.scheduledTask != null) {
                this.scheduledTask.cancel(false);
                this.scheduledTask = null;
            }
            future.complete(null);
        });
        return future;
    }

    @Override
    public ImportPositionEntity getLatestScheduledPosition(String aliasTemplate, int partitionId) throws IOException {
        String key = this.getKey(aliasTemplate, partitionId);
        if (this.lastScheduledPositions.containsKey(key)) {
            return this.lastScheduledPositions.get(key);
        }
        ImportPositionEntity latestLoadedPosition = this.getLatestLoadedPosition(aliasTemplate, partitionId);
        this.lastScheduledPositions.put(key, latestLoadedPosition);
        return latestLoadedPosition;
    }

    private String getKey(String aliasTemplate, int partitionId) {
        return String.format("%s-%d", aliasTemplate, partitionId);
    }

    @Override
    public void recordLatestScheduledPosition(String aliasName, int partitionId, ImportPositionEntity importPositionEntity) {
        this.lastScheduledPositions.put(this.getKey(aliasName, partitionId), importPositionEntity);
    }

    @Override
    public void recordLatestLoadedPosition(ImportPositionEntity lastProcessedPosition) {
        this.withInflightImportPositionLock(() -> {
            String aliasName = lastProcessedPosition.getAliasName();
            int partition = lastProcessedPosition.getPartitionId();
            this.inflightProcessedPositions.put(this.getKey(aliasName, partition), lastProcessedPosition);
        });
    }

    @Override
    public void clearCache() {
        this.lastScheduledPositions.clear();
        this.pendingProcessedPositions.clear();
        this.withInflightImportPositionLock(() -> this.inflightProcessedPositions.clear());
    }

    protected void withImportPositionTimer(Callable<Void> action) throws Exception {
        this.metrics.getTimer("tasklist.import.position.update", new String[0]).recordCallable(action);
    }

    protected void withInflightImportPositionLock(Runnable action) {
        try {
            this.inflightImportPositionLock.lock();
            action.run();
        }
        finally {
            this.inflightImportPositionLock.unlock();
        }
    }

    @Override
    public void updateImportPositions() {
        this.withInflightImportPositionLock(() -> {
            this.pendingProcessedPositions.putAll(this.inflightProcessedPositions);
            this.inflightProcessedPositions.clear();
        });
        Either<Throwable, Boolean> result = this.updateImportPositions(this.pendingProcessedPositions);
        if (((Boolean)result.getOrElse((Object)false)).booleanValue()) {
            this.pendingProcessedPositions.clear();
        }
        this.scheduleImportPositionUpdateTask();
    }
}

