/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.entities.meta.ImportPositionEntity;
import io.camunda.tasklist.exceptions.NoSuchIndexException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.zeebeimport.ImportBatch;
import io.camunda.tasklist.zeebeimport.ImportBatchProcessor;
import io.camunda.tasklist.zeebeimport.ImportBatchProcessorFactory;
import io.camunda.tasklist.zeebeimport.ImportJob;
import io.camunda.tasklist.zeebeimport.ImportListener;
import io.camunda.tasklist.zeebeimport.ImportPositionHolder;
import io.camunda.tasklist.zeebeimport.RecordsReader;
import io.camunda.tasklist.zeebeimport.RecordsReaderHolder;
import java.time.OffsetDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class ImportJobAbstract
implements ImportJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportJob.class);
    protected ImportBatch importBatch;
    protected ImportPositionEntity previousPosition;
    protected ImportPositionEntity lastProcessedPosition;
    protected OffsetDateTime creationTime;
    @Autowired
    protected ImportPositionHolder importPositionHolder;
    @Autowired
    protected RecordsReaderHolder recordsReaderHolder;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    protected ObjectMapper objectMapper;
    @Autowired
    protected TasklistProperties tasklistProperties;
    @Autowired
    private ImportBatchProcessorFactory importBatchProcessorFactory;
    @Autowired(required=false)
    private List<ImportListener> importListeners;

    @Override
    public Boolean call() {
        this.processPossibleIndexChange();
        List<ImportBatch> subBatches = this.createSubBatchesPerIndexName();
        for (ImportBatch subBatch : subBatches) {
            boolean success = this.processOneIndexBatch(subBatch);
            if (success) continue;
            this.notifyImportListenersAsFailed(this.importBatch);
            return false;
        }
        this.importPositionHolder.recordLatestLoadedPosition(this.getLastProcessedPosition());
        for (ImportBatch subBatch : subBatches) {
            this.notifyImportListenersAsFinished(subBatch);
        }
        return true;
    }

    private String extractZeebeVersionFromIndexName(String indexName) {
        String[] split = indexName.split("_");
        String zeebeVersion = split.length >= 3 ? split[2].replace("-snapshot", "") : "0.22.0";
        return zeebeVersion;
    }

    private boolean processOneIndexBatch(ImportBatch subBatch) {
        try {
            String version = this.extractZeebeVersionFromIndexName(subBatch.getLastRecordIndexName());
            ImportBatchProcessor importBatchProcessor = this.importBatchProcessorFactory.getImportBatchProcessor(version);
            importBatchProcessor.performImport(subBatch);
            return true;
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    @Override
    public void recordLatestScheduledPosition() {
        this.importPositionHolder.recordLatestScheduledPosition(this.importBatch.getAliasName(), this.importBatch.getPartitionId(), this.getLastProcessedPosition());
    }

    @Override
    public ImportPositionEntity getLastProcessedPosition() {
        if (this.lastProcessedPosition == null) {
            long lastRecordPosition = this.importBatch.getLastProcessedPosition(this.objectMapper);
            long lastSequence = this.importBatch.getLastProcessedSequence(this.objectMapper);
            this.lastProcessedPosition = lastRecordPosition != 0L || lastSequence != 0L ? ImportPositionEntity.createFrom((long)lastSequence, (ImportPositionEntity)this.previousPosition, (long)lastRecordPosition, (String)this.importBatch.getLastRecordIndexName()) : this.previousPosition;
        }
        return this.lastProcessedPosition;
    }

    @Override
    public boolean indexChange() {
        if (this.importBatch.getLastRecordIndexName() != null && this.previousPosition != null && this.previousPosition.getIndexName() != null) {
            return !this.importBatch.getLastRecordIndexName().equals(this.previousPosition.getIndexName());
        }
        return false;
    }

    protected void notifyImportListenersAsFinished(ImportBatch importBatch) {
        if (this.importListeners != null) {
            for (ImportListener importListener : this.importListeners) {
                importListener.finished(importBatch);
            }
        }
    }

    protected void notifyImportListenersAsFailed(ImportBatch importBatch) {
        if (this.importListeners != null) {
            for (ImportListener importListener : this.importListeners) {
                importListener.failed(importBatch);
            }
        }
    }

    @Override
    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void processPossibleIndexChange() {
        if (this.indexChange() || this.importBatch.hasMoreThanOneUniqueHitId().booleanValue()) {
            this.refreshZeebeIndices();
            RecordsReader recordsReader = this.recordsReaderHolder.getRecordsReader(this.importBatch.getPartitionId(), this.importBatch.getImportValueType());
            if (recordsReader == null) {
                LOGGER.warn("Unable to find records reader for partitionId {} and ImportValueType {}", (Object)this.importBatch.getPartitionId(), (Object)this.importBatch.getImportValueType());
                return;
            }
            try {
                ImportBatch newImportBatch;
                boolean useOnlyPosition = this.tasklistProperties.getImporter().isUseOnlyPosition();
                if (!useOnlyPosition && this.previousPosition.getSequence() > 0L) {
                    newImportBatch = recordsReader.readNextBatchBySequence(this.previousPosition.getSequence(), this.importBatch.getLastProcessedSequence(this.objectMapper));
                    Long lastSequenceFromInitialBatch = this.importBatch.getLastProcessedSequence(this.objectMapper);
                    Long lastSequenceFromNewImportBatch = newImportBatch.getLastProcessedSequence(this.objectMapper);
                    if (newImportBatch == null || newImportBatch.getHits() == null || lastSequenceFromInitialBatch > lastSequenceFromNewImportBatch) {
                        String message = String.format("Warning! Import batch became smaller after reread. Should not happen. Will be retried. Expected last sequence %d, actual last sequence %d.", lastSequenceFromInitialBatch, lastSequenceFromNewImportBatch);
                        throw new TasklistRuntimeException(message);
                    }
                } else {
                    newImportBatch = recordsReader.readNextBatchByPositionAndPartition(this.previousPosition.getPosition(), this.importBatch.getLastProcessedPosition(this.objectMapper));
                    if (newImportBatch == null || newImportBatch.getHits() == null || newImportBatch.getHits().size() < this.importBatch.getHits().size()) {
                        throw new TasklistRuntimeException("Warning! Import batch became smaller after reread. Should not happen. Will be retried.");
                    }
                }
                this.importBatch = newImportBatch;
            }
            catch (NoSuchIndexException ex) {
                LOGGER.warn("Indices are not found" + this.importBatch.toString());
            }
        }
    }
}

