/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport;

import io.camunda.tasklist.property.TasklistProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
public class ImportConfig {
    @Autowired
    private TasklistProperties tasklistProperties;

    @Bean(value={"tasklistImportThreadPoolExecutor"})
    public ThreadPoolTaskExecutor getTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.tasklistProperties.getImporter().getThreadsCount());
        executor.setMaxPoolSize(this.tasklistProperties.getImporter().getThreadsCount());
        executor.setThreadNamePrefix("import_");
        executor.initialize();
        return executor;
    }

    @Bean(value={"tasklistRecordsReaderThreadPoolExecutor"})
    public ThreadPoolTaskScheduler getRecordsReaderTaskExecutor() {
        ThreadPoolTaskScheduler executor = new ThreadPoolTaskScheduler();
        executor.setPoolSize(this.tasklistProperties.getImporter().getReaderThreadsCount());
        executor.setThreadNamePrefix("records_reader_");
        executor.initialize();
        return executor;
    }

    @Bean(value={"tasklistImportPositionUpdateThreadPoolExecutor"})
    public ThreadPoolTaskScheduler getImportPositionUpdateTaskExecutor() {
        ThreadPoolTaskScheduler executor = new ThreadPoolTaskScheduler();
        executor.setPoolSize(1);
        executor.setThreadNamePrefix("import_position_update_");
        executor.initialize();
        return executor;
    }
}

