/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport;

import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.zeebeimport.ImportBatchProcessor;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportBatchProcessorFactory {
    @Autowired
    private List<ImportBatchProcessor> importBatchProcessors;
    private Map<String, ImportBatchProcessor> processorsMap = new HashMap<String, ImportBatchProcessor>();

    @PostConstruct
    private void buildTheMap() {
        for (ImportBatchProcessor importBatchProcessor : this.importBatchProcessors) {
            this.processorsMap.put(importBatchProcessor.getZeebeVersion(), importBatchProcessor);
        }
    }

    public ImportBatchProcessor getImportBatchProcessor(String zeebeVersion) {
        ImportBatchProcessor processor = this.processorsMap.get(zeebeVersion);
        if (processor == null) {
            zeebeVersion = zeebeVersion.substring(0, zeebeVersion.lastIndexOf("."));
            processor = this.processorsMap.get(zeebeVersion);
        }
        if (processor == null) {
            throw new TasklistRuntimeException(String.format("Import is not possible for Zeebe version: %s", zeebeVersion));
        }
        return processor;
    }
}

