/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport;

import io.camunda.tasklist.Metrics;
import io.camunda.tasklist.zeebe.ImportValueType;
import io.camunda.tasklist.zeebeimport.ImportBatch;
import io.camunda.tasklist.zeebeimport.ImportListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventsProcessedMetricsCounterImportListener
implements ImportListener {
    @Autowired
    private Metrics metrics;

    @Override
    public void finished(ImportBatch importBatch) {
        this.metrics.recordCounts("events.processed", (long)importBatch.getRecordsCount(), new String[]{"type", importBatch.getImportValueType().toString(), "partition", String.valueOf(importBatch.getPartitionId()), "status", "succeeded"});
        if (importBatch.getImportValueType() == ImportValueType.PROCESS_INSTANCE) {
            this.metrics.recordCounts("events.processed.finished.process.instances", (long)importBatch.getFinishedWiCount(), new String[0]);
        }
    }

    @Override
    public void failed(ImportBatch importBatch) {
        this.metrics.recordCounts("events.processed", (long)importBatch.getRecordsCount(), new String[]{"type", importBatch.getImportValueType().toString(), "partition", String.valueOf(importBatch.getPartitionId()), "status", "failed"});
    }
}

