/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.entities.FormEntity;
import io.camunda.tasklist.entities.ProcessEntity;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.schema.indices.FormIndex;
import io.camunda.tasklist.schema.indices.ProcessIndex;
import io.camunda.tasklist.util.ConversionUtils;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.camunda.tasklist.zeebeimport.util.XMLUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class CUSTOMCopyProcessesFromOptimize {
    private static final Logger LOGGER = LoggerFactory.getLogger(CUSTOMCopyProcessesFromOptimize.class);
    private static final String OPTIMIZE_PROCESS_INDEX = "optimize-process-definition_v6";
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    private XMLUtil xmlUtil;
    @Autowired
    private ProcessIndex processIndex;
    @Autowired
    private FormIndex formIndex;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyProcesses() {
        String scrollId = null;
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(10);
            SearchRequest searchRequest = new SearchRequest(new String[]{OPTIMIZE_PROCESS_INDEX}).source(searchSourceBuilder).requestCache(Boolean.valueOf(false)).scroll(TimeValue.timeValueMinutes((long)1L));
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            while (searchResponse.getHits().getHits().length > 0) {
                BulkRequest bulkRequest = new BulkRequest();
                for (SearchHit hit : searchResponse.getHits().getHits()) {
                    long processDefinitionKey;
                    Map processFromOptimize = hit.getSourceAsMap();
                    if (processFromOptimize.get("key").equals("customer_onboarding_en") || this.processDefinitionExists(processDefinitionKey = Long.valueOf((String)processFromOptimize.get("id")).longValue(), this.esClient)) continue;
                    HashMap<String, String> userTaskForms = new HashMap<String, String>();
                    ProcessEntity processToTasklist = this.createEntity(processFromOptimize, userTaskForms::put);
                    try {
                        bulkRequest.add(((IndexRequest)new IndexRequest().index(this.processIndex.getFullQualifiedName())).id(ConversionUtils.toStringOrNull((Object)processToTasklist.getKey())).source(this.objectMapper.writeValueAsString((Object)processToTasklist), XContentType.JSON));
                        userTaskForms.forEach((formKey, schema) -> {
                            try {
                                FormEntity formEntity = new FormEntity(String.valueOf(processDefinitionKey), formKey, schema, processToTasklist.getTenantId());
                                if (!this.formExists(formEntity.getId(), this.esClient)) {
                                    this.persistForm(formEntity, bulkRequest);
                                }
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Unable to copy forms from Optimize: " + ex.getMessage(), (Throwable)ex);
                            }
                        });
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
                if (bulkRequest.requests().size() > 0) {
                    this.esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                }
                scrollId = searchResponse.getScrollId();
                SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
                scrollRequest.scroll(TimeValue.timeValueMinutes((long)1L));
                searchResponse = this.esClient.scroll(scrollRequest, RequestOptions.DEFAULT);
                LOGGER.info("Processes were successfully copied from Optimize.");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to copy processes from Optimize: " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (scrollId != null) {
                ElasticsearchUtil.clearScroll(scrollId, (RestHighLevelClient)this.esClient);
            }
        }
    }

    private ProcessEntity createEntity(Map<String, Object> processFromOptimize, BiConsumer<String, String> userTaskFormCollector) {
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setId(String.valueOf(processFromOptimize.get("id")));
        processEntity.setTenantId("<default>");
        processEntity.setKey(Long.valueOf(String.valueOf(processFromOptimize.get("id"))).longValue());
        processEntity.setBpmnProcessId(String.valueOf(processFromOptimize.get("key")));
        processEntity.setVersion(Integer.valueOf(String.valueOf(processFromOptimize.get("version"))));
        processEntity.setName(String.valueOf(processFromOptimize.get("name")));
        String bpmXml = String.valueOf(processFromOptimize.get("bpmn20Xml"));
        this.xmlUtil.extractDiagramData(bpmXml.getBytes(), processEntity.getBpmnProcessId()::equals, arg_0 -> ((ProcessEntity)processEntity).setName(arg_0), flowNode -> processEntity.getFlowNodes().add(flowNode), userTaskFormCollector, arg_0 -> ((ProcessEntity)processEntity).setFormKey(arg_0), formId -> processEntity.setFormId(formId), arg_0 -> ((ProcessEntity)processEntity).setStartedByForm(arg_0));
        return processEntity;
    }

    private boolean processDefinitionExists(long processDefinitionKey, RestHighLevelClient elasticsearchClient) throws IOException {
        return elasticsearchClient.exists(new GetRequest(this.processIndex.getFullQualifiedName(), String.valueOf(processDefinitionKey)), RequestOptions.DEFAULT);
    }

    private boolean formExists(String formId, RestHighLevelClient elasticsearchClient) throws IOException {
        return elasticsearchClient.exists(new GetRequest(this.formIndex.getFullQualifiedName(), formId), RequestOptions.DEFAULT);
    }

    private void persistForm(FormEntity formEntity, BulkRequest bulkRequest) throws PersistenceException {
        LOGGER.debug("Form: key {}", (Object)formEntity.getId());
        try {
            bulkRequest.add(((IndexRequest)new IndexRequest().index(this.formIndex.getFullQualifiedName())).id(ConversionUtils.toStringOrNull((Object)formEntity.getId())).source(this.objectMapper.writeValueAsString((Object)formEntity), XContentType.JSON));
        }
        catch (JsonProcessingException e) {
            throw new PersistenceException(String.format("Error preparing the query to insert task form [%s]", formEntity.getId()), (Throwable)e);
        }
    }
}

