/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.camunda.tasklist.zeebe.ImportValueType;
import io.camunda.tasklist.zeebeimport.ImportBatch;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportBatchElasticSearch
implements ImportBatch {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportBatchElasticSearch.class);
    private int partitionId;
    private ImportValueType importValueType;
    private List<SearchHit> hits;
    private String lastRecordIndexName;
    private int finishedWiCount = 0;

    public ImportBatchElasticSearch(int partitionId, ImportValueType importValueType, List<SearchHit> hits, String lastRecordIndexName) {
        this.partitionId = partitionId;
        this.importValueType = importValueType;
        this.hits = hits;
        this.lastRecordIndexName = lastRecordIndexName;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    @Override
    public ImportValueType getImportValueType() {
        return this.importValueType;
    }

    @Override
    public void setImportValueType(ImportValueType importValueType) {
        this.importValueType = importValueType;
    }

    @Override
    public List<SearchHit> getHits() {
        return this.hits;
    }

    @Override
    public void setHits(List hits) {
        this.hits = hits;
    }

    @Override
    public int getRecordsCount() {
        return this.hits.size();
    }

    @Override
    public void incrementFinishedWiCount() {
        ++this.finishedWiCount;
    }

    @Override
    public int getFinishedWiCount() {
        return this.finishedWiCount;
    }

    @Override
    public String getLastRecordIndexName() {
        return this.lastRecordIndexName;
    }

    @Override
    public void setLastRecordIndexName(String lastRecordIndexName) {
        this.lastRecordIndexName = lastRecordIndexName;
    }

    @Override
    public long getLastProcessedPosition(ObjectMapper objectMapper) {
        return this.getLastProcessed("position", objectMapper, 0L);
    }

    @Override
    public Long getLastProcessedSequence(ObjectMapper objectMapper) {
        return this.getLastProcessed("sequence", objectMapper, 0L);
    }

    private long getLastProcessed(String fieldName, ObjectMapper objectMapper, Long defaultValue) {
        try {
            ObjectNode node;
            if (this.hits != null && this.hits.size() != 0 && (node = (ObjectNode)objectMapper.readValue(this.hits.get(this.hits.size() - 1).getSourceAsString(), ObjectNode.class)).has(fieldName)) {
                return node.get(fieldName).longValue();
            }
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Unable to parse Zeebe object for getting field %s : %s", fieldName, e.getMessage()), (Throwable)e);
        }
        return defaultValue;
    }

    @Override
    public String getAliasName() {
        return this.importValueType.getAliasTemplate();
    }

    @Override
    public Boolean hasMoreThanOneUniqueHitId() {
        return this.hits.stream().map(SearchHit::getIndex).collect(Collectors.toSet()).size() > 1;
    }

    public int hashCode() {
        int result = this.partitionId;
        result = 31 * result + (this.importValueType != null ? this.importValueType.hashCode() : 0);
        result = 31 * result + (this.hits != null ? this.hits.hashCode() : 0);
        result = 31 * result + (this.lastRecordIndexName != null ? this.lastRecordIndexName.hashCode() : 0);
        result = 31 * result + this.finishedWiCount;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportBatchElasticSearch that = (ImportBatchElasticSearch)o;
        if (this.partitionId != that.partitionId) {
            return false;
        }
        if (this.finishedWiCount != that.finishedWiCount) {
            return false;
        }
        if (this.importValueType != that.importValueType) {
            return false;
        }
        if (this.hits != null ? !this.hits.equals(that.hits) : that.hits != null) {
            return false;
        }
        return this.lastRecordIndexName != null ? this.lastRecordIndexName.equals(that.lastRecordIndexName) : that.lastRecordIndexName == null;
    }
}

