/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.common;

import io.camunda.tasklist.schema.indices.FormIndex;
import io.camunda.tasklist.schema.indices.ProcessIndex;
import io.camunda.tasklist.schema.templates.DraftTaskVariableTemplate;
import io.camunda.tasklist.store.DraftVariableStore;
import io.camunda.tasklist.store.FormStore;
import io.camunda.tasklist.store.TaskStore;
import io.camunda.tasklist.store.VariableStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessDefinitionDeletionProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDefinitionDeletionProcessor.class);
    @Autowired
    private ProcessIndex processIndex;
    @Autowired
    private FormIndex formIndex;
    @Autowired
    private FormStore formStore;
    @Autowired
    private TaskStore taskStore;
    @Autowired
    private VariableStore variableStore;
    @Autowired
    private DraftTaskVariableTemplate draftTaskVariableTemplate;
    @Autowired
    private DraftVariableStore draftVariableStore;

    public <T> List<T> createProcessDefinitionDeleteRequests(String processDefinitionId, BiFunction<String, String, T> deleteRequestBuilder) {
        Map taskIdsToIndex = this.taskStore.getTaskIdsWithIndexByProcessDefinitionId(processDefinitionId);
        LinkedList taskIds = new LinkedList(taskIdsToIndex.keySet());
        Map taskVariablesIdsToIndex = taskIdsToIndex.isEmpty() ? Collections.emptyMap() : this.variableStore.getTaskVariablesIdsWithIndexByTaskIds(taskIds);
        List draftVariableIds = this.draftVariableStore.getDraftVariablesIdsByTaskIds(taskIds);
        List embeddedFormIds = this.formStore.getFormIdsByProcessDefinitionId(processDefinitionId);
        LOGGER.info("Deleting process definition (id={}) related objects | {} taskVariables | {} draftVariables | {} tasks | {} embeddedForms", new Object[]{processDefinitionId, taskVariablesIdsToIndex.size(), draftVariableIds.size(), taskIdsToIndex.size(), embeddedFormIds.size()});
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(this.createDeleteRequestList(taskVariablesIdsToIndex, deleteRequestBuilder));
        result.addAll(this.createDeleteRequestList(draftVariableIds, this.draftTaskVariableTemplate.getFullQualifiedName(), deleteRequestBuilder));
        result.addAll(this.createDeleteRequestList(taskIdsToIndex, deleteRequestBuilder));
        result.addAll(this.createDeleteRequestList(embeddedFormIds, this.formIndex.getFullQualifiedName(), deleteRequestBuilder));
        result.addAll(this.createDeleteRequestList(List.of(processDefinitionId), this.processIndex.getFullQualifiedName(), deleteRequestBuilder));
        return result;
    }

    private <T> List<T> createDeleteRequestList(List<String> ids, String indexName, BiFunction<String, String, T> deleteRequestBuilder) {
        return ids.stream().map(id -> deleteRequestBuilder.apply(indexName, (String)id)).collect(Collectors.toList());
    }

    private <T> List<T> createDeleteRequestList(Map<String, String> idsToIndex, BiFunction<String, String, T> deleteRequestBuilder) {
        return idsToIndex.entrySet().stream().map(entry -> deleteRequestBuilder.apply((String)entry.getValue(), (String)entry.getKey())).collect(Collectors.toList());
    }
}

