/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.util;

import io.camunda.tasklist.entities.FlowNodeInstanceEntity;
import io.camunda.tasklist.entities.VariableEntity;
import io.camunda.tasklist.store.VariableStore;
import io.camunda.tasklist.util.CollectionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskVariableSearchUtil {
    private static final String ABSENT_PARENT_ID = "-1";
    @Autowired
    private VariableStore variableStore;

    public Boolean checkIfVariablesExistInTask(List<VariableStore.GetVariablesRequest> requests, Map<String, String> variableNameAndVar) {
        Map<String, VariableStore.FlowNodeTree> flowNodeTrees = this.buildFlowNodeTrees(requests);
        List<String> flowNodeInstanceIds = flowNodeTrees.values().stream().flatMap(f -> f.getFlowNodeInstanceIds().stream()).collect(Collectors.toList());
        Map<String, VariableStore.VariableMap> variableMaps = this.buildVariableMaps(flowNodeInstanceIds, requests.stream().map(VariableStore.GetVariablesRequest::getVarNames).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList()), requests.get(0).getFieldNames());
        Map<String, List<VariableEntity>> variables = this.buildResponse(flowNodeTrees, variableMaps, requests);
        for (Map.Entry<String, List<VariableEntity>> taskEntry : variables.entrySet()) {
            List<VariableEntity> taskVariables = taskEntry.getValue();
            for (Map.Entry<String, String> variableEntry : variableNameAndVar.entrySet()) {
                String requiredVarName = variableEntry.getKey();
                String requiredVarValue = variableEntry.getValue();
                boolean exists = taskVariables.stream().anyMatch(varEntity -> requiredVarName.equals(varEntity.getName()) && requiredVarValue.equals(varEntity.getValue()));
                if (exists) continue;
                return false;
            }
        }
        return true;
    }

    private Map<String, VariableStore.FlowNodeTree> buildFlowNodeTrees(List<VariableStore.GetVariablesRequest> requests) {
        List processInstanceIds = CollectionUtil.map(requests, VariableStore.GetVariablesRequest::getProcessInstanceId);
        List<FlowNodeInstanceEntity> flowNodeInstances = this.variableStore.getFlowNodeInstances(processInstanceIds);
        HashMap<String, VariableStore.FlowNodeTree> flowNodeTrees = new HashMap<String, VariableStore.FlowNodeTree>();
        for (FlowNodeInstanceEntity flowNodeInstance : flowNodeInstances) {
            this.getFlowNodeTree(flowNodeTrees, flowNodeInstance.getProcessInstanceId()).setParent(flowNodeInstance.getId(), flowNodeInstance.getParentFlowNodeId());
        }
        return flowNodeTrees;
    }

    private VariableStore.FlowNodeTree getFlowNodeTree(Map<String, VariableStore.FlowNodeTree> flowNodeTrees, String processInstanceId) {
        if (flowNodeTrees.get(processInstanceId) == null) {
            flowNodeTrees.put(processInstanceId, new VariableStore.FlowNodeTree());
        }
        return flowNodeTrees.get(processInstanceId);
    }

    private Map<String, VariableStore.VariableMap> buildVariableMaps(List<String> flowNodeInstanceIds, List<String> varNames, Set<String> fieldNames) {
        List<VariableEntity> variables = this.variableStore.getVariablesByFlowNodeInstanceIds(flowNodeInstanceIds, varNames, fieldNames);
        return variables.stream().collect(Collectors.groupingBy(VariableEntity::getScopeFlowNodeId, this.getVariableMapCollector()));
    }

    private Collector<VariableEntity, VariableStore.VariableMap, VariableStore.VariableMap> getVariableMapCollector() {
        return Collector.of(VariableStore.VariableMap::new, (map, var) -> map.put(var.getName(), var), (map1, map2) -> {
            map1.putAll((VariableStore.VariableMap)map2);
            return map1;
        }, new Collector.Characteristics[0]);
    }

    private Map<String, List<VariableEntity>> buildResponse(Map<String, VariableStore.FlowNodeTree> flowNodeTrees, Map<String, VariableStore.VariableMap> variableMaps, List<VariableStore.GetVariablesRequest> requests) {
        HashMap<String, List<VariableEntity>> response = new HashMap<String, List<VariableEntity>>();
        for (VariableStore.GetVariablesRequest req : requests) {
            VariableStore.FlowNodeTree flowNodeTree = flowNodeTrees.get(req.getProcessInstanceId());
            VariableStore.VariableMap resultingVariableMap = new VariableStore.VariableMap();
            this.accumulateVariables(resultingVariableMap, variableMaps, flowNodeTree, req.getFlowNodeInstanceId());
            response.put(req.getTaskId(), resultingVariableMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (VariableEntity)e.getValue()).collect(Collectors.toList()));
        }
        return response;
    }

    private void accumulateVariables(VariableStore.VariableMap resultingVariableMap, Map<String, VariableStore.VariableMap> variableMaps, VariableStore.FlowNodeTree flowNodeTree, String flowNodeInstanceId) {
        String parentFlowNodeId;
        VariableStore.VariableMap m = variableMaps.get(flowNodeInstanceId);
        if (m != null) {
            resultingVariableMap.putAll(m);
        }
        String string = parentFlowNodeId = flowNodeTree != null ? flowNodeTree.getParent(flowNodeInstanceId) : null;
        if (parentFlowNodeId != null && !parentFlowNodeId.equals(ABSENT_PARENT_ID)) {
            this.accumulateVariables(resultingVariableMap, variableMaps, flowNodeTree, parentFlowNodeId);
        }
    }
}

