/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.CommonUtils;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.listview.VariableListViewEntity;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.schema.templates.TasklistListViewTemplate;
import io.camunda.tasklist.store.ListViewStore;
import io.camunda.tasklist.util.OpenSearchUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.DeleteOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.util.ObjectBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ListViewStoreOpenSearch
implements ListViewStore {
    private static final Logger LOGGER = Logger.getLogger(ListViewStoreOpenSearch.class.getName());
    @Autowired
    @Qualifier(value="tasklistOsClient")
    private OpenSearchClient osClient;
    @Autowired
    private TasklistListViewTemplate tasklistListViewTemplate;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    @Override
    public void removeVariableByFlowNodeInstanceId(String flowNodeInstanceId) {
        try {
            SearchRequest.Builder searchRequest = OpenSearchUtil.createSearchRequest(this.tasklistListViewTemplate).query(q -> q.term(t -> t.field("scopeKey").value(FieldValue.of((String)flowNodeInstanceId))));
            OpenSearchUtil.scrollWith(searchRequest, this.osClient, hits -> {
                ArrayList<BulkOperation> bulkOperations = new ArrayList<BulkOperation>();
                for (Hit hit : hits) {
                    VariableListViewEntity variableListViewEntity = (VariableListViewEntity)hit.source();
                    BulkOperation bulkOperation = (BulkOperation)new BulkOperation.Builder().delete(d -> (ObjectBuilder)((DeleteOperation.Builder)((DeleteOperation.Builder)d.index(this.tasklistListViewTemplate.getFullQualifiedName())).id(variableListViewEntity.getId())).routing(flowNodeInstanceId)).build();
                    bulkOperations.add(bulkOperation);
                }
                if (!bulkOperations.isEmpty()) {
                    BulkRequest.Builder bulkRequest = new BulkRequest.Builder().operations(bulkOperations);
                    try {
                        OpenSearchUtil.processBulkRequest(this.osClient, bulkRequest.build());
                    }
                    catch (PersistenceException e) {
                        throw new TasklistRuntimeException(String.format("Error removing set of variables for flowNodeInstanceId [%s]", flowNodeInstanceId), (Throwable)e);
                    }
                }
            }, null, VariableListViewEntity.class, null);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error deleting task variables for flowNodeInstanceId [%s]", flowNodeInstanceId), (Throwable)e);
        }
    }

    @Override
    public List<VariableListViewEntity> getVariablesByVariableName(String varName) {
        ArrayList<VariableListViewEntity> variableList = new ArrayList<VariableListViewEntity>();
        try {
            SearchRequest.Builder searchRequest = new SearchRequest.Builder().index(this.tasklistListViewTemplate.getAlias(), new String[0]).query(q -> q.term(t -> t.field("name").value(FieldValue.of((String)varName))));
            OpenSearchUtil.scrollWith(searchRequest, this.osClient, hits -> hits.stream().map(Hit::source).filter(Objects::nonNull).map(v -> (VariableListViewEntity)this.objectMapper.convertValue(v, VariableListViewEntity.class)).forEach(variableList::add), null, VariableListViewEntity.class, null);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error retrieving variables for variable name [%s]", varName), (Throwable)e);
        }
        return variableList;
    }

    @Override
    public void persistTaskVariables(Collection<VariableListViewEntity> finalVariables) {
        if (finalVariables.isEmpty()) {
            return;
        }
        try {
            BulkRequest.Builder bulkRequest = new BulkRequest.Builder();
            for (VariableListViewEntity variableEntity : finalVariables) {
                bulkRequest.operations(op -> op.update(this.createUpsertRequest(variableEntity)));
            }
            this.osClient.bulk(bulkRequest.build());
        }
        catch (IOException e) {
            throw new TasklistRuntimeException("Error processing bulk request for task variables", (Throwable)e);
        }
    }

    private UpdateOperation<Object> createUpsertRequest(VariableListViewEntity variableListViewEntity) {
        HashMap<String, String> updateFields = new HashMap<String, String>();
        updateFields.put("name", variableListViewEntity.getName());
        updateFields.put("value", variableListViewEntity.getValue());
        updateFields.put("fullValue", variableListViewEntity.getFullValue());
        updateFields.put("join", (String)variableListViewEntity.getJoin());
        return ((UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)new UpdateOperation.Builder().index(this.tasklistListViewTemplate.getFullQualifiedName())).routing(variableListViewEntity.getScopeKey())).id(variableListViewEntity.getId())).document((Object)CommonUtils.getJsonObjectFromEntity(updateFields)).upsert((Object)CommonUtils.getJsonObjectFromEntity((Object)variableListViewEntity)).retryOnConflict(Integer.valueOf(3)).build();
    }
}

