/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.entities.TaskEntity;
import io.camunda.tasklist.entities.TaskState;
import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.queries.RangeValueFilter;
import io.camunda.tasklist.queries.Sort;
import io.camunda.tasklist.queries.TaskByVariables;
import io.camunda.tasklist.queries.TaskOrderBy;
import io.camunda.tasklist.queries.TaskQuery;
import io.camunda.tasklist.queries.TaskSortFields;
import io.camunda.tasklist.schema.templates.TaskTemplate;
import io.camunda.tasklist.schema.templates.TaskVariableTemplate;
import io.camunda.tasklist.store.TaskStore;
import io.camunda.tasklist.store.VariableStore;
import io.camunda.tasklist.store.util.TaskVariableSearchUtil;
import io.camunda.tasklist.tenant.TenantAwareElasticsearchClient;
import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.camunda.tasklist.views.TaskSearchView;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class TaskStoreElasticSearch
implements TaskStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStoreElasticSearch.class);
    private static final Map<TaskState, String> SORT_FIELD_PER_STATE = Map.of(TaskState.CREATED, "creationTime", TaskState.COMPLETED, "completionTime", TaskState.CANCELED, "completionTime");
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    private TenantAwareElasticsearchClient tenantAwareClient;
    @Autowired
    private TaskVariableSearchUtil taskVariableSearchUtil;
    @Autowired
    private TaskTemplate taskTemplate;
    @Autowired
    private VariableStore variableStoreElasticSearch;
    @Autowired
    private TaskVariableTemplate taskVariableTemplate;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    @Override
    public TaskEntity getTask(String id) {
        try {
            SearchHit response = ElasticsearchUtil.getRawResponseWithTenantCheck(id, this.taskTemplate, ElasticsearchUtil.QueryType.ALL, this.tenantAwareClient);
            return ElasticsearchUtil.fromSearchHit(response.getSourceAsString(), this.objectMapper, TaskEntity.class);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<String> getTaskIdsByProcessInstanceId(String processInstanceId) {
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.taskTemplate).source(SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.termQuery((String)"processInstanceId", (String)processInstanceId)).fetchField("id"));
        try {
            return ElasticsearchUtil.scrollIdsToList(searchRequest, this.esClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getTaskIdsWithIndexByProcessDefinitionId(String processDefinitionId) {
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.taskTemplate).source(SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.termQuery((String)"processDefinitionId", (String)processDefinitionId)).fetchField("id"));
        try {
            return ElasticsearchUtil.scrollIdsWithIndexToMap(searchRequest, this.esClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<TaskSearchView> getTasks(TaskQuery query) {
        List<TaskSearchView> response = this.queryTasks(query);
        if (query.getSearchAfterOrEqual() != null || query.getSearchBeforeOrEqual() != null) {
            this.adjustResponse(response, query);
        }
        if (response.size() > 0 && (query.getSearchAfter() != null || query.getSearchAfterOrEqual() != null)) {
            TaskSearchView firstTask = response.get(0);
            firstTask.setFirst(this.checkTaskIsFirst(query, firstTask.getId()));
        }
        return response;
    }

    @Override
    public TaskEntity persistTaskCompletion(TaskEntity taskBefore) {
        SearchHit taskBeforeSearchHit;
        try {
            taskBeforeSearchHit = ElasticsearchUtil.getRawResponseWithTenantCheck(taskBefore.getId(), this.taskTemplate, ElasticsearchUtil.QueryType.ALL, this.tenantAwareClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
        TaskEntity completedTask = taskBefore.makeCopy().setState(TaskState.COMPLETED).setCompletionTime(OffsetDateTime.now());
        try {
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            updateFields.put("state", completedTask.getState());
            updateFields.put("completionTime", completedTask.getCompletionTime());
            Map jsonMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class);
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(this.taskTemplate.getFullQualifiedName())).id(taskBeforeSearchHit.getId()).doc(jsonMap).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL).setIfSeqNo(taskBeforeSearchHit.getSeqNo()).setIfPrimaryTerm(taskBeforeSearchHit.getPrimaryTerm());
            ElasticsearchUtil.executeUpdate(this.esClient, updateRequest);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return completedTask;
    }

    @Override
    public TaskEntity rollbackPersistTaskCompletion(TaskEntity taskBefore) {
        SearchHit taskBeforeSearchHit;
        try {
            taskBeforeSearchHit = ElasticsearchUtil.getRawResponseWithTenantCheck(taskBefore.getId(), this.taskTemplate, ElasticsearchUtil.QueryType.ALL, this.tenantAwareClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
        TaskEntity completedTask = taskBefore.makeCopy().setCompletionTime(null);
        try {
            HashMap<String, TaskState> updateFields = new HashMap<String, TaskState>();
            updateFields.put("state", completedTask.getState());
            updateFields.put("completionTime", null);
            Map jsonMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class);
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(this.taskTemplate.getFullQualifiedName())).id(taskBeforeSearchHit.getId()).doc(jsonMap).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL).setIfSeqNo(taskBeforeSearchHit.getSeqNo()).setIfPrimaryTerm(taskBeforeSearchHit.getPrimaryTerm());
            ElasticsearchUtil.executeUpdate(this.esClient, updateRequest);
        }
        catch (Exception e) {
            LOGGER.error("Error when trying to rollback Task to CREATED state: {}", (Object)e.getMessage());
        }
        return completedTask;
    }

    @Override
    public TaskEntity persistTaskClaim(TaskEntity taskBefore, String assignee) {
        this.updateTask(taskBefore.getId(), CollectionUtil.asMap((Object[])new Object[]{"assignee", assignee}));
        return taskBefore.makeCopy().setAssignee(assignee);
    }

    @Override
    public TaskEntity persistTaskUnclaim(TaskEntity task) {
        this.updateTask(task.getId(), CollectionUtil.asMap((Object[])new Object[]{"assignee", null}));
        return task.makeCopy().setAssignee(null);
    }

    @Override
    public List<TaskEntity> getTasksById(List<String> ids) {
        try {
            SearchHit[] response = this.getTasksRawResponse(ids);
            return ElasticsearchUtil.mapSearchHits(response, this.objectMapper, TaskEntity.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SearchHit[] getTasksRawResponse(List<String> ids) throws IOException {
        IdsQueryBuilder query = QueryBuilders.idsQuery().addIds(new String[]{Arrays.toString(ids.toArray())});
        SearchRequest request = ElasticsearchUtil.createSearchRequest(this.taskTemplate).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)query)));
        SearchResponse response = this.tenantAwareClient.search(request);
        if (response.getHits().getTotalHits().value > 0L) {
            return response.getHits().getHits();
        }
        throw new NotFoundException(String.format("No tasks were found for ids %s", ids));
    }

    private List<TaskSearchView> mapTasksFromEntity(SearchResponse response) {
        return ElasticsearchUtil.mapSearchHits(response.getHits().getHits(), sh -> TaskSearchView.createFrom((TaskEntity)ElasticsearchUtil.fromSearchHit(sh.getSourceAsString(), this.objectMapper, TaskEntity.class), (Object[])sh.getSortValues()));
    }

    private void adjustResponse(List<TaskSearchView> response, TaskQuery request) {
        String taskId = null;
        if (request.getSearchAfterOrEqual() != null) {
            taskId = request.getSearchAfterOrEqual()[1];
        } else if (request.getSearchBeforeOrEqual() != null) {
            taskId = request.getSearchBeforeOrEqual()[1];
        }
        TaskQuery newRequest = request.createCopy().setSearchAfter(null).setSearchAfterOrEqual(null).setSearchBefore(null).setSearchBeforeOrEqual(null);
        List<TaskSearchView> tasks = this.queryTasks(newRequest, taskId);
        if (tasks.size() > 0) {
            TaskSearchView entity = tasks.get(0);
            entity.setFirst(false);
            if (request.getSearchAfterOrEqual() != null) {
                if (response.size() == request.getPageSize()) {
                    response.remove(response.size() - 1);
                }
                response.add(0, entity);
            } else if (request.getSearchBeforeOrEqual() != null) {
                if (response.size() == request.getPageSize()) {
                    response.remove(0);
                }
                response.add(entity);
            }
        }
    }

    private List<TaskSearchView> queryTasks(TaskQuery query) {
        return this.queryTasks(query, null);
    }

    private List<TaskSearchView> queryTasks(TaskQuery query, String taskId) {
        List<String> tasksIds = null;
        if (query.getTaskVariables() != null && query.getTaskVariables().length > 0 && (tasksIds = this.getTasksContainsVarNameAndValue(query.getTaskVariables())).isEmpty()) {
            return new ArrayList<TaskSearchView>();
        }
        if (taskId != null && !taskId.isEmpty()) {
            if (query.getTaskVariables() != null && query.getTaskVariables().length > 0) {
                if ((tasksIds = tasksIds.stream().filter(id -> !id.equals(taskId)).collect(Collectors.toList())).isEmpty()) {
                    return new ArrayList<TaskSearchView>();
                }
            } else {
                tasksIds = new ArrayList<String>();
                tasksIds.add(taskId);
            }
        }
        QueryBuilder esQuery = this.buildQuery(query, tasksIds);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query(esQuery);
        this.applySorting(sourceBuilder, query);
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.taskTemplate, TaskStoreElasticSearch.getQueryTypeByTaskState(query.getState())).source(sourceBuilder);
        try {
            SearchResponse response = query.getTenantIds() == null ? this.tenantAwareClient.search(searchRequest) : this.tenantAwareClient.searchByTenantIds(searchRequest, Set.of(query.getTenantIds()));
            List<TaskSearchView> tasks = this.mapTasksFromEntity(response);
            if (!tasks.isEmpty()) {
                if (query.getSearchBefore() != null || query.getSearchBeforeOrEqual() != null) {
                    if (tasks.size() <= query.getPageSize()) {
                        tasks.get(tasks.size() - 1).setFirst(true);
                    } else {
                        tasks.remove(tasks.size() - 1);
                    }
                    Collections.reverse(tasks);
                } else if (query.getSearchAfter() == null && query.getSearchAfterOrEqual() == null) {
                    tasks.get(0).setFirst(true);
                }
            }
            return tasks;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining tasks: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    private static ElasticsearchUtil.QueryType getQueryTypeByTaskState(TaskState taskState) {
        return TaskState.CREATED == taskState ? ElasticsearchUtil.QueryType.ONLY_RUNTIME : ElasticsearchUtil.QueryType.ALL;
    }

    private boolean checkTaskIsFirst(TaskQuery query, String id) {
        TaskQuery newRequest = query.createCopy().setSearchAfter(null).setSearchAfterOrEqual(null).setSearchBefore(null).setSearchBeforeOrEqual(null).setPageSize(1);
        List<TaskSearchView> tasks = this.queryTasks(newRequest, null);
        if (tasks.size() > 0) {
            return tasks.get(0).getId().equals(id);
        }
        return false;
    }

    private QueryBuilder buildQuery(TaskQuery query, List<String> taskIds) {
        QueryBuilder priorityQ;
        QueryBuilder jointQ;
        BoolQueryBuilder stateQ = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)TaskState.CANCELED));
        if (query.getState() != null) {
            stateQ = QueryBuilders.termQuery((String)"state", (Object)query.getState());
        }
        Object assignedQ = null;
        TermQueryBuilder assigneeQ = null;
        if (query.getAssigned() != null) {
            assignedQ = query.getAssigned() != false ? QueryBuilders.existsQuery((String)"assignee") : QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"assignee"));
        }
        if (query.getAssignee() != null) {
            assigneeQ = QueryBuilders.termQuery((String)"assignee", (String)query.getAssignee());
        }
        TermsQueryBuilder assigneesQ = null;
        if (query.getAssignees() != null) {
            assigneesQ = QueryBuilders.termsQuery((String)"assignee", (String[])query.getAssignees());
        }
        IdsQueryBuilder idsQuery = null;
        if (taskIds != null) {
            idsQuery = QueryBuilders.idsQuery().addIds(taskIds.toArray(new String[0]));
        }
        TermQueryBuilder taskDefinitionQ = null;
        if (query.getTaskDefinitionId() != null) {
            taskDefinitionQ = QueryBuilders.termQuery((String)"flowNodeBpmnId", (String)query.getTaskDefinitionId());
        }
        TermQueryBuilder candidateGroupQ = null;
        if (query.getCandidateGroup() != null) {
            candidateGroupQ = QueryBuilders.termQuery((String)"candidateGroups", (String)query.getCandidateGroup());
        }
        TermsQueryBuilder candidateGroupsQ = null;
        if (query.getCandidateGroups() != null) {
            candidateGroupsQ = QueryBuilders.termsQuery((String)"candidateGroups", (String[])query.getCandidateGroups());
        }
        TermQueryBuilder candidateUserQ = null;
        if (query.getCandidateUser() != null) {
            candidateUserQ = QueryBuilders.termQuery((String)"candidateUsers", (String)query.getCandidateUser());
        }
        TermsQueryBuilder candidateUsersQ = null;
        if (query.getCandidateUsers() != null) {
            candidateUsersQ = QueryBuilders.termsQuery((String)"candidateUsers", (String[])query.getCandidateUsers());
        }
        BoolQueryBuilder candidateGroupsAndUserByCurrentUserQ = null;
        if (query.getTaskByCandidateUserOrGroups() != null) {
            candidateGroupsAndUserByCurrentUserQ = this.returnUserGroupBoolQuery(List.of(query.getTaskByCandidateUserOrGroups().getUserGroups()), query.getTaskByCandidateUserOrGroups().getUserName());
        }
        TermQueryBuilder processInstanceIdQ = null;
        if (query.getProcessInstanceId() != null) {
            processInstanceIdQ = QueryBuilders.termQuery((String)"processInstanceId", (String)query.getProcessInstanceId());
        }
        TermQueryBuilder processDefinitionIdQ = null;
        if (query.getProcessDefinitionId() != null) {
            processDefinitionIdQ = QueryBuilders.termQuery((String)"processDefinitionId", (String)query.getProcessDefinitionId());
        }
        RangeQueryBuilder followUpQ = null;
        if (query.getFollowUpDate() != null) {
            followUpQ = QueryBuilders.rangeQuery((String)"followUpDate").from((Object)query.getFollowUpDate().getFrom()).to((Object)query.getFollowUpDate().getTo());
        }
        RangeQueryBuilder dueDateQ = null;
        if (query.getDueDate() != null) {
            dueDateQ = QueryBuilders.rangeQuery((String)"dueDate").from((Object)query.getDueDate().getFrom()).to((Object)query.getDueDate().getTo());
        }
        TermQueryBuilder implementationQ = null;
        if (query.getImplementation() != null) {
            implementationQ = QueryBuilders.termQuery((String)"implementation", (Object)query.getImplementation());
        }
        if ((jointQ = ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{stateQ, assignedQ, assigneeQ, assigneesQ, idsQuery, taskDefinitionQ, candidateGroupQ, candidateGroupsQ, candidateUserQ, candidateUsersQ, candidateGroupsAndUserByCurrentUserQ, processInstanceIdQ, processDefinitionIdQ, followUpQ, dueDateQ, implementationQ, priorityQ = this.buildPriorityQuery(query)})) == null) {
            jointQ = QueryBuilders.matchAllQuery();
        }
        return QueryBuilders.constantScoreQuery((QueryBuilder)jointQ);
    }

    private void applySorting(SearchSourceBuilder searchSourceBuilder, TaskQuery query) {
        SortBuilder sort2;
        boolean isSortOnRequest = query.getSort() != null;
        boolean directSorting = query.getSearchAfter() != null || query.getSearchAfterOrEqual() != null || query.getSearchBefore() == null && query.getSearchBeforeOrEqual() == null;
        Object[] querySearchAfter = null;
        if (directSorting) {
            sort2 = SortBuilders.fieldSort((String)"key").order(SortOrder.ASC);
            if (query.getSearchAfter() != null) {
                querySearchAfter = query.getSearchAfter();
            } else if (query.getSearchAfterOrEqual() != null) {
                querySearchAfter = query.getSearchAfterOrEqual();
            }
        } else {
            sort2 = SortBuilders.fieldSort((String)"key").order(SortOrder.DESC);
            if (query.getSearchBefore() != null) {
                querySearchAfter = query.getSearchBefore();
            } else if (query.getSearchBeforeOrEqual() != null) {
                querySearchAfter = query.getSearchBeforeOrEqual();
            }
        }
        if (isSortOnRequest) {
            for (int i = 0; i < query.getSort().length; ++i) {
                SortOrder sortOrder;
                TaskOrderBy orderBy = query.getSort()[i];
                String field = orderBy.getField().toString();
                SortOrder sortOrder2 = directSorting ? (orderBy.getOrder().equals((Object)Sort.DESC) ? SortOrder.DESC : SortOrder.ASC) : (sortOrder = orderBy.getOrder().equals((Object)Sort.DESC) ? SortOrder.ASC : SortOrder.DESC);
                if (!orderBy.getField().equals((Object)TaskSortFields.priority)) {
                    searchSourceBuilder.sort(this.applyDateSortScript(orderBy.getOrder(), field, sortOrder));
                    continue;
                }
                searchSourceBuilder.sort(this.mapNullInSort("priority", "50", sortOrder, ScriptSortBuilder.ScriptSortType.NUMBER));
            }
        } else {
            String sort1Field = (String)CollectionUtil.getOrDefaultFromMap(SORT_FIELD_PER_STATE, (Object)query.getState(), (Object)"creationTime");
            FieldSortBuilder sort1 = directSorting ? ((FieldSortBuilder)SortBuilders.fieldSort((String)sort1Field).order(SortOrder.DESC)).missing((Object)"_last") : ((FieldSortBuilder)SortBuilders.fieldSort((String)sort1Field).order(SortOrder.ASC)).missing((Object)"_first");
            searchSourceBuilder.sort((SortBuilder)sort1);
        }
        searchSourceBuilder.sort(sort2);
        if (query.getSearchBefore() != null || query.getSearchBeforeOrEqual() != null) {
            searchSourceBuilder.size(query.getPageSize() + 1);
        } else {
            searchSourceBuilder.size(query.getPageSize());
        }
        if (querySearchAfter != null) {
            searchSourceBuilder.searchAfter(querySearchAfter);
        }
    }

    private SortBuilder<?> applyDateSortScript(Sort sorting, String field, SortOrder sortOrder) {
        String nullDate = sorting.equals((Object)Sort.ASC) ? "2099-12-31" : "1900-01-01";
        Script script = new Script("def sf = new SimpleDateFormat(\"yyyy-MM-dd\"); def nullDate=sf.parse('" + nullDate + "');if(doc['" + field + "'].size() == 0){nullDate.getTime().toString()}else{doc['" + field + "'].value.getMillis().toString()}");
        return SortBuilders.scriptSort((Script)script, (ScriptSortBuilder.ScriptSortType)ScriptSortBuilder.ScriptSortType.STRING).order(sortOrder);
    }

    private void updateTask(String taskId, Map<String, Object> updateFields) {
        try {
            SearchHit searchHit = ElasticsearchUtil.getRawResponseWithTenantCheck(taskId, this.taskTemplate, ElasticsearchUtil.QueryType.ALL, this.tenantAwareClient);
            Map jsonMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class);
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(this.taskTemplate.getFullQualifiedName())).id(taskId).doc(jsonMap).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL).setIfSeqNo(searchHit.getSeqNo()).setIfPrimaryTerm(searchHit.getPrimaryTerm());
            ElasticsearchUtil.executeUpdate(this.esClient, updateRequest);
        }
        catch (Exception e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private List<String> getTasksContainsVarNameAndValue(TaskByVariables[] taskVariablesFilter) {
        List<String> varNames = Arrays.stream(taskVariablesFilter).map(TaskByVariables::getName).collect(Collectors.toList());
        List<String> varValues = Arrays.stream(taskVariablesFilter).map(TaskByVariables::getValue).collect(Collectors.toList());
        List<String> processIdsCreatedFiltered = this.variableStoreElasticSearch.getProcessInstanceIdsWithMatchingVars(varNames, varValues);
        List<String> tasksIdsCreatedFiltered = this.retrieveTaskIdByProcessInstanceId(processIdsCreatedFiltered, taskVariablesFilter);
        List<String> taskIdsCompletedFiltered = this.getTasksIdsCompletedWithMatchingVars(varNames, varValues);
        return Stream.concat(tasksIdsCreatedFiltered.stream(), taskIdsCompletedFiltered.stream()).distinct().collect(Collectors.toList());
    }

    private List<String> getTasksIdsCompletedWithMatchingVars(List<String> varNames, List<String> varValues) {
        ArrayList tasksIdsMatchingAllVars = new ArrayList();
        for (int i = 0; i < varNames.size(); ++i) {
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"name", (String)varNames.get(i)));
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"value", (String)varValues.get(i)));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQuery).fetchSource("taskId", null);
            SearchRequest searchRequest = new SearchRequest(new String[]{this.taskVariableTemplate.getAlias()}).source(searchSourceBuilder);
            searchRequest.scroll(new TimeValue(60000L));
            HashSet taskIds = new HashSet();
            try {
                SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
                String scrollId = searchResponse.getScrollId();
                List<Object> scrollTaskIds = Arrays.stream(searchResponse.getHits().getHits()).map(hit -> (String)hit.getSourceAsMap().get("taskId")).collect(Collectors.toList());
                taskIds.addAll(scrollTaskIds);
                while (scrollTaskIds.size() > 0) {
                    SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId).scroll(new TimeValue(60000L));
                    searchResponse = this.esClient.scroll(scrollRequest, RequestOptions.DEFAULT);
                    scrollId = searchResponse.getScrollId();
                    scrollTaskIds = Arrays.stream(searchResponse.getHits().getHits()).map(hit -> (String)hit.getSourceAsMap().get("taskId")).toList();
                    taskIds.addAll(scrollTaskIds);
                }
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(scrollId);
                this.esClient.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
                tasksIdsMatchingAllVars.add(taskIds);
                continue;
            }
            catch (IOException e) {
                String message = String.format("Exception occurred while obtaining taskIds for variable %s: %s", varNames.get(i), e.getMessage());
                throw new TasklistRuntimeException(message, (Throwable)e);
            }
        }
        return new ArrayList<String>(tasksIdsMatchingAllVars.stream().reduce((set1, set2) -> {
            set1.retainAll((Collection<?>)set2);
            return set1;
        }).orElse(Collections.emptySet()));
    }

    private BoolQueryBuilder returnUserGroupBoolQuery(List<String> userGroups, String userName) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.taskTemplate.getFullQualifiedName()});
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"assignee", (String)userName));
        userGroups.forEach(group -> boolQuery.should((QueryBuilder)QueryBuilders.termsQuery((String)"candidateGroups", (String[])new String[]{group})));
        boolQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"candidateUsers", (String)userName));
        boolQuery.should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"candidateUsers")).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"candidateGroups")));
        return boolQuery;
    }

    private List<String> retrieveTaskIdByProcessInstanceId(List<String> processIds, TaskByVariables[] taskVariablesFilter) {
        ArrayList<String> taskIdsCreated = new ArrayList<String>();
        Map<String, String> variablesMap = IntStream.range(0, taskVariablesFilter.length).boxed().collect(Collectors.toMap(i -> taskVariablesFilter[i].getName(), i -> taskVariablesFilter[i].getValue()));
        for (String processId : processIds) {
            List<String> taskIds = this.getTaskIdsByProcessInstanceId(processId);
            for (String taskId : taskIds) {
                List<VariableStore.GetVariablesRequest> request;
                TaskEntity taskEntity = this.getTask(taskId);
                if (taskEntity.getState() != TaskState.CREATED || !this.taskVariableSearchUtil.checkIfVariablesExistInTask(request = Collections.singletonList(VariableStore.GetVariablesRequest.createFrom(taskEntity).setVarNames(variablesMap.keySet().stream().toList())), variablesMap).booleanValue()) continue;
                taskIdsCreated.add(taskId);
            }
        }
        return taskIdsCreated;
    }

    private QueryBuilder buildPriorityQuery(TaskQuery query) {
        if (query.getPriority() != null) {
            RangeValueFilter priority = query.getPriority();
            if (priority.getEq() != null) {
                return QueryBuilders.termQuery((String)"priority", (Object)priority.getEq());
            }
            RangeQueryBuilder rangeBuilder = QueryBuilders.rangeQuery((String)"priority");
            if (priority.getGt() != null) {
                rangeBuilder = rangeBuilder.gt(priority.getGt());
            }
            if (priority.getGte() != null) {
                rangeBuilder = rangeBuilder.gte(priority.getGte());
            }
            if (priority.getLt() != null) {
                rangeBuilder = rangeBuilder.lt(priority.getLt());
            }
            if (priority.getLte() != null) {
                rangeBuilder = rangeBuilder.lte(priority.getLte());
            }
            return rangeBuilder;
        }
        return null;
    }

    private SortBuilder<?> mapNullInSort(String field, String defaultValue, SortOrder order, ScriptSortBuilder.ScriptSortType sortType) {
        String nullHandlingScript = String.format("if (doc['%s'].size() == 0) { %s } else { doc['%s'].value }", field, defaultValue, field);
        Script script = new Script(nullHandlingScript);
        return SortBuilders.scriptSort((Script)script, (ScriptSortBuilder.ScriptSortType)sortType).order(order);
    }
}

