/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.entities.listview.VariableListViewEntity;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.schema.templates.TasklistListViewTemplate;
import io.camunda.tasklist.store.ListViewStore;
import io.camunda.tasklist.util.ElasticsearchUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ListViewStoreElasticSearch
implements ListViewStore {
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private TasklistListViewTemplate tasklistListViewTemplate;

    @Override
    public void removeVariableByFlowNodeInstanceId(String flowNodeInstanceId) {
        try {
            SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.tasklistListViewTemplate).source(SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.termQuery((String)"scopeKey", (String)flowNodeInstanceId)));
            ElasticsearchUtil.scrollWith(searchRequest, this.esClient, hits -> {
                for (SearchHit hit : hits.getHits()) {
                    VariableListViewEntity variableListViewEntity = ElasticsearchUtil.fromSearchHit(hit.getSourceAsString(), this.objectMapper, VariableListViewEntity.class);
                    DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(this.tasklistListViewTemplate.getFullQualifiedName())).id(variableListViewEntity.getId()).routing(flowNodeInstanceId);
                    try {
                        this.esClient.delete(deleteRequest, RequestOptions.DEFAULT);
                    }
                    catch (IOException e) {
                        throw new TasklistRuntimeException(String.format("Error removing variable [%s]", variableListViewEntity.getName()), (Throwable)e);
                    }
                }
            }, null, null);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error to retrieve variable for the flowNodeInstanceId [%s]", flowNodeInstanceId), (Throwable)e);
        }
    }

    @Override
    public List<VariableListViewEntity> getVariablesByVariableName(String varName) {
        ArrayList<VariableListViewEntity> variableList = new ArrayList<VariableListViewEntity>();
        try {
            SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.tasklistListViewTemplate).source(SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.termQuery((String)"name", (String)varName)));
            ElasticsearchUtil.scrollWith(searchRequest, this.esClient, hits -> {
                for (SearchHit hit : hits.getHits()) {
                    variableList.add(ElasticsearchUtil.fromSearchHit(hit.getSourceAsString(), this.objectMapper, VariableListViewEntity.class));
                }
            }, null, null);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error retrieving variables for variable name [%s]", varName), (Throwable)e);
        }
        return variableList;
    }

    @Override
    public void persistTaskVariables(Collection<VariableListViewEntity> finalVariables) {
        if (finalVariables.isEmpty()) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (VariableListViewEntity variableEntity : finalVariables) {
            bulkRequest.add(this.createUpsertRequest(variableEntity));
        }
        try {
            ElasticsearchUtil.processBulkRequest(this.esClient, bulkRequest, WriteRequest.RefreshPolicy.WAIT_UNTIL);
        }
        catch (PersistenceException ex) {
            throw new TasklistRuntimeException((Throwable)ex);
        }
    }

    private UpdateRequest createUpsertRequest(VariableListViewEntity variableEntity) {
        try {
            HashMap<String, String> updateFields = new HashMap<String, String>();
            updateFields.put("name", variableEntity.getName());
            updateFields.put("value", variableEntity.getValue());
            updateFields.put("fullValue", variableEntity.getFullValue());
            updateFields.put("join", (String)variableEntity.getJoin());
            Map jsonMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class);
            return ((UpdateRequest)new UpdateRequest().index(this.tasklistListViewTemplate.getFullQualifiedName())).id(variableEntity.getId()).upsert(this.objectMapper.writeValueAsString((Object)variableEntity), XContentType.JSON).doc(jsonMap).routing(variableEntity.getScopeKey()).retryOnConflict(3);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error preparing the query to upsert task variable instance [%s]", variableEntity.getId()), (Throwable)e);
        }
    }
}

