/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.entities.DraftTaskVariableEntity;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.schema.templates.DraftTaskVariableTemplate;
import io.camunda.tasklist.store.DraftVariableStore;
import io.camunda.tasklist.tenant.TenantAwareElasticsearchClient;
import io.camunda.tasklist.util.ElasticsearchUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DraftVariablesStoreElasticSearch
implements DraftVariableStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DraftVariablesStoreElasticSearch.class);
    @Autowired
    private TenantAwareElasticsearchClient tenantAwareClient;
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    private DraftTaskVariableTemplate draftTaskVariableTemplate;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    @Override
    public void createOrUpdate(Collection<DraftTaskVariableEntity> draftVariables) {
        BulkRequest bulkRequest = new BulkRequest();
        for (DraftTaskVariableEntity variableEntity : draftVariables) {
            bulkRequest.add(this.createUpsertRequest(variableEntity));
        }
        try {
            ElasticsearchUtil.processBulkRequest(this.esClient, bulkRequest, WriteRequest.RefreshPolicy.WAIT_UNTIL);
        }
        catch (PersistenceException ex) {
            throw new TasklistRuntimeException((Throwable)ex);
        }
    }

    private UpdateRequest createUpsertRequest(DraftTaskVariableEntity draftVariableEntity) {
        try {
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            updateFields.put("taskId", draftVariableEntity.getTaskId());
            updateFields.put("name", draftVariableEntity.getName());
            updateFields.put("value", draftVariableEntity.getValue());
            updateFields.put("fullValue", draftVariableEntity.getFullValue());
            updateFields.put("isPreview", draftVariableEntity.getIsPreview());
            Map jsonMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class);
            return ((UpdateRequest)new UpdateRequest().index(this.draftTaskVariableTemplate.getFullQualifiedName())).id(draftVariableEntity.getId()).upsert(this.objectMapper.writeValueAsString((Object)draftVariableEntity), XContentType.JSON).doc(jsonMap).retryOnConflict(3);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error preparing the query to upsert task variable instance [%s]", draftVariableEntity.getId()), (Throwable)e);
        }
    }

    @Override
    public long deleteAllByTaskId(String taskId) {
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{this.draftTaskVariableTemplate.getFullQualifiedName()});
        request.setQuery((QueryBuilder)QueryBuilders.termQuery((String)"taskId", (String)taskId));
        try {
            BulkByScrollResponse response = this.esClient.deleteByQuery(request, RequestOptions.DEFAULT);
            return response.getDeleted();
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error preparing the query to delete draft task variable instances for task [%s]", taskId), (Throwable)e);
        }
    }

    @Override
    public List<DraftTaskVariableEntity> getVariablesByTaskIdAndVariableNames(String taskId, List<String> variableNames) {
        try {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"taskId", (String)taskId));
            if (!CollectionUtils.isEmpty(variableNames)) {
                queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"name", variableNames));
            }
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder);
            SearchRequest searchRequest = new SearchRequest(new String[]{this.draftTaskVariableTemplate.getFullQualifiedName()});
            searchRequest.source(sourceBuilder);
            return ElasticsearchUtil.scroll(searchRequest, DraftTaskVariableEntity.class, this.objectMapper, this.esClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error executing the query to get draft task variable instances for task [%s] with variable names %s", taskId, variableNames), (Throwable)e);
        }
    }

    @Override
    public Optional<DraftTaskVariableEntity> getById(String variableId) {
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.draftTaskVariableTemplate.getFullQualifiedName()});
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)variableId));
            searchRequest.source(sourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            SearchHits hits = searchResponse.getHits();
            if (hits.getTotalHits().value == 0L) {
                return Optional.empty();
            }
            SearchHit hit = hits.getAt(0);
            String sourceAsString = hit.getSourceAsString();
            DraftTaskVariableEntity entity = (DraftTaskVariableEntity)this.objectMapper.readValue(sourceAsString, DraftTaskVariableEntity.class);
            return Optional.of(entity);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Error retrieving draft task variable instance with ID [%s]", variableId), (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public List<String> getDraftVariablesIdsByTaskIds(List<String> taskIds) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.draftTaskVariableTemplate.getFullQualifiedName()}).source(SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.termsQuery((String)"taskId", taskIds)).fetchField("id"));
        try {
            return ElasticsearchUtil.scrollIdsToList(searchRequest, this.esClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

