/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.schema.migration.os;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.CommonUtils;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.MigrationException;
import io.camunda.tasklist.os.RetryOpenSearchClient;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.MigrationRepositoryIndex;
import io.camunda.tasklist.schema.migration.Step;
import io.camunda.tasklist.schema.migration.StepsRepository;
import io.camunda.tasklist.util.OpenSearchUtil;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class OpenSearchStepsRepository
implements StepsRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchStepsRepository.class);
    private static final String STEP_FILE_EXTENSION = ".json";
    private static final String DEFAULT_SCHEMA_CHANGE_FOLDER = "/schema/os/change";
    @Autowired
    private RetryOpenSearchClient retryOpenSearchClient;
    @Qualifier(value="tasklistObjectMapper")
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    private MigrationRepositoryIndex migrationRepositoryIndex;

    @Override
    public void updateSteps() throws IOException, MigrationException {
        List<Step> stepsFromFiles = this.readStepsFromClasspath();
        List<Step> stepsFromRepository = this.findAll();
        for (Step step : stepsFromFiles) {
            if (stepsFromRepository.contains(step)) continue;
            step.setCreatedDate(OffsetDateTime.now());
            LOGGER.info("Add new step {} to repository.", (Object)step);
            this.save(step);
        }
        this.retryOpenSearchClient.refresh(this.migrationRepositoryIndex.getFullQualifiedName());
    }

    private List<Step> readStepsFromClasspath() throws IOException {
        ArrayList<Step> steps = new ArrayList<Step>();
        List<Resource> resources = this.getResourcesFor("/schema/os/change/*.json");
        for (Resource resource : resources) {
            LOGGER.info("Read step {} ", (Object)resource.getFilename());
            steps.add(this.readStepFromFile(resource.getInputStream()));
        }
        steps.sort(Step.SEMANTICVERSION_ORDER_COMPARATOR);
        return steps;
    }

    private List<Resource> getResourcesFor(String pattern) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            return Arrays.asList(resolver.getResources(pattern));
        }
        catch (IOException e) {
            LOGGER.info("No resources found for {} ", (Object)pattern);
            return List.of();
        }
    }

    private Step readStepFromFile(InputStream is) throws IOException {
        return (Step)this.objectMapper.readValue(is, Step.class);
    }

    protected String idFromStep(Step step) {
        return step.getVersion() + "-" + step.getOrder();
    }

    @Override
    public void save(Step step) throws MigrationException, IOException {
        boolean createdOrUpdated = this.retryOpenSearchClient.createOrUpdateDocument(this.migrationRepositoryIndex.getFullQualifiedName(), this.idFromStep(step), (Map)CommonUtils.getJsonObjectFromEntity((Object)step));
        if (!createdOrUpdated) {
            throw new MigrationException(String.format("Error in save step %s:  document wasn't created/updated.", step));
        }
        LOGGER.info("Step {}  saved.", (Object)step);
    }

    protected List<Step> findBy(Optional<Query> query) {
        SearchRequest request = SearchRequest.of(sr -> {
            query.ifPresent(arg_0 -> ((SearchRequest.Builder)sr).query(arg_0));
            return sr.index(this.migrationRepositoryIndex.getFullQualifiedName(), new String[0]).sort(sort -> sort.field(f -> f.field("version.keyword").order(SortOrder.Asc))).allowNoIndices(Boolean.valueOf(true)).ignoreUnavailable(Boolean.valueOf(true)).expandWildcards(ExpandWildcard.Open, new ExpandWildcard[0]).scroll(s -> s.time("60000ms"));
        });
        return this.retryOpenSearchClient.searchWithScroll(request, Step.class, this.objectMapper);
    }

    @Override
    public List<Step> findAll() {
        LOGGER.debug("Find all steps from OpenSearch at {}:{} ", (Object)this.tasklistProperties.getOpenSearch().getHost(), (Object)this.tasklistProperties.getOpenSearch().getPort());
        return this.findBy(Optional.empty());
    }

    @Override
    public List<Step> findNotAppliedFor(String indexName) {
        LOGGER.debug("Find 'not applied steps' for index {} from OpenSearch at {}:{} ", new Object[]{indexName, this.tasklistProperties.getOpenSearch().getHost(), this.tasklistProperties.getOpenSearch().getPort()});
        return this.findBy(Optional.of(OpenSearchUtil.joinWithAnd(new ObjectBuilder[]{new TermQuery.Builder().field("indexName.keyword").value(FieldValue.of((String)indexName)), new TermQuery.Builder().field("applied").value(FieldValue.of((boolean)false))})));
    }
}

