/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.schema.migration.os;

import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.MigrationException;
import io.camunda.tasklist.os.RetryOpenSearchClient;
import io.camunda.tasklist.property.MigrationProperties;
import io.camunda.tasklist.property.TasklistOpenSearchProperties;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.IndexSchemaValidator;
import io.camunda.tasklist.schema.SemanticVersion;
import io.camunda.tasklist.schema.indices.IndexDescriptor;
import io.camunda.tasklist.schema.migration.Migrator;
import io.camunda.tasklist.schema.migration.Step;
import io.camunda.tasklist.schema.migration.StepsRepository;
import io.camunda.tasklist.schema.migration.os.ReindexPlanOpenSearch;
import io.camunda.tasklist.schema.templates.TemplateDescriptor;
import io.camunda.tasklist.util.CollectionUtil;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@Configuration
@Conditional(value={OpenSearchCondition.class})
public class OpenSearchMigrator
implements Migrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchMigrator.class);
    @Autowired
    private List<IndexDescriptor> indexDescriptors;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    private RetryOpenSearchClient retryOpenSearchClient;
    @Autowired
    private StepsRepository stepsRepository;
    @Autowired
    private MigrationProperties migrationProperties;
    @Autowired
    private IndexSchemaValidator indexSchemaValidator;

    @Bean(value={"tasklistMigrationThreadPoolExecutor"})
    public ThreadPoolTaskExecutor getTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.migrationProperties.getThreadsCount());
        executor.setMaxPoolSize(this.migrationProperties.getThreadsCount());
        executor.setThreadNamePrefix("migration_");
        executor.initialize();
        return executor;
    }

    @Override
    public void migrate() throws MigrationException {
        try {
            this.stepsRepository.updateSteps();
        }
        catch (IOException | OpenSearchException e) {
            throw new MigrationException(String.format("Migration failed in updating steps: %s ", e.getMessage()));
        }
        boolean failed = false;
        List<Future> results = this.indexDescriptors.stream().map(this::migrateIndexInThread).toList();
        for (Future result : results) {
            try {
                if (((Boolean)result.get()).booleanValue()) continue;
                failed = true;
            }
            catch (Exception e) {
                LOGGER.error("Migration failed: ", (Throwable)e);
                failed = true;
            }
        }
        this.getTaskExecutor().shutdown();
        if (failed) {
            throw new MigrationException("Migration failed. See logging messages above.");
        }
    }

    private Future<Boolean> migrateIndexInThread(IndexDescriptor indexDescriptor) {
        return this.getTaskExecutor().submit(() -> {
            try {
                this.migrateIndexIfNecessary(indexDescriptor);
            }
            catch (Exception e) {
                LOGGER.error("Migration for {} failed:", (Object)indexDescriptor.getIndexName(), (Object)e);
                return false;
            }
            return true;
        });
    }

    private void migrateIndexIfNecessary(IndexDescriptor indexDescriptor) throws MigrationException, IOException {
        LOGGER.info("Check if index {} needs to migrate.", (Object)indexDescriptor.getIndexName());
        Set<String> olderVersions = this.indexSchemaValidator.olderVersionsForIndex(indexDescriptor);
        if (olderVersions.size() > 1) {
            throw new MigrationException(String.format("For index %s are existing more than one older versions: %s ", indexDescriptor.getIndexName(), olderVersions));
        }
        if (olderVersions.isEmpty()) {
            LOGGER.info("No migration needed for {}, no previous indices found.", (Object)indexDescriptor.getIndexName());
        } else {
            String olderVersion = olderVersions.iterator().next();
            String currentVersion = indexDescriptor.getVersion();
            List<Step> stepsForIndex = this.stepsRepository.findNotAppliedFor(indexDescriptor.getIndexName());
            ReindexPlanOpenSearch plan = this.createPlanFor(indexDescriptor.getIndexName(), olderVersion, currentVersion, stepsForIndex);
            this.migrateIndex(indexDescriptor, plan);
            if (this.migrationProperties.isDeleteSrcSchema()) {
                String olderBaseIndexName = String.format("%s-%s-%s_", this.tasklistProperties.getElasticsearch().getIndexPrefix(), indexDescriptor.getIndexName(), olderVersion);
                String deleteIndexPattern = String.format("%s*", olderBaseIndexName);
                LOGGER.info("Deleted previous indices for pattern {}", (Object)deleteIndexPattern);
                this.retryOpenSearchClient.deleteIndicesFor(deleteIndexPattern);
                if (indexDescriptor instanceof TemplateDescriptor) {
                    String deleteTemplatePattern = String.format("%stemplate", olderBaseIndexName);
                    LOGGER.info("Deleted previous templates for {}", (Object)deleteTemplatePattern);
                    this.retryOpenSearchClient.deleteTemplatesFor(deleteTemplatePattern);
                }
            }
        }
    }

    private void migrateIndex(IndexDescriptor indexDescriptor, ReindexPlanOpenSearch plan) throws IOException, MigrationException {
        TasklistOpenSearchProperties osConfig = this.tasklistProperties.getOpenSearch();
        LOGGER.debug("Save current settings for {}", (Object)indexDescriptor.getFullQualifiedName());
        Map<String, String> indexSettings = this.getIndexSettingsOrDefaultsFor(indexDescriptor, osConfig);
        LOGGER.debug("Set reindex settings for {}", (Object)indexDescriptor.getDerivedIndexNamePattern());
        this.retryOpenSearchClient.setIndexSettingsFor(IndexSettings.of(s -> s.numberOfReplicas("0")), indexDescriptor.getDerivedIndexNamePattern());
        LOGGER.info("Execute plan: {} ", (Object)plan);
        plan.executeOn(this.retryOpenSearchClient);
        LOGGER.debug("Save applied steps in migration repository");
        for (Step step : plan.getSteps()) {
            step.setApplied(true).setAppliedDate(OffsetDateTime.now());
            this.stepsRepository.save(step);
        }
        LOGGER.debug("Restore settings for {}", (Object)indexDescriptor.getDerivedIndexNamePattern());
        this.retryOpenSearchClient.setIndexSettingsFor(IndexSettings.of(s -> s.numberOfReplicas((String)indexSettings.get("index.number_of_replicas")).refreshInterval(t -> t.time((String)indexSettings.get("index.refresh_interval")))), indexDescriptor.getDerivedIndexNamePattern());
        LOGGER.info("Refresh index {}", (Object)indexDescriptor.getDerivedIndexNamePattern());
        this.retryOpenSearchClient.refresh(indexDescriptor.getDerivedIndexNamePattern());
    }

    private Map<String, String> getIndexSettingsOrDefaultsFor(IndexDescriptor indexDescriptor, TasklistOpenSearchProperties osConfig) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("index.refresh_interval", this.retryOpenSearchClient.getOrDefaultRefreshInterval(indexDescriptor.getFullQualifiedName(), osConfig.getRefreshInterval()));
        settings.put("index.number_of_replicas", this.retryOpenSearchClient.getOrDefaultNumbersOfReplica(indexDescriptor.getFullQualifiedName(), "" + osConfig.getNumberOfReplicas()));
        return settings;
    }

    protected ReindexPlanOpenSearch createPlanFor(String indexName, String srcVersion, String dstVersion, List<Step> steps) {
        SemanticVersion sourceVersion = SemanticVersion.fromVersion(srcVersion);
        SemanticVersion destinationVersion = SemanticVersion.fromVersion(dstVersion);
        ArrayList<Step> sortByVersion = new ArrayList<Step>(steps);
        sortByVersion.sort(Step.SEMANTICVERSION_ORDER_COMPARATOR);
        List onlyAffectedVersions = CollectionUtil.filter(sortByVersion, s -> SemanticVersion.fromVersion(s.getVersion()).isBetween(sourceVersion, destinationVersion));
        String indexPrefix = this.tasklistProperties.getElasticsearch().getIndexPrefix();
        String srcIndex = String.format("%s-%s-%s", indexPrefix, indexName, srcVersion);
        String dstIndex = String.format("%s-%s-%s", indexPrefix, indexName, dstVersion);
        return ReindexPlanOpenSearch.create().setBatchSize(this.migrationProperties.getReindexBatchSize()).setSlices(this.migrationProperties.getSlices()).setSrcIndex(srcIndex).setDstIndex(dstIndex).setSteps(onlyAffectedVersions);
    }
}

