/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.schema.migration;

import io.camunda.tasklist.JacksonConfig;
import io.camunda.tasklist.schema.SchemaStartup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FullyQualifiedAnnotationBeanNameGenerator;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

@SpringBootApplication
@ComponentScan(basePackages={"io.camunda.tasklist.property", "io.camunda.tasklist.es", "io.camunda.tasklist.schema"}, nameGenerator=FullyQualifiedAnnotationBeanNameGenerator.class)
@Import(value={JacksonConfig.class})
@Profile(value={"!test"})
public class SchemaMigration
implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaMigration.class);
    @Autowired
    private SchemaStartup schemaStartup;

    public void run(String ... args) {
        LOGGER.info("SchemaMigration finished.");
    }

    public static void main(String[] args) {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        System.setProperty("spring.config.location", "optional:classpath:/,optional:classpath:/config/,optional:file:./,optional:file:./config/");
        SpringApplication springApplication = new SpringApplication(new Class[]{SchemaMigration.class});
        springApplication.setWebApplicationType(WebApplicationType.NONE);
        springApplication.setAddCommandLineProperties(true);
        springApplication.addListeners(new ApplicationListener[]{new ApplicationErrorListener()});
        ConfigurableApplicationContext ctx = springApplication.run(args);
        SpringApplication.exit((ApplicationContext)ctx, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
    }

    public static class ApplicationErrorListener
    implements ApplicationListener<ApplicationFailedEvent> {
        public void onApplicationEvent(ApplicationFailedEvent event) {
            if (event.getException() != null) {
                event.getApplicationContext().close();
                System.exit(-1);
            }
        }
    }
}

