/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.schema.manager;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.es.RetryElasticsearchClient;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistElasticsearchProperties;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.IndexMapping;
import io.camunda.tasklist.schema.indices.AbstractIndexDescriptor;
import io.camunda.tasklist.schema.indices.IndexDescriptor;
import io.camunda.tasklist.schema.manager.SchemaManager;
import io.camunda.tasklist.schema.templates.TemplateDescriptor;
import io.camunda.tasklist.util.ElasticsearchJSONUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.client.indexlifecycle.DeleteAction;
import org.elasticsearch.client.indexlifecycle.LifecyclePolicy;
import org.elasticsearch.client.indexlifecycle.Phase;
import org.elasticsearch.client.indexlifecycle.PutLifecyclePolicyRequest;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.PutComponentTemplateRequest;
import org.elasticsearch.client.indices.PutComposableIndexTemplateRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;

@Component(value="tasklistSchemaManager")
@Profile(value={"!test"})
@Conditional(value={ElasticSearchCondition.class})
public class ElasticsearchSchemaManager
implements SchemaManager {
    public static final String TASKLIST_DELETE_ARCHIVED_INDICES = "tasklist_delete_archived_indices";
    public static final String INDEX_LIFECYCLE_NAME = "index.lifecycle.name";
    public static final String DELETE_PHASE = "delete";
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchSchemaManager.class);
    private static final String NUMBER_OF_SHARDS = "index.number_of_shards";
    private static final String NUMBER_OF_REPLICAS = "index.number_of_replicas";
    @Autowired
    protected RetryElasticsearchClient retryElasticsearchClient;
    @Autowired
    protected TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private List<AbstractIndexDescriptor> indexDescriptors;
    @Autowired
    private List<TemplateDescriptor> templateDescriptors;

    @Override
    public void createSchema() {
        if (this.tasklistProperties.getArchiver().isIlmEnabled()) {
            this.createIndexLifeCycles();
        }
        this.createDefaults();
        this.createTemplates();
        this.createIndices();
    }

    @Override
    public IndexMapping getExpectedIndexFields(IndexDescriptor indexDescriptor) {
        InputStream description = ElasticsearchSchemaManager.class.getResourceAsStream(indexDescriptor.getSchemaClasspathFilename());
        try {
            String currentVersionSchema = StreamUtils.copyToString((InputStream)description, (Charset)StandardCharsets.UTF_8);
            TypeReference<HashMap<String, Object>> type = new TypeReference<HashMap<String, Object>>(this){};
            Map mappings = (Map)((HashMap)this.objectMapper.readValue(currentVersionSchema, (TypeReference)type)).get("mappings");
            Map properties = (Map)mappings.get("properties");
            String dynamic = (String)mappings.get("dynamic");
            return new IndexMapping().setIndexName(indexDescriptor.getIndexName()).setDynamic(dynamic).setProperties(properties.entrySet().stream().map(entry -> new IndexMapping.IndexMappingProperty().setName((String)entry.getKey()).setTypeDefinition(entry.getValue())).collect(Collectors.toSet()));
        }
        catch (IOException e) {
            throw new TasklistRuntimeException((Throwable)e);
        }
    }

    @Override
    public Map<String, IndexMapping> getIndexMappings(String indexName) {
        return this.retryElasticsearchClient.getIndexMappings(indexName);
    }

    @Override
    public String getIndexPrefix() {
        return this.tasklistProperties.getElasticsearch().getIndexPrefix();
    }

    @Override
    public void updateSchema(Map<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> newFields) {
        for (Map.Entry<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> indexNewFields : newFields.entrySet()) {
            if (indexNewFields.getKey() instanceof TemplateDescriptor) {
                LOGGER.info("Update template: " + ((TemplateDescriptor)indexNewFields.getKey()).getTemplateName());
                TemplateDescriptor templateDescriptor = (TemplateDescriptor)indexNewFields.getKey();
                PutComposableIndexTemplateRequest request = this.prepareComposableTemplateRequest(templateDescriptor, null);
                this.putIndexTemplate(request, true);
            }
            PutMappingRequest request = new PutMappingRequest(new String[]{indexNewFields.getKey().getAlias()});
            request.source("{\"properties\":" + IndexMapping.IndexMappingProperty.toJsonString(indexNewFields.getValue(), this.objectMapper) + "}", XContentType.JSON);
            LOGGER.info(String.format("Index alias: %s. New fields will be added: %s", indexNewFields.getKey().getAlias(), indexNewFields.getValue()));
            this.retryElasticsearchClient.putMapping(request);
        }
    }

    @Override
    public void createIndex(IndexDescriptor indexDescriptor) {
        this.createIndex(indexDescriptor, indexDescriptor.getSchemaClasspathFilename());
    }

    private String settingsTemplateName() {
        TasklistElasticsearchProperties elsConfig = this.tasklistProperties.getElasticsearch();
        return String.format("%s_template", elsConfig.getIndexPrefix());
    }

    private Settings getIndexSettings() {
        TasklistElasticsearchProperties elsConfig = this.tasklistProperties.getElasticsearch();
        return Settings.builder().put(NUMBER_OF_SHARDS, elsConfig.getNumberOfShards()).put(NUMBER_OF_REPLICAS, elsConfig.getNumberOfReplicas()).build();
    }

    public void createDefaults() {
        TasklistElasticsearchProperties elsConfig = this.tasklistProperties.getElasticsearch();
        String settingsTemplate = this.settingsTemplateName();
        LOGGER.info("Create default settings from '{}' with {} shards and {} replicas per index.", new Object[]{settingsTemplate, elsConfig.getNumberOfShards(), elsConfig.getNumberOfReplicas()});
        Settings settings = this.getDefaultIndexSettings();
        Template template = new Template(settings, null, null);
        ComponentTemplate componentTemplate = new ComponentTemplate(template, null, null);
        PutComponentTemplateRequest request = new PutComponentTemplateRequest().name(settingsTemplate).componentTemplate(componentTemplate);
        this.retryElasticsearchClient.createComponentTemplate(request);
    }

    public void createIndexLifeCycles() {
        TimeValue timeValue = TimeValue.parseTimeValue((String)this.tasklistProperties.getArchiver().getIlmMinAgeForDeleteArchivedIndices(), (String)"IndexLifeCycle index.lifecycle.name");
        LOGGER.info("Create Index Lifecycle {} for min age of {} ", (Object)TASKLIST_DELETE_ARCHIVED_INDICES, (Object)timeValue.getStringRep());
        HashMap<String, Phase> phases = new HashMap<String, Phase>();
        Map<String, DeleteAction> deleteActions = Collections.singletonMap(DELETE_PHASE, new DeleteAction());
        phases.put(DELETE_PHASE, new Phase(DELETE_PHASE, timeValue, deleteActions));
        LifecyclePolicy policy = new LifecyclePolicy(TASKLIST_DELETE_ARCHIVED_INDICES, phases);
        this.retryElasticsearchClient.putLifeCyclePolicy(new PutLifecyclePolicyRequest(policy));
    }

    private void createIndices() {
        this.indexDescriptors.forEach(this::createIndex);
    }

    private void createTemplates() {
        this.templateDescriptors.forEach(this::createTemplate);
    }

    private void createIndex(IndexDescriptor indexDescriptor, String indexClasspathResource) {
        Map<String, Object> indexDescription = ElasticsearchJSONUtil.readJSONFileToMap(indexClasspathResource);
        this.createIndex(new CreateIndexRequest(indexDescriptor.getFullQualifiedName()).source(indexDescription).aliases(Set.of(new Alias(indexDescriptor.getAlias()).writeIndex(Boolean.valueOf(false)))).settings(this.getIndexSettings(indexDescriptor.getIndexName())), indexDescriptor.getFullQualifiedName());
    }

    private void createTemplate(TemplateDescriptor templateDescriptor) {
        this.createTemplate(templateDescriptor, null);
    }

    public void createTemplate(TemplateDescriptor templateDescriptor, String templateClasspathResource) {
        PutComposableIndexTemplateRequest request = this.prepareComposableTemplateRequest(templateDescriptor, templateClasspathResource);
        this.putIndexTemplate(request);
        String indexName = templateDescriptor.getFullQualifiedName();
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName).aliases(Set.of(new Alias(templateDescriptor.getAlias()).writeIndex(Boolean.valueOf(false)))).settings(this.getIndexSettings(templateDescriptor.getIndexName()));
        this.createIndex(createIndexRequest, indexName);
    }

    private void createIndex(CreateIndexRequest createIndexRequest, String indexName) {
        boolean created = this.retryElasticsearchClient.createIndex(createIndexRequest);
        if (created) {
            LOGGER.debug("Index [{}] was successfully created", (Object)indexName);
        } else {
            LOGGER.debug("Index [{}] was NOT created", (Object)indexName);
        }
    }

    private void putIndexTemplate(PutComposableIndexTemplateRequest request) {
        boolean created = this.retryElasticsearchClient.createTemplate(request);
        if (created) {
            LOGGER.debug("Template [{}] was successfully created", (Object)request.name());
        } else {
            LOGGER.debug("Template [{}] was NOT created", (Object)request.name());
        }
    }

    private void putIndexTemplate(PutComposableIndexTemplateRequest request, boolean overwrite) {
        boolean created = this.retryElasticsearchClient.createTemplate(request, overwrite);
        if (created) {
            LOGGER.debug("Template [{}] was successfully created", (Object)request.name());
        } else {
            LOGGER.debug("Template [{}] was NOT created", (Object)request.name());
        }
    }

    private PutComposableIndexTemplateRequest prepareComposableTemplateRequest(TemplateDescriptor templateDescriptor, String templateClasspathResource) {
        String templateResourceName = templateClasspathResource != null ? templateClasspathResource : templateDescriptor.getSchemaClasspathFilename();
        Template template = this.getTemplateFrom(templateDescriptor, templateResourceName);
        ComposableIndexTemplate composableTemplate = new ComposableIndexTemplate.Builder().indexPatterns(List.of(templateDescriptor.getIndexPattern())).template(template).componentTemplates(List.of(this.settingsTemplateName())).build();
        PutComposableIndexTemplateRequest request = new PutComposableIndexTemplateRequest().name(templateDescriptor.getTemplateName()).indexTemplate(composableTemplate);
        return request;
    }

    private void overrideTemplateSettings(Map<String, Object> templateConfig, TemplateDescriptor templateDescriptor) {
        Settings indexSettings = this.getIndexSettings(templateDescriptor.getIndexName());
        Map settings = templateConfig.getOrDefault("settings", new HashMap());
        Map index = settings.getOrDefault("index", new HashMap());
        index.put("number_of_shards", indexSettings.get(NUMBER_OF_SHARDS));
        index.put("number_of_replicas", indexSettings.get(NUMBER_OF_REPLICAS));
        settings.put("index", index);
        templateConfig.put("settings", settings);
    }

    private Settings getIndexSettings(String indexName) {
        TasklistElasticsearchProperties elsConfig = this.tasklistProperties.getElasticsearch();
        Integer shards = elsConfig.getNumberOfShardsPerIndex().getOrDefault(indexName, elsConfig.getNumberOfShards());
        Integer replicas = elsConfig.getNumberOfReplicasPerIndices().getOrDefault(indexName, elsConfig.getNumberOfReplicas());
        return Settings.builder().put(NUMBER_OF_SHARDS, shards.intValue()).put(NUMBER_OF_REPLICAS, replicas.intValue()).build();
    }

    private Settings getDefaultIndexSettings() {
        TasklistElasticsearchProperties elsConfig = this.tasklistProperties.getElasticsearch();
        return Settings.builder().put(NUMBER_OF_SHARDS, elsConfig.getNumberOfShards()).put(NUMBER_OF_REPLICAS, elsConfig.getNumberOfReplicas()).build();
    }

    private Template getTemplateFrom(TemplateDescriptor templateDescriptor, String templateFilename) {
        Map<String, Object> templateConfig = ElasticsearchJSONUtil.readJSONFileToMap(templateFilename);
        this.overrideTemplateSettings(templateConfig, templateDescriptor);
        PutIndexTemplateRequest ptr = new PutIndexTemplateRequest(templateDescriptor.getTemplateName()).source(templateConfig);
        try {
            Map<String, AliasMetadata> aliases = Map.of(templateDescriptor.getAlias(), AliasMetadata.builder((String)templateDescriptor.getAlias()).build());
            return new Template(ptr.settings(), new CompressedXContent(ptr.mappings()), aliases);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error in reading mappings for %s ", templateDescriptor.getTemplateName()), (Throwable)e);
        }
    }
}

