/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.schema;

import io.camunda.tasklist.exceptions.MigrationException;
import io.camunda.tasklist.property.MigrationProperties;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.IndexMapping;
import io.camunda.tasklist.schema.IndexSchemaValidator;
import io.camunda.tasklist.schema.indices.IndexDescriptor;
import io.camunda.tasklist.schema.manager.SchemaManager;
import io.camunda.tasklist.schema.migration.Migrator;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component(value="tasklistSchemaStartup")
@Profile(value={"!test"})
public class SchemaStartup {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaStartup.class);
    @Autowired
    private SchemaManager schemaManager;
    @Autowired
    private IndexSchemaValidator schemaValidator;
    @Autowired
    private Migrator migrator;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    private MigrationProperties migrationProperties;

    @PostConstruct
    public void initializeSchema() throws MigrationException, IOException {
        try {
            boolean createSchema;
            LOGGER.info("SchemaStartup started.");
            LOGGER.info("SchemaStartup: validate index versions.");
            this.schemaValidator.validateIndexVersions();
            LOGGER.info("SchemaStartup: validate index mappings.");
            Map<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> newFields = this.schemaValidator.validateIndexMappings();
            boolean bl = createSchema = "opensearch".equalsIgnoreCase(this.tasklistProperties.getDatabase()) ? this.tasklistProperties.getOpenSearch().isCreateSchema() : this.tasklistProperties.getElasticsearch().isCreateSchema();
            if (createSchema && !this.schemaValidator.schemaExists()) {
                LOGGER.info("SchemaStartup: schema is empty or not complete. Indices will be created.");
                this.schemaManager.createSchema();
                LOGGER.info("SchemaStartup: update index mappings.");
            } else {
                LOGGER.info("SchemaStartup: schema won't be created, it either already exist, or schema creation is disabled in configuration.");
            }
            if (!newFields.isEmpty()) {
                if (createSchema) {
                    this.schemaManager.updateSchema(newFields);
                } else {
                    LOGGER.info("SchemaStartup: schema won't be updated as schema creation is disabled in configuration.");
                }
            }
            LOGGER.info("SchemaStartup finished.");
        }
        catch (Exception ex) {
            LOGGER.error("Schema startup failed: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }
}

