/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.os;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.os.OpenSearchInternalTask;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.util.OpenSearchUtil;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.function.CheckedSupplier;
import org.opensearch.client.Request;
import org.opensearch.client.Response;
import org.opensearch.client.ResponseException;
import org.opensearch.client.RestClient;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.HealthStatus;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.Result;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.cluster.ComponentTemplate;
import org.opensearch.client.opensearch.cluster.GetComponentTemplateResponse;
import org.opensearch.client.opensearch.cluster.HealthResponse;
import org.opensearch.client.opensearch.cluster.PutComponentTemplateRequest;
import org.opensearch.client.opensearch.core.CountResponse;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryResponse;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.DeleteResponse;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.ReindexRequest;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.GetIndexResponse;
import org.opensearch.client.opensearch.indices.GetIndicesSettingsResponse;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.opensearch.indices.IndexState;
import org.opensearch.client.opensearch.indices.PutIndexTemplateRequest;
import org.opensearch.client.opensearch.indices.PutMappingRequest;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.tasks.GetTasksResponse;
import org.opensearch.client.transport.OpenSearchTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class RetryOpenSearchClient {
    public static final String REFRESH_INTERVAL = "index.refresh_interval";
    public static final String NO_REFRESH = "-1";
    public static final String NUMBERS_OF_REPLICA = "index.number_of_replicas";
    public static final String NO_REPLICA = "0";
    public static final String SCROLL_KEEP_ALIVE_MS = "60000ms";
    public static final int DEFAULT_NUMBER_OF_RETRIES = 300;
    public static final int DEFAULT_DELAY_INTERVAL_IN_SECONDS = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryOpenSearchClient.class);
    @Autowired
    @Qualifier(value="tasklistOsRestClient")
    private RestClient opensearchRestClient;
    @Autowired
    @Qualifier(value="tasklistOsClient")
    private OpenSearchClient openSearchClient;
    private int numberOfRetries = 300;
    private int delayIntervalInSeconds = 2;
    @Autowired
    private OpenSearchInternalTask openSearchInternalTask;
    @Autowired
    private TasklistProperties tasklistProperties;

    public boolean isHealthy() {
        try {
            HealthResponse response = this.openSearchClient.cluster().health(h -> h.timeout(t -> t.time("500ms")));
            HealthStatus status = response.status();
            return !response.timedOut() && !status.equals((Object)HealthStatus.Red);
        }
        catch (IOException | OpenSearchException e) {
            LOGGER.error(String.format("Couldn't connect to OpenSearch due to %s. Return unhealthy state.", e.getMessage()), e);
            return false;
        }
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public RetryOpenSearchClient setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
        return this;
    }

    public int getDelayIntervalInSeconds() {
        return this.delayIntervalInSeconds;
    }

    public RetryOpenSearchClient setDelayIntervalInSeconds(int delayIntervalInSeconds) {
        this.delayIntervalInSeconds = delayIntervalInSeconds;
        return this;
    }

    public void refresh(String indexPattern) {
        this.executeWithRetries("Refresh " + indexPattern, () -> {
            try {
                for (String index : this.getFilteredIndices(indexPattern)) {
                    this.openSearchClient.indices().refresh(r -> r.index(List.of(index)));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        });
    }

    public long getNumberOfDocumentsFor(String ... indexPatterns) {
        CountResponse countResponse = this.executeWithRetries("Count number of documents in " + String.valueOf(Arrays.asList(indexPatterns)), () -> this.openSearchClient.count(c -> c.index(List.of(indexPatterns))), c -> c.shards().failures().size() > 0);
        return countResponse.count();
    }

    public Set<String> getIndexNames(String namePattern) {
        return (Set)this.executeWithRetries("Get indices for " + namePattern, () -> {
            try {
                GetIndexResponse response = this.openSearchClient.indices().get(i -> i.index(List.of(namePattern)));
                return response.result().keySet();
            }
            catch (OpenSearchException e) {
                if (e.status() == 404) {
                    return Set.of();
                }
                throw e;
            }
        });
    }

    public boolean createIndex(CreateIndexRequest createIndexRequest) {
        return (Boolean)this.executeWithRetries("CreateIndex " + createIndexRequest.index(), () -> {
            if (!this.indicesExist(createIndexRequest.index())) {
                return this.openSearchClient.indices().create(createIndexRequest).acknowledged();
            }
            String replicas = this.getOrDefaultNumbersOfReplica(createIndexRequest.index(), NO_REPLICA);
            if (!replicas.equals(String.valueOf(this.tasklistProperties.getOpenSearch().getNumberOfReplicas()))) {
                IndexSettings indexSettings = new IndexSettings.Builder().settings(IndexSettings.of(s -> s.numberOfReplicas(String.valueOf(this.tasklistProperties.getOpenSearch().getNumberOfReplicas())))).build();
                this.setIndexSettingsFor(indexSettings, createIndexRequest.index());
            }
            return true;
        });
    }

    public boolean createOrUpdateDocument(String name, String id, Map source) {
        return (Boolean)this.executeWithRetries(() -> {
            IndexResponse response = this.openSearchClient.index(i -> i.index(name).id(id).document((Object)source));
            Result result = response.result();
            return result.equals((Object)Result.Created) || result.equals((Object)Result.Updated);
        });
    }

    public boolean documentExists(String name, String id) {
        return (Boolean)this.executeWithGivenRetries(10, String.format("Exists document from %s with id %s", name, id), () -> this.openSearchClient.exists(e -> e.index(name).id(id)).value(), null);
    }

    public Map<String, Object> getDocument(String name, String id) {
        return (Map)this.executeWithGivenRetries(10, String.format("Get document from %s with id %s", name, id), () -> {
            GetRequest request = new GetRequest.Builder().index(name).id(id).build();
            GetResponse response2 = this.openSearchClient.get(request, Object.class);
            if (response2.found()) {
                return response2.source();
            }
            return null;
        }, null);
    }

    public boolean deleteDocumentsByQuery(String indexName, Query query) {
        return (Boolean)this.executeWithRetries(() -> {
            DeleteByQueryRequest request = new DeleteByQueryRequest.Builder().index(List.of(indexName)).query(query).build();
            DeleteByQueryResponse response = this.openSearchClient.deleteByQuery(request);
            return response.failures().isEmpty() && response.deleted() > 0L;
        });
    }

    public boolean deleteDocument(String name, String id) {
        return (Boolean)this.executeWithRetries(() -> {
            DeleteResponse response = this.openSearchClient.delete(new DeleteRequest.Builder().index(name).id(id).build());
            Result result = response.result();
            return result.equals((Object)Result.Deleted);
        });
    }

    private boolean templatesExist(String templatePattern) throws IOException {
        return this.openSearchClient.indices().existsIndexTemplate(it -> it.name(templatePattern)).value();
    }

    public boolean createTemplate(PutIndexTemplateRequest request) {
        return this.createTemplate(request, false);
    }

    public boolean createTemplate(PutIndexTemplateRequest request, boolean overwrite) {
        return (Boolean)this.executeWithRetries("CreateTemplate " + request.name(), () -> {
            if (overwrite || !this.templatesExist(request.name())) {
                return this.openSearchClient.indices().putIndexTemplate(request).acknowledged();
            }
            return true;
        });
    }

    public boolean deleteTemplatesFor(String templateNamePattern) {
        return (Boolean)this.executeWithRetries("DeleteTemplate " + templateNamePattern, () -> {
            if (this.templatesExist(templateNamePattern)) {
                return this.openSearchClient.indices().deleteIndexTemplate(it -> it.name(templateNamePattern)).acknowledged();
            }
            return true;
        });
    }

    private boolean indicesExist(String indexPattern) throws IOException {
        return this.openSearchClient.indices().exists(e -> e.index(List.of(indexPattern)).ignoreUnavailable(Boolean.valueOf(true)).allowNoIndices(Boolean.valueOf(false))).value();
    }

    private Set<String> getFilteredIndices(String indexPattern) throws IOException {
        return this.openSearchClient.indices().get(i -> i.index(List.of(indexPattern))).result().keySet();
    }

    public boolean deleteIndicesFor(String indexPattern) {
        return (Boolean)this.executeWithRetries("DeleteIndices " + indexPattern, () -> {
            for (String index : this.getFilteredIndices(indexPattern)) {
                this.openSearchClient.indices().delete(d -> d.index(List.of(indexPattern)));
            }
            return true;
        });
    }

    public IndexSettings getIndexSettingsFor(String indexName, String ... fields) {
        return (IndexSettings)this.executeWithRetries("GetIndexSettings " + indexName, () -> {
            GetIndicesSettingsResponse response = this.openSearchClient.indices().getSettings(s -> s.index(indexName, new String[0]).flatSettings(Boolean.valueOf(true)));
            return ((IndexState)response.result().get(indexName)).settings();
        });
    }

    public String getOrDefaultRefreshInterval(String indexName, String defaultValue) {
        IndexSettings settings = this.getIndexSettingsFor(indexName, REFRESH_INTERVAL);
        String refreshInterval = settings.refreshInterval() == null ? defaultValue : settings.refreshInterval().time();
        if (refreshInterval.trim().equals(NO_REFRESH)) {
            refreshInterval = defaultValue;
        }
        return refreshInterval;
    }

    public String getOrDefaultNumbersOfReplica(String indexName, String defaultValue) {
        IndexSettings settings = this.getIndexSettingsFor(indexName, NUMBERS_OF_REPLICA);
        String numbersOfReplica = settings.numberOfReplicas() == null ? defaultValue : settings.numberOfReplicas();
        if (numbersOfReplica.trim().equals(NO_REPLICA)) {
            numbersOfReplica = defaultValue;
        }
        return numbersOfReplica;
    }

    public boolean setIndexSettingsFor(IndexSettings settings, String indexPattern) {
        return (Boolean)this.executeWithRetries("SetIndexSettings " + indexPattern, () -> this.openSearchClient.indices().putSettings(s -> s.index(indexPattern, new String[0]).settings(settings)).acknowledged());
    }

    public boolean addPipeline(String name, List<String> processorDefinitions) {
        return (Boolean)this.executeWithRetries("AddPipeline " + name, () -> {
            List processors = processorDefinitions.stream().map(definition -> {
                JsonpMapper mapper = ((OpenSearchTransport)this.openSearchClient._transport()).jsonpMapper();
                JsonParser parser = mapper.jsonProvider().createParser((InputStream)new ByteArrayInputStream(definition.getBytes()));
                return (Processor)Processor._DESERIALIZER.deserialize(parser, mapper);
            }).collect(Collectors.toList());
            return this.openSearchClient.ingest().putPipeline(i -> i.id(name).processors(processors)).acknowledged();
        });
    }

    public boolean removePipeline(String name) {
        return (Boolean)this.executeWithRetries("RemovePipeline " + name, () -> this.openSearchClient.ingest().deletePipeline(dp -> dp.id(name)).acknowledged());
    }

    public void reindex(ReindexRequest reindexRequest) {
        this.reindex(reindexRequest, true);
    }

    private void refreshAndRetryOnShardFailures(String indexPattern) {
        this.executeWithRetries("Refresh " + indexPattern, () -> this.openSearchClient.indices().refresh(r -> r.index(indexPattern, new String[0])), r -> r.shards().failures().size() > 0);
    }

    public void reindex(ReindexRequest reindexRequest, boolean checkDocumentCount) {
        this.executeWithRetries("Reindex " + String.valueOf(Arrays.asList(reindexRequest.source().index())) + " -> " + reindexRequest.dest().index(), () -> {
            String taskId;
            String srcIndices = (String)reindexRequest.source().index().get(0);
            String dstIndex = reindexRequest.dest().index();
            long srcCount = this.getNumberOfDocumentsFor(srcIndices);
            List<String> taskIds = this.openSearchInternalTask.getRunningReindexTasksIdsFor(srcIndices, dstIndex);
            if (taskIds == null || taskIds.isEmpty()) {
                if (checkDocumentCount) {
                    this.refreshAndRetryOnShardFailures(dstIndex + "*");
                    long dstCount = this.getNumberOfDocumentsFor(dstIndex + "*");
                    if (srcCount == dstCount) {
                        LOGGER.info("Reindex of {} -> {} is already done.", (Object)srcIndices, (Object)dstIndex);
                        return true;
                    }
                }
                taskId = this.openSearchClient.reindex(reindexRequest).task();
            } else {
                LOGGER.info("There is an already running reindex task for [{}] -> [{}]. Will not submit another reindex task but wait for completion of this task", (Object)srcIndices, (Object)dstIndex);
                taskId = taskIds.get(0);
            }
            TimeUnit.of(ChronoUnit.MILLIS).sleep(2000L);
            if (checkDocumentCount) {
                return this.waitUntilTaskIsCompleted(taskId, srcCount);
            }
            return this.waitUntilTaskIsCompleted(taskId);
        }, done -> done == false);
    }

    private boolean waitUntilTaskIsCompleted(String taskId) {
        return this.waitUntilTaskIsCompleted(taskId, null);
    }

    private boolean waitUntilTaskIsCompleted(String taskId, Long srcCount) {
        GetTasksResponse taskResponse = this.executeWithGivenRetries(Integer.MAX_VALUE, "GetTaskInfo{" + taskId + "}", () -> {
            GetTasksResponse tasksResponse = this.openSearchClient.tasks().get(t -> t.taskId(taskId));
            this.openSearchInternalTask.checkForErrorsOrFailures(tasksResponse);
            return tasksResponse;
        }, this.openSearchInternalTask::needsToPollAgain);
        if (taskResponse != null) {
            long total = this.openSearchInternalTask.getTotal(taskResponse);
            LOGGER.info("Source docs: {}, Migrated docs: {}", (Object)srcCount, (Object)total);
            return total == srcCount;
        }
        return false;
    }

    public <T> List<T> searchWithScroll(SearchRequest searchRequest, Class<T> resultClass, ObjectMapper objectMapper) {
        long totalHits = (Long)this.executeWithRetries("Count search results", () -> this.openSearchClient.search(searchRequest, resultClass).hits().total().value());
        return this.executeWithRetries("Search with scroll", () -> this.scroll(searchRequest, resultClass, objectMapper), resultList -> (long)resultList.size() != totalHits);
    }

    private <T> List<T> scroll(SearchRequest searchRequest, Class<T> clazz, ObjectMapper objectMapper) throws IOException {
        ArrayList results = new ArrayList();
        SearchResponse response = this.openSearchClient.search(searchRequest, clazz);
        String scrollId = null;
        while (response.hits().hits().size() > 0) {
            results.addAll(CollectionUtil.map((Collection)response.hits().hits(), Hit::source));
            scrollId = response.scrollId();
            ScrollRequest scrollRequest = new ScrollRequest.Builder().scrollId(scrollId).scroll(s -> s.time(SCROLL_KEEP_ALIVE_MS)).build();
            response = this.openSearchClient.scroll(scrollRequest, clazz);
        }
        OpenSearchUtil.clearScroll(scrollId, this.openSearchClient);
        return results;
    }

    private <T> T executeWithRetries(CheckedSupplier<T> supplier) {
        return this.executeWithRetries("", supplier, null);
    }

    private <T> T executeWithRetries(String operationName, CheckedSupplier<T> supplier) {
        return this.executeWithRetries(operationName, supplier, null);
    }

    private <T> T executeWithRetries(String operationName, CheckedSupplier<T> supplier, Predicate<T> retryPredicate) {
        return this.executeWithGivenRetries(this.numberOfRetries, operationName, supplier, retryPredicate);
    }

    private <T> T executeWithGivenRetries(int retries, String operationName, CheckedSupplier<T> operation, Predicate<T> predicate) {
        try {
            RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handle(new Class[]{IOException.class, OpenSearchException.class})).withDelay(Duration.ofSeconds(this.delayIntervalInSeconds)).withMaxAttempts(retries).onRetry(e -> LOGGER.info("Retrying #{} {} due to {}", new Object[]{e.getAttemptCount(), operationName, e.getLastFailure()})).onAbort(e -> LOGGER.error("Abort {} by {}", (Object)operationName, (Object)e.getFailure())).onRetriesExceeded(e -> LOGGER.error("Retries {} exceeded for {}", (Object)e.getAttemptCount(), (Object)operationName));
            if (predicate != null) {
                retryPolicy.handleResultIf(predicate);
            }
            return (T)Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(operation);
        }
        catch (Exception e2) {
            throw new TasklistRuntimeException("Couldn't execute operation " + operationName + " on opensearch for " + this.numberOfRetries + " attempts with " + this.delayIntervalInSeconds + " seconds waiting.", (Throwable)e2);
        }
    }

    public boolean createComponentTemplate(PutComponentTemplateRequest request) {
        return (Boolean)this.executeWithRetries("CreateComponentTemplate " + request.name(), () -> {
            if (!this.templatesExist(request.name()) || !this.getOrDefaultComponentTemplateNumbersOfReplica(request.name(), NO_REPLICA).equals(String.valueOf(this.tasklistProperties.getOpenSearch().getNumberOfReplicas()))) {
                return this.openSearchClient.cluster().putComponentTemplate(request).acknowledged();
            }
            return false;
        });
    }

    protected Map<String, String> getComponentTemplateProperties(String templatePattern, String ... fields) {
        return (Map)this.executeWithRetries("GetComponentTemplateSettings " + templatePattern, () -> {
            HashMap<String, String> settings = new HashMap<String, String>();
            GetComponentTemplateResponse response = this.openSearchClient.cluster().getComponentTemplate(ct -> ct.name(templatePattern));
            if (response.componentTemplates().size() > 0) {
                for (String field : fields) {
                    settings.put(field, ((IndexSettings)((ComponentTemplate)response.componentTemplates().get(0)).componentTemplate().template().settings().get(templatePattern)).numberOfReplicas());
                }
            }
            return settings;
        });
    }

    public String getOrDefaultComponentTemplateNumbersOfReplica(String templatePattern, String defaultValue) {
        Map<String, String> settings = this.getComponentTemplateProperties(templatePattern, NUMBERS_OF_REPLICA);
        String numbersOfReplica = (String)CollectionUtil.getOrDefaultForNullValue(settings, (Object)NUMBERS_OF_REPLICA, (Object)defaultValue);
        if (numbersOfReplica.trim().equals(NO_REPLICA)) {
            numbersOfReplica = defaultValue;
        }
        return numbersOfReplica;
    }

    public int doWithEachSearchResult(SearchRequest.Builder searchRequest, Consumer<Hit> searchHitConsumer) {
        return (Integer)this.executeWithRetries(() -> {
            int doneOnSearchHits = 0;
            searchRequest.scroll(Time.of(t -> t.time(SCROLL_KEEP_ALIVE_MS)));
            SearchResponse response = this.openSearchClient.search(searchRequest.build(), Object.class);
            String scrollId = null;
            while (response.hits().hits().size() > 0) {
                response.hits().hits().stream().forEach(searchHitConsumer);
                doneOnSearchHits += response.hits().hits().size();
                scrollId = response.scrollId();
                ScrollRequest scrollRequest = new ScrollRequest.Builder().scrollId(scrollId).scroll(Time.of(t -> t.time(SCROLL_KEEP_ALIVE_MS))).build();
                response = this.openSearchClient.scroll(scrollRequest, Object.class);
            }
            OpenSearchUtil.clearScroll(scrollId, this.openSearchClient);
            return doneOnSearchHits;
        });
    }

    public Optional<Response> getLifecyclePolicy(String policyName) {
        Request request = new Request("GET", "/_plugins/_ism/policies/" + policyName);
        try {
            return Optional.ofNullable(this.opensearchRestClient.performRequest(request));
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == HttpStatus.NOT_FOUND.value()) {
                return Optional.empty();
            }
            throw new TasklistRuntimeException("Communication error with OpenSearch", (Throwable)e);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException("Communication error with OpenSearch", (Throwable)e);
        }
    }

    public Response putLifeCyclePolicy(String indexName, String policyName) {
        Request request = new Request("PUT", indexName + "/_settings");
        JsonObject settings = Json.createObjectBuilder().add("index", Json.createObjectBuilder().add("plugins.index_state_management.policy_id", (JsonValue)(policyName != null ? Json.createValue((String)policyName) : JsonValue.NULL))).build();
        request.setJsonEntity(settings.toString());
        try {
            return this.opensearchRestClient.performRequest(request);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException((Throwable)e);
        }
    }

    public JsonArray getIndexTemplateSettings(String templatePattern) {
        Request request = new Request("GET", "/_index_template/" + templatePattern);
        try {
            Response response = this.opensearchRestClient.performRequest(request);
            InputStream responseStream = response.getEntity().getContent();
            JsonReader jsonReader = Json.createReader((InputStream)responseStream);
            JsonObject responseObject = jsonReader.readObject();
            jsonReader.close();
            return responseObject.getJsonArray("index_templates");
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == HttpStatus.NOT_FOUND.value()) {
                return null;
            }
            throw new TasklistRuntimeException("Communication error with OpenSearch", (Throwable)e);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException("Communication error with OpenSearch", (Throwable)e);
        }
    }

    public void putIndexTemplateSettings(String templateName, String updateJson) throws IOException {
        Request request = new Request("PUT", "/_index_template/" + templateName);
        request.setJsonEntity(updateJson);
        this.opensearchRestClient.performRequest(request);
    }

    public void putMapping(PutMappingRequest request) {
        this.executeWithRetries("PutMapping " + String.valueOf(request.index()), () -> {
            this.openSearchClient.indices().putMapping(request);
            return true;
        });
    }

    public JsonObject getExplainIndexResponse(String indexName) {
        Request request = new Request("GET", "/_plugins/_ism/explain/" + indexName);
        try {
            Response response = this.opensearchRestClient.performRequest(request);
            InputStream responseStream = response.getEntity().getContent();
            JsonReader jsonReader = Json.createReader((InputStream)responseStream);
            JsonObject responseObject = jsonReader.readObject();
            jsonReader.close();
            return responseObject.getJsonObject(indexName);
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == HttpStatus.NOT_FOUND.value()) {
                return null;
            }
            throw new TasklistRuntimeException("Communication error with OpenSearch", (Throwable)e);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException("Communication error with OpenSearch", (Throwable)e);
        }
    }

    public void addISMPolicyToIndex(String indexName, String policyId) {
        this.executeWithRetries("AddISMPolicyToIndex " + indexName, () -> {
            try {
                Request request = new Request("POST", "/_plugins/_ism/add/" + indexName);
                String policyAssignment = String.format("{\"policy_id\": \"%s\"}", policyId);
                request.setJsonEntity(policyAssignment.toString());
                this.opensearchRestClient.performRequest(request);
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to apply ISM policy to index: " + indexName, e);
            }
        });
    }

    public void removeISMPolicyFromIndex(String indexName) {
        this.executeWithRetries("RemoveISMPolicyToIndex " + indexName, () -> {
            try {
                Request request = new Request("POST", "/_plugins/_ism/remove/" + indexName);
                this.opensearchRestClient.performRequest(request);
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to apply ISM policy to index: " + indexName, e);
            }
        });
    }
}

