/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.os;

import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.tasks.GetTasksResponse;
import org.opensearch.client.opensearch.tasks.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Conditional(value={OpenSearchCondition.class})
public class OpenSearchInternalTask {
    public static final String ERROR = "error";
    public static final String REASON = "reason";
    public static final String RESPONSE = "response";
    public static final String FAILURES = "failures";
    public static final String CAUSE = "cause";
    public static final String SYSTEM_TASKS_INDEX = ".tasks";
    public static final String TOTAL = "total";
    public static final String CREATED = "created";
    public static final String UPDATED = "updated";
    public static final String DELETED = "deleted";
    public static final String TASK_ACTION = "task.action";
    public static final String TASK_ACTION_INDICES_REINDEX = "indices:data/write/reindex";
    public static final String TASK = "task";
    public static final String DESCRIPTION = "description";
    public static final String DESCRIPTION_PREFIX_FROM_INDEX = "reindex from [";
    public static final String DESCRIPTION_PREFIX_TO_INDEX = "to [";
    public static final String NODE = "node";
    public static final int MAX_TASKS_ENTRIES = 2000;
    public static final String ID = "id";
    @Autowired
    @Qualifier(value="tasklistOsClient")
    private OpenSearchClient openSearchClient;

    public void checkForErrorsOrFailures(GetTasksResponse tasks) throws IOException {
        if (tasks != null) {
            this.checkForErrors(tasks);
            this.checkForFailures(tasks);
        }
    }

    public List<String> getRunningReindexTasksIdsFor(String fromIndex, String toIndex) throws IOException {
        if (!this.systemTaskIndexExists() || fromIndex == null || toIndex == null) {
            return List.of();
        }
        return this.getReindexTasks().stream().filter(taskState -> this.descriptionContainsReindexFromTo((Map<String, Object>)taskState, fromIndex, toIndex)).map(this::toTaskId).toList();
    }

    private String toTaskId(Map<String, Object> taskState) {
        return String.format("%s:%s", taskState.get(NODE), taskState.get(ID));
    }

    private boolean descriptionContainsReindexFromTo(Map<String, Object> taskState, String fromIndex, String toIndex) {
        String desc = (String)taskState.get(DESCRIPTION);
        return desc != null && desc.contains(DESCRIPTION_PREFIX_FROM_INDEX + fromIndex) && desc.contains(DESCRIPTION_PREFIX_TO_INDEX + toIndex);
    }

    private List<Map<String, Object>> getReindexTasks() throws IOException {
        SearchResponse searchResponse = this.openSearchClient.search(s -> s.index(SYSTEM_TASKS_INDEX, new String[0]).query(q -> q.term(term -> term.field(TASK_ACTION).value(FieldValue.of((String)TASK_ACTION_INDICES_REINDEX)))).size(Integer.valueOf(2000)), Map.class);
        return searchResponse.hits().hits().stream().map(h -> (Map)((Map)h.source()).get(TASK)).toList();
    }

    private boolean systemTaskIndexExists() throws IOException {
        return this.openSearchClient.indices().exists(e -> e.index(SYSTEM_TASKS_INDEX, new String[0])).value();
    }

    private void checkForErrors(GetTasksResponse taskResponse) {
        if (taskResponse.error() != null) {
            throw new TasklistRuntimeException(taskResponse.error().reason());
        }
    }

    private void checkForFailures(GetTasksResponse taskResponse) {
        if (!CollectionUtils.isEmpty((Collection)taskResponse.response().failures())) {
            throw new TasklistRuntimeException((String)taskResponse.response().failures().get(0));
        }
    }

    public boolean needsToPollAgain(GetTasksResponse taskResponse) {
        if (taskResponse == null) {
            return false;
        }
        Status taskStatus = this.getTaskStatus(taskResponse);
        long total = taskStatus.total();
        long created = taskStatus.created();
        long updated = taskStatus.updated();
        long deleted = taskStatus.deleted();
        return !taskResponse.completed() || created + updated + deleted != total;
    }

    private Status getTaskStatus(GetTasksResponse taskResponse) {
        return taskResponse.task().status();
    }

    public long getTotal(GetTasksResponse taskResponse) {
        return this.getTaskStatus(taskResponse).total();
    }
}

