/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.util;

import com.google.common.collect.Maps;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.IndexMapping;
import io.camunda.tasklist.schema.IndexMappingDifference;
import io.camunda.tasklist.schema.SemanticVersion;
import io.camunda.tasklist.schema.indices.IndexDescriptor;
import io.camunda.tasklist.schema.manager.SchemaManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexSchemaValidatorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexSchemaValidatorUtil.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*-(\\d+\\.\\d+\\.\\d+.*)_.*");
    private static final String STRICT_DYNAMIC_POLICY = "strict";
    @Autowired
    TasklistProperties tasklistProperties;
    @Autowired
    SchemaManager schemaManager;

    public String getIndexPrefix() {
        return "opensearch".equals(this.tasklistProperties.getDatabase()) ? this.tasklistProperties.getOpenSearch().getIndexPrefix() : this.tasklistProperties.getElasticsearch().getIndexPrefix();
    }

    public Set<String> newerVersionsForIndex(IndexDescriptor indexDescriptor, Set<String> versions) {
        SemanticVersion currentVersion = SemanticVersion.fromVersion(indexDescriptor.getVersion());
        return versions.stream().filter(version -> SemanticVersion.fromVersion(version).isNewerThan(currentVersion)).collect(Collectors.toSet());
    }

    public Set<String> olderVersionsForIndex(IndexDescriptor indexDescriptor, Set<String> versions) {
        SemanticVersion currentVersion = SemanticVersion.fromVersion(indexDescriptor.getVersion());
        return versions.stream().filter(version -> currentVersion.isNewerThan(SemanticVersion.fromVersion(version))).collect(Collectors.toSet());
    }

    public Optional<String> getVersionFromIndexName(String indexName) {
        Matcher matcher = VERSION_PATTERN.matcher(indexName);
        if (matcher.matches() && matcher.groupCount() > 0) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    public Map<String, IndexMapping> filterIndexMappings(Map<String, IndexMapping> indexMappings, IndexDescriptor indexDescriptor) {
        return Maps.filterEntries(indexMappings, e -> STRICT_DYNAMIC_POLICY.equals(((IndexMapping)e.getValue()).getDynamic()) && ((String)e.getKey()).matches(indexDescriptor.getAllVersionsIndexNameRegexPattern()));
    }

    public void validateDifferenceAndCollectNewFields(IndexDescriptor indexDescriptor, IndexMappingDifference difference, Map<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> newFields) {
        if (difference == null || difference.isEqual()) {
            LOGGER.debug(String.format("Index fields are up to date. Index name: %s.", indexDescriptor.getIndexName()));
            return;
        }
        if (difference.getEntriesDiffering() != null && difference.getEntriesDiffering().size() > 0 && difference.getEntriesDiffering().stream().noneMatch(this::nonDynamicPropertyDifference)) {
            LOGGER.debug(String.format("Difference is on dynamic field - continue initialization - left %s, right %s. Actual diff values: %s", difference.getLeftIndexMapping().getIndexName(), difference.getRightIndexMapping().getIndexName(), difference.getEntriesDiffering()));
            return;
        }
        LOGGER.debug(String.format("Index fields differ from expected. Index name: %s. Difference: %s.", indexDescriptor.getIndexName(), difference));
        if (!difference.getEntriesDiffering().isEmpty()) {
            String errorMsg = String.format("Index name: %s. Not supported index changes are introduced. Data migration is required. Changes found: %s", indexDescriptor.getIndexName(), difference.getEntriesDiffering());
            LOGGER.error(errorMsg);
            throw new TasklistRuntimeException(errorMsg);
        }
        if (!difference.getEntriesOnlyOnRight().isEmpty()) {
            String message = String.format("Index name: %s. Field deletion is requested, will be ignored. Fields: %s", indexDescriptor.getIndexName(), difference.getEntriesOnlyOnRight());
            LOGGER.info(message);
        } else if (!difference.getEntriesOnlyOnLeft().isEmpty()) {
            newFields.put(indexDescriptor, difference.getEntriesOnlyOnLeft());
        }
    }

    public Map<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> validateIndexMappings(Set<IndexDescriptor> indexDescriptors) throws IOException {
        HashMap<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> newFields = new HashMap<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>>();
        Map<String, IndexMapping> indexMappings = this.schemaManager.getIndexMappings(this.schemaManager.getIndexPrefix() + "*");
        for (IndexDescriptor indexDescriptor : indexDescriptors) {
            Map<String, IndexMapping> indexMappingsGroup = this.filterIndexMappings(indexMappings, indexDescriptor);
            if (indexMappingsGroup.isEmpty()) continue;
            IndexMappingDifference difference = this.getDifference(indexDescriptor, indexMappingsGroup);
            this.validateDifferenceAndCollectNewFields(indexDescriptor, difference, newFields);
        }
        return newFields;
    }

    private IndexMappingDifference getDifference(IndexDescriptor indexDescriptor, Map<String, IndexMapping> indexMappingsGroup) {
        return this.getIndexMappingDifference(indexDescriptor, indexMappingsGroup);
    }

    private IndexMappingDifference getIndexMappingDifference(IndexDescriptor indexDescriptor, Map<String, IndexMapping> indexMappingsGroup) {
        IndexMapping indexMappingMustBe = this.schemaManager.getExpectedIndexFields(indexDescriptor);
        IndexMappingDifference difference = null;
        for (Map.Entry<String, IndexMapping> singleIndexMapping : indexMappingsGroup.entrySet()) {
            IndexMappingDifference currentDifference = new IndexMappingDifference.IndexMappingDifferenceBuilder().setLeft(indexMappingMustBe).setRight(singleIndexMapping.getValue()).build();
            if (currentDifference.isEqual()) continue;
            if (difference == null) {
                difference = currentDifference;
                continue;
            }
            if (difference.checkEqualityForDifferences(currentDifference) || !currentDifference.getEntriesDiffering().stream().anyMatch(this::nonDynamicPropertyDifference)) continue;
            throw new TasklistRuntimeException("Ambiguous schema update. First bring runtime and data indices to one schema. Difference 1:" + String.valueOf(difference) + ". Difference 2: " + String.valueOf(currentDifference));
        }
        return difference;
    }

    private boolean nonDynamicPropertyDifference(IndexMappingDifference.PropertyDifference propertyDifference) {
        Map typeDefMap;
        boolean isDynamic;
        Object typeDefinition = propertyDifference.getLeftValue().getTypeDefinition();
        return !(propertyDifference.getLeftValue().getTypeDefinition() instanceof Map) || !(isDynamic = Boolean.parseBoolean((typeDefMap = (Map)typeDefinition).getOrDefault("dynamic", "false").toString()));
    }
}

