/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.entities.TasklistEntity;
import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.schema.indices.IndexDescriptor;
import io.camunda.tasklist.schema.templates.TemplateDescriptor;
import io.camunda.tasklist.tenant.TenantAwareElasticsearchClient;
import io.camunda.tasklist.util.CollectionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElasticsearchUtil {
    public static final String ZEEBE_INDEX_DELIMITER = "_";
    public static final int SCROLL_KEEP_ALIVE_MS = 60000;
    public static final int INTERNAL_SCROLL_KEEP_ALIVE_MS = 30000;
    public static final int QUERY_MAX_SIZE = 10000;
    public static final int UPDATE_RETRY_COUNT = 3;
    public static final Function<SearchHit, Long> SEARCH_HIT_ID_TO_LONG = hit -> Long.valueOf(hit.getId());
    public static final Function<SearchHit, String> SEARCH_HIT_ID_TO_STRING = SearchHit::getId;
    public static final IndicesOptions LENIENT_EXPAND_OPEN_FORBID_NO_INDICES_IGNORE_THROTTLED = new IndicesOptions(EnumSet.of(IndicesOptions.Option.IGNORE_UNAVAILABLE, IndicesOptions.Option.IGNORE_THROTTLED), EnumSet.of(IndicesOptions.WildcardStates.OPEN));
    public static final IndicesOptions LENIENT_EXPAND_OPEN_IGNORE_THROTTLED = new IndicesOptions(EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_UNAVAILABLE, IndicesOptions.Option.IGNORE_THROTTLED), EnumSet.of(IndicesOptions.WildcardStates.OPEN));
    public static final IndicesOptions STRICT_EXPAND_OPEN_CLOSED_IGNORE_THROTTLED = new IndicesOptions(EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_THROTTLED), EnumSet.of(IndicesOptions.WildcardStates.OPEN, IndicesOptions.WildcardStates.CLOSED));
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchUtil.class);

    public static SearchRequest createSearchRequest(TemplateDescriptor template) {
        return ElasticsearchUtil.createSearchRequest(template, QueryType.ALL);
    }

    public static SearchHit getRawResponseWithTenantCheck(String id, IndexDescriptor descriptor, QueryType queryType, TenantAwareElasticsearchClient tenantAwareClient) throws IOException {
        IdsQueryBuilder query = QueryBuilders.idsQuery().addIds(new String[]{id});
        SearchRequest request = ElasticsearchUtil.createSearchRequest(descriptor, queryType).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)query)));
        SearchResponse response = tenantAwareClient.search(request);
        if (response.getHits().getTotalHits().value == 1L) {
            return response.getHits().getHits()[0];
        }
        if (response.getHits().getTotalHits().value > 1L) {
            throw new NotFoundException(String.format("Unique %s with id %s was not found", descriptor.getIndexName(), id));
        }
        throw new NotFoundException(String.format("%s with id %s was not found", descriptor.getIndexName(), id));
    }

    public static CompletableFuture<BulkByScrollResponse> reindexAsync(ReindexRequest reindexRequest, Executor executor, RestHighLevelClient esClient) {
        CompletableFuture<BulkByScrollResponse> reindexFuture = new CompletableFuture<BulkByScrollResponse>();
        esClient.reindexAsync(reindexRequest, RequestOptions.DEFAULT, new DelegatingActionListener(reindexFuture, executor));
        return reindexFuture;
    }

    public static CompletableFuture<BulkByScrollResponse> deleteByQueryAsync(DeleteByQueryRequest deleteRequest, Executor executor, RestHighLevelClient esClient) {
        CompletableFuture<BulkByScrollResponse> deleteFuture = new CompletableFuture<BulkByScrollResponse>();
        esClient.deleteByQueryAsync(deleteRequest, RequestOptions.DEFAULT, new DelegatingActionListener(deleteFuture, executor));
        return deleteFuture;
    }

    public static CompletableFuture<SearchResponse> searchAsync(SearchRequest searchRequest, Executor executor, RestHighLevelClient esClient) {
        CompletableFuture<SearchResponse> searchFuture = new CompletableFuture<SearchResponse>();
        esClient.searchAsync(searchRequest, RequestOptions.DEFAULT, new DelegatingActionListener(searchFuture, executor));
        return searchFuture;
    }

    public static CompletableFuture<SearchResponse> scrollAsync(SearchScrollRequest scrollRequest, Executor executor, RestHighLevelClient esClient) {
        CompletableFuture<SearchResponse> searchFuture = new CompletableFuture<SearchResponse>();
        esClient.scrollAsync(scrollRequest, RequestOptions.DEFAULT, new DelegatingActionListener(searchFuture, executor));
        return searchFuture;
    }

    public static SearchRequest createSearchRequest(IndexDescriptor descriptor, QueryType queryType) {
        return new SearchRequest(new String[]{ElasticsearchUtil.whereToSearch(descriptor, queryType)});
    }

    public static String whereToSearch(IndexDescriptor descriptor, QueryType queryType) {
        switch (queryType.ordinal()) {
            case 0: {
                return descriptor.getFullQualifiedName();
            }
        }
        return descriptor.getAlias();
    }

    public static QueryBuilder joinWithOr(BoolQueryBuilder boolQueryBuilder, QueryBuilder ... queries) {
        List notNullQueries = CollectionUtil.throwAwayNullElements((Object[])queries);
        for (QueryBuilder query : notNullQueries) {
            boolQueryBuilder.should(query);
        }
        return boolQueryBuilder;
    }

    public static QueryBuilder joinWithOr(QueryBuilder ... queries) {
        List notNullQueries = CollectionUtil.throwAwayNullElements((Object[])queries);
        switch (notNullQueries.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (QueryBuilder)notNullQueries.get(0);
            }
        }
        BoolQueryBuilder boolQ = QueryBuilders.boolQuery();
        for (QueryBuilder query : notNullQueries) {
            boolQ.should(query);
        }
        return boolQ;
    }

    public static QueryBuilder joinWithOr(Collection<QueryBuilder> queries) {
        return ElasticsearchUtil.joinWithOr(queries.toArray(new QueryBuilder[queries.size()]));
    }

    public static QueryBuilder joinWithAnd(QueryBuilder ... queries) {
        List notNullQueries = CollectionUtil.throwAwayNullElements((Object[])queries);
        switch (notNullQueries.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (QueryBuilder)notNullQueries.get(0);
            }
        }
        BoolQueryBuilder boolQ = QueryBuilders.boolQuery();
        for (QueryBuilder query : notNullQueries) {
            boolQ.must(query);
        }
        return boolQ;
    }

    public static QueryBuilder addToBoolMust(BoolQueryBuilder boolQuery, QueryBuilder ... queries) {
        if (boolQuery.mustNot().size() != 0 || boolQuery.filter().size() != 0 || boolQuery.should().size() != 0) {
            throw new IllegalArgumentException("BoolQuery with only must elements is expected here.");
        }
        List notNullQueries = CollectionUtil.throwAwayNullElements((Object[])queries);
        for (QueryBuilder query : notNullQueries) {
            boolQuery.must(query);
        }
        return boolQuery;
    }

    public static BoolQueryBuilder createMatchNoneQuery() {
        return QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.wrapperQuery((String)"{\"match_none\": {}}"));
    }

    public static void processBulkRequest(RestHighLevelClient esClient, BulkRequest bulkRequest) throws PersistenceException {
        ElasticsearchUtil.processBulkRequest(esClient, bulkRequest, WriteRequest.RefreshPolicy.NONE);
    }

    public static void processBulkRequest(RestHighLevelClient esClient, BulkRequest bulkRequest, WriteRequest.RefreshPolicy refreshPolicy) throws PersistenceException {
        if (bulkRequest.requests().size() > 0) {
            try {
                BulkItemResponse[] items;
                LOGGER.debug("************* FLUSH BULK START *************");
                bulkRequest = bulkRequest.setRefreshPolicy(refreshPolicy);
                BulkResponse bulkItemResponses = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                for (BulkItemResponse responseItem : items = bulkItemResponses.getItems()) {
                    if (!responseItem.isFailed()) continue;
                    LOGGER.error(String.format("%s failed for type [%s] and id [%s]: %s", responseItem.getOpType(), responseItem.getIndex(), responseItem.getId(), responseItem.getFailureMessage()), (Throwable)responseItem.getFailure().getCause());
                    throw new PersistenceException("Operation failed: " + responseItem.getFailureMessage(), (Throwable)responseItem.getFailure().getCause(), Integer.valueOf(responseItem.getItemId()));
                }
                LOGGER.debug("************* FLUSH BULK FINISH *************");
            }
            catch (IOException ex) {
                throw new PersistenceException("Error when processing bulk request against Elasticsearch: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static void executeUpdate(RestHighLevelClient esClient, UpdateRequest updateRequest) throws PersistenceException {
        try {
            esClient.update(updateRequest, RequestOptions.DEFAULT);
        }
        catch (IOException | ElasticsearchException e) {
            String errorMessage = String.format("Update request failed for [%s] and id [%s] with the message [%s].", updateRequest.index(), updateRequest.id(), e.getMessage());
            throw new PersistenceException(errorMessage, e);
        }
    }

    public static <T> List<T> mapSearchHits(List<SearchHit> searchHits, ObjectMapper objectMapper, JavaType valueType) {
        return ElasticsearchUtil.mapSearchHits(searchHits.toArray(new SearchHit[searchHits.size()]), objectMapper, valueType);
    }

    public static <T> List<T> mapSearchHits(SearchHit[] searchHits, Function<SearchHit, T> searchHitMapper) {
        return CollectionUtil.map((Object[])searchHits, searchHitMapper);
    }

    public static <T> List<T> mapSearchHits(SearchHit[] searchHits, ObjectMapper objectMapper, Class<T> clazz) {
        return CollectionUtil.map((Object[])searchHits, searchHit -> ElasticsearchUtil.fromSearchHit(searchHit.getSourceAsString(), objectMapper, clazz));
    }

    public static <T> T fromSearchHit(String searchHitString, ObjectMapper objectMapper, Class<T> clazz) {
        Object entity;
        try {
            entity = objectMapper.readValue(searchHitString, clazz);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error while reading entity of type %s from Elasticsearch!", clazz.getName()), (Throwable)e);
        }
        return (T)entity;
    }

    public static <T> List<T> mapSearchHits(SearchHit[] searchHits, ObjectMapper objectMapper, JavaType valueType) {
        return CollectionUtil.map((Object[])searchHits, searchHit -> ElasticsearchUtil.fromSearchHit(searchHit.getSourceAsString(), objectMapper, valueType));
    }

    public static <T> T fromSearchHit(String searchHitString, ObjectMapper objectMapper, JavaType valueType) {
        Object entity;
        try {
            entity = objectMapper.readValue(searchHitString, valueType);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error while reading entity of type %s from Elasticsearch!", valueType.toString()), (Throwable)e);
        }
        return (T)entity;
    }

    public static <T extends TasklistEntity> List<T> scroll(SearchRequest searchRequest, Class<T> clazz, ObjectMapper objectMapper, RestHighLevelClient esClient) throws IOException {
        return ElasticsearchUtil.scroll(searchRequest, clazz, objectMapper, esClient, null, null);
    }

    public static <T extends TasklistEntity> List<T> scroll(SearchRequest searchRequest, Class<T> clazz, ObjectMapper objectMapper, RestHighLevelClient esClient, Consumer<SearchHits> searchHitsProcessor, Consumer<Aggregations> aggsProcessor) throws IOException {
        searchRequest.scroll(TimeValue.timeValueMillis((long)60000L));
        SearchResponse response = esClient.search(searchRequest, RequestOptions.DEFAULT);
        if (aggsProcessor != null) {
            aggsProcessor.accept(response.getAggregations());
        }
        ArrayList<T> result = new ArrayList<T>();
        String scrollId = response.getScrollId();
        SearchHits hits = response.getHits();
        while (hits.getHits().length != 0) {
            result.addAll(ElasticsearchUtil.mapSearchHits(hits.getHits(), objectMapper, clazz));
            if (searchHitsProcessor != null) {
                searchHitsProcessor.accept(response.getHits());
            }
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
            scrollRequest.scroll(TimeValue.timeValueMillis((long)60000L));
            response = esClient.scroll(scrollRequest, RequestOptions.DEFAULT);
            scrollId = response.getScrollId();
            hits = response.getHits();
        }
        ElasticsearchUtil.clearScroll(scrollId, esClient);
        return result;
    }

    public static void scrollWith(SearchRequest searchRequest, RestHighLevelClient esClient, Consumer<SearchHits> searchHitsProcessor, Consumer<Aggregations> aggsProcessor, Consumer<SearchHits> firstResponseConsumer) throws IOException {
        searchRequest.scroll(TimeValue.timeValueMillis((long)60000L));
        SearchResponse response = esClient.search(searchRequest, RequestOptions.DEFAULT);
        if (firstResponseConsumer != null) {
            firstResponseConsumer.accept(response.getHits());
        }
        if (aggsProcessor != null) {
            aggsProcessor.accept(response.getAggregations());
        }
        String scrollId = response.getScrollId();
        SearchHits hits = response.getHits();
        while (hits.getHits().length != 0) {
            if (searchHitsProcessor != null) {
                searchHitsProcessor.accept(response.getHits());
            }
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
            scrollRequest.scroll(TimeValue.timeValueMillis((long)60000L));
            response = esClient.scroll(scrollRequest, RequestOptions.DEFAULT);
            scrollId = response.getScrollId();
            hits = response.getHits();
        }
        ElasticsearchUtil.clearScroll(scrollId, esClient);
    }

    public static void clearScroll(String scrollId, RestHighLevelClient esClient) {
        if (scrollId != null) {
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
            clearScrollRequest.addScrollId(scrollId);
            try {
                esClient.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
            }
            catch (Exception e) {
                LOGGER.warn("Error occurred when clearing the scroll with id [{}]", (Object)scrollId);
            }
        }
    }

    public static List<String> scrollIdsToList(SearchRequest request, RestHighLevelClient esClient) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Consumer<SearchHits> collectIds = hits -> result.addAll(CollectionUtil.map((Object[])hits.getHits(), SEARCH_HIT_ID_TO_STRING));
        ElasticsearchUtil.scrollWith(request, esClient, collectIds, null, null);
        return result;
    }

    public static Map<String, String> scrollIdsWithIndexToMap(SearchRequest request, RestHighLevelClient esClient) throws IOException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Consumer<SearchHits> collectIds = hits -> result.putAll(Stream.of(hits.getHits()).collect(Collectors.toMap(SearchHit::getId, SearchHit::getIndex)));
        ElasticsearchUtil.scrollWith(request, esClient, collectIds, null, null);
        return result;
    }

    public static List<Long> scrollKeysToList(SearchRequest request, RestHighLevelClient esClient) throws IOException {
        ArrayList<Long> result = new ArrayList<Long>();
        Consumer<SearchHits> collectIds = hits -> result.addAll(CollectionUtil.map((Object[])hits.getHits(), SEARCH_HIT_ID_TO_LONG));
        ElasticsearchUtil.scrollWith(request, esClient, collectIds, null, null);
        return result;
    }

    public static <T> List<T> scrollFieldToList(SearchRequest request, String fieldName, RestHighLevelClient esClient) throws IOException {
        ArrayList result = new ArrayList();
        Function<SearchHit, Object> searchHitFieldToString = searchHit -> searchHit.getSourceAsMap().get(fieldName);
        Consumer<SearchHits> collectFields = hits -> result.addAll(CollectionUtil.map((Object[])hits.getHits(), (Function)searchHitFieldToString));
        ElasticsearchUtil.scrollWith(request, esClient, collectFields, null, null);
        return result;
    }

    public static Set<String> scrollIdsToSet(SearchRequest request, RestHighLevelClient esClient) throws IOException {
        HashSet<String> result = new HashSet<String>();
        Consumer<SearchHits> collectIds = hits -> result.addAll(CollectionUtil.map((Object[])hits.getHits(), SEARCH_HIT_ID_TO_STRING));
        ElasticsearchUtil.scrollWith(request, esClient, collectIds, null, collectIds);
        return result;
    }

    public static Set<Long> scrollKeysToSet(SearchRequest request, RestHighLevelClient esClient) throws IOException {
        HashSet<Long> result = new HashSet<Long>();
        Consumer<SearchHits> collectIds = hits -> result.addAll(CollectionUtil.map((Object[])hits.getHits(), SEARCH_HIT_ID_TO_LONG));
        ElasticsearchUtil.scrollWith(request, esClient, collectIds, null, null);
        return result;
    }

    public static void refreshIndicesFor(RestHighLevelClient esClient, String indexPattern) {
        RefreshRequest refreshRequest = new RefreshRequest(new String[]{indexPattern});
        try {
            RefreshResponse refresh = esClient.indices().refresh(refreshRequest, RequestOptions.DEFAULT);
            if (refresh.getFailedShards() > 0) {
                LOGGER.warn("Unable to refresh indices: {}", (Object)indexPattern);
            }
        }
        catch (Exception ex) {
            LOGGER.warn(String.format("Unable to refresh indices: %s", indexPattern), (Throwable)ex);
        }
    }

    public static enum QueryType {
        ONLY_RUNTIME,
        ALL;

    }

    private static final class DelegatingActionListener<Response>
    implements ActionListener<Response> {
        private final CompletableFuture<Response> future;
        private final Executor executorDelegate;

        private DelegatingActionListener(CompletableFuture<Response> future, Executor executor) {
            this.future = future;
            this.executorDelegate = executor;
        }

        public void onResponse(Response response) {
            this.executorDelegate.execute(() -> this.future.complete(response));
        }

        public void onFailure(Exception e) {
            this.executorDelegate.execute(() -> this.future.completeExceptionally(e));
        }
    }
}

