/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.opensearch;

import io.camunda.tasklist.CommonUtils;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.FlowNodeInstanceEntity;
import io.camunda.tasklist.entities.TaskVariableEntity;
import io.camunda.tasklist.entities.VariableEntity;
import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.FlowNodeInstanceIndex;
import io.camunda.tasklist.schema.indices.VariableIndex;
import io.camunda.tasklist.schema.templates.TaskVariableTemplate;
import io.camunda.tasklist.store.VariableStore;
import io.camunda.tasklist.tenant.TenantAwareOpenSearchClient;
import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.util.OpenSearchUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.query_dsl.ConstantScoreQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class VariableStoreOpenSearch
implements VariableStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableStoreOpenSearch.class);
    @Autowired
    @Qualifier(value="tasklistOsClient")
    private OpenSearchClient osClient;
    @Autowired
    private TenantAwareOpenSearchClient tenantAwareClient;
    @Autowired
    private FlowNodeInstanceIndex flowNodeInstanceIndex;
    @Autowired
    private VariableIndex variableIndex;
    @Autowired
    private TaskVariableTemplate taskVariableTemplate;
    @Autowired
    private TasklistProperties tasklistProperties;

    @Override
    public List<VariableEntity> getVariablesByFlowNodeInstanceIds(List<String> flowNodeInstanceIds, List<String> varNames, Set<String> fieldNames) {
        Query.Builder flowNodeInstanceKeyQ = new Query.Builder();
        flowNodeInstanceKeyQ.terms(terms -> terms.field("scopeFlowNodeId").terms(t -> t.value(flowNodeInstanceIds.stream().map(m -> FieldValue.of((String)m)).collect(Collectors.toList()))));
        Query.Builder varNamesQ = null;
        if (CollectionUtil.isNotEmpty(varNames)) {
            varNamesQ = new Query.Builder();
            varNamesQ.terms(terms -> terms.field("name").terms(t -> t.value(varNames.stream().map(m -> FieldValue.of((String)m)).collect(Collectors.toList()))));
        }
        Query.Builder query = new Query.Builder();
        query.constantScore(new ConstantScoreQuery.Builder().filter(OpenSearchUtil.joinWithAnd(new ObjectBuilder[]{flowNodeInstanceKeyQ, varNamesQ})).build());
        SearchRequest.Builder searchRequest = new SearchRequest.Builder();
        searchRequest.index(this.variableIndex.getAlias(), new String[0]).query(query.build());
        this.applyFetchSourceForVariableIndex(searchRequest, fieldNames);
        try {
            return OpenSearchUtil.scroll(searchRequest, VariableEntity.class, this.osClient);
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining all variables: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public Map<String, List<TaskVariableEntity>> getTaskVariablesPerTaskId(List<VariableStore.GetVariablesRequest> requests) {
        if (requests == null || requests.size() == 0) {
            return new HashMap<String, List<TaskVariableEntity>>();
        }
        Query.Builder taskIdsQ = new Query.Builder();
        List ids = requests.stream().map(VariableStore.GetVariablesRequest::getTaskId).collect(Collectors.toList());
        taskIdsQ.terms(terms -> terms.field("taskId").terms(t -> t.value(ids.stream().map(m -> FieldValue.of((String)m)).collect(Collectors.toList()))));
        List varNames = requests.stream().map(VariableStore.GetVariablesRequest::getVarNames).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        Query.Builder varNamesQ = null;
        if (CollectionUtil.isNotEmpty(varNames)) {
            varNamesQ = new Query.Builder();
            varNamesQ.terms(terms -> terms.field("name").terms(t -> t.value(varNames.stream().map(m -> FieldValue.of((String)m)).collect(Collectors.toList()))));
        }
        SearchRequest.Builder searchRequestBuilder = new SearchRequest.Builder();
        Query joins = OpenSearchUtil.joinWithAnd(new ObjectBuilder[]{taskIdsQ, varNamesQ});
        searchRequestBuilder.query(q -> q.constantScore(cs -> cs.filter(joins)));
        searchRequestBuilder.index(this.taskVariableTemplate.getAlias(), new String[0]);
        this.applyFetchSourceForTaskVariableTemplate(searchRequestBuilder, requests.get(0).getFieldNames());
        try {
            List<TaskVariableEntity> entities = OpenSearchUtil.scroll(searchRequestBuilder, TaskVariableEntity.class, this.osClient);
            return entities.stream().collect(Collectors.groupingBy(TaskVariableEntity::getTaskId, Collectors.mapping(Function.identity(), Collectors.toList())));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining all variables: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getTaskVariablesIdsWithIndexByTaskIds(List<String> taskIds) {
        SearchRequest.Builder searchRequest = OpenSearchUtil.createSearchRequest(this.taskVariableTemplate).query(q -> q.terms(terms -> terms.field("taskId").terms(t -> t.value(taskIds.stream().map(FieldValue::of).collect(Collectors.toList()))))).fields(f -> f.field("id"));
        try {
            return OpenSearchUtil.scrollIdsWithIndexToMap(searchRequest, this.osClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void persistTaskVariables(Collection<TaskVariableEntity> finalVariables) {
        BulkRequest.Builder bulkRequest = new BulkRequest.Builder();
        ArrayList<BulkOperation> operations = new ArrayList<BulkOperation>();
        for (TaskVariableEntity variableEntity : finalVariables) {
            operations.add(this.createUpsertRequest(variableEntity));
        }
        bulkRequest.operations(operations);
        bulkRequest.refresh(Refresh.WaitFor);
        try {
            OpenSearchUtil.processBulkRequest(this.osClient, bulkRequest.build());
        }
        catch (PersistenceException ex) {
            throw new TasklistRuntimeException((Throwable)ex);
        }
    }

    private BulkOperation createUpsertRequest(TaskVariableEntity variableEntity) {
        return (BulkOperation)new BulkOperation.Builder().update(UpdateOperation.of(i -> ((UpdateOperation.Builder)((UpdateOperation.Builder)i.index(this.taskVariableTemplate.getFullQualifiedName())).id(variableEntity.getId())).docAsUpsert(Boolean.valueOf(true)).document((Object)CommonUtils.getJsonObjectFromEntity((Object)variableEntity)).retryOnConflict(Integer.valueOf(3)))).build();
    }

    @Override
    public List<FlowNodeInstanceEntity> getFlowNodeInstances(List<String> processInstanceIds) {
        SearchRequest.Builder searchRequestBuilder = new SearchRequest.Builder();
        searchRequestBuilder.index(this.flowNodeInstanceIndex.getAlias(), new String[0]).query(q -> q.constantScore(cs -> cs.filter(f -> f.terms(terms -> terms.field("processInstanceId").terms(t -> t.value(processInstanceIds.stream().map(m -> FieldValue.of((String)m)).collect(Collectors.toList()))))))).sort(sort -> sort.field(f -> f.field("position").order(SortOrder.Asc))).size(Integer.valueOf(this.tasklistProperties.getOpenSearch().getBatchSize()));
        try {
            return OpenSearchUtil.scroll(searchRequestBuilder, FlowNodeInstanceEntity.class, this.osClient);
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining all flow nodes: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public VariableEntity getRuntimeVariable(String variableId, Set<String> fieldNames) {
        SearchRequest.Builder request = new SearchRequest.Builder();
        request.index(this.variableIndex.getAlias(), new String[0]).query(q -> q.ids(ids -> ids.values(variableId, new String[0])));
        this.applyFetchSourceForVariableIndex(request, fieldNames);
        try {
            SearchResponse response = this.tenantAwareClient.search(request, VariableEntity.class);
            if (response.hits().total().value() == 1L) {
                return (VariableEntity)((Hit)response.hits().hits().get(0)).source();
            }
            if (response.hits().total().value() > 1L) {
                throw new NotFoundException(String.format("Unique variable with id %s was not found", variableId));
            }
            throw new NotFoundException(String.format("Variable with id %s was not found", variableId));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining variable: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public TaskVariableEntity getTaskVariable(String variableId, Set<String> fieldNames) {
        SearchRequest.Builder request = OpenSearchUtil.createSearchRequest(this.taskVariableTemplate);
        request.query(q -> q.ids(ids -> ids.values(variableId, new String[0])));
        this.applyFetchSourceForTaskVariableTemplate(request, fieldNames);
        try {
            SearchResponse response = this.tenantAwareClient.search(request, TaskVariableEntity.class);
            if (response.hits().total().value() == 1L) {
                return (TaskVariableEntity)((Hit)response.hits().hits().get(0)).source();
            }
            if (response.hits().total().value() > 1L) {
                throw new NotFoundException(String.format("Unique task variable with id %s was not found", variableId));
            }
            throw new NotFoundException(String.format("Task variable with id %s was not found", variableId));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining task variable: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public List<String> getProcessInstanceIdsWithMatchingVars(List<String> varNames, List<String> varValues) {
        ArrayList listProcessIdsMatchingVars = new ArrayList();
        for (int i = 0; i < varNames.size(); ++i) {
            Query.Builder nameQ = new Query.Builder();
            int finalI = i;
            nameQ.terms(terms -> terms.field("name").terms(t -> t.value(Collections.singletonList(FieldValue.of((String)((String)varNames.get(finalI)))))));
            Query.Builder valueQ = new Query.Builder();
            valueQ.terms(terms -> terms.field("value").terms(t -> t.value(Collections.singletonList(FieldValue.of((String)((String)varValues.get(finalI)))))));
            Query boolQuery = OpenSearchUtil.joinWithAnd(new ObjectBuilder[]{nameQ, valueQ});
            SearchRequest.Builder searchRequestBuilder = new SearchRequest.Builder();
            searchRequestBuilder.index(this.variableIndex.getAlias(), new String[0]).query(q -> q.constantScore(cs -> cs.filter(boolQuery))).scroll(timeBuilder -> timeBuilder.time("60000ms"));
            HashSet processInstanceIds = new HashSet();
            try {
                SearchResponse response = this.osClient.search(searchRequestBuilder.build(), VariableEntity.class);
                List scrollProcessIds = response.hits().hits().stream().map(hit -> ((VariableEntity)hit.source()).getProcessInstanceId()).collect(Collectors.toList());
                processInstanceIds.addAll(scrollProcessIds);
                String scrollId = response.scrollId();
                while (!scrollProcessIds.isEmpty()) {
                    ScrollRequest scrollRequest = ScrollRequest.of(builder -> builder.scrollId(scrollId).scroll((Time)new Time.Builder().time("60000ms").build()));
                    response = this.osClient.scroll(scrollRequest, VariableEntity.class);
                    scrollProcessIds = response.hits().hits().stream().map(hit -> ((VariableEntity)hit.source()).getProcessInstanceId()).collect(Collectors.toList());
                    processInstanceIds.addAll(scrollProcessIds);
                }
                OpenSearchUtil.clearScroll(scrollId, this.osClient);
                listProcessIdsMatchingVars.add(processInstanceIds);
                continue;
            }
            catch (IOException e) {
                String message = String.format("Exception occurred while obtaining flowInstanceIds: %s", e.getMessage());
                throw new TasklistRuntimeException(message, (Throwable)e);
            }
        }
        return new ArrayList<String>(listProcessIdsMatchingVars.stream().reduce((set1, set2) -> {
            set1.retainAll((Collection<?>)set2);
            return set1;
        }).orElse(Collections.emptySet()));
    }

    private void applyFetchSourceForVariableIndex(SearchRequest.Builder searchSourceBuilder, Set<String> fieldNames) {
        if (CollectionUtil.isNotEmpty(fieldNames)) {
            Set<String> elsFieldNames = VariableIndex.getElsFieldsByGraphqlFields(fieldNames);
            elsFieldNames.add("id");
            elsFieldNames.add("name");
            elsFieldNames.add("scopeFlowNodeId");
            String[] includesFields = elsFieldNames.toArray(new String[elsFieldNames.size()]);
            searchSourceBuilder.source(s -> s.filter(f -> f.includes(Arrays.asList(includesFields))));
        }
    }

    private void applyFetchSourceForTaskVariableTemplate(SearchRequest.Builder searchRequestBuilder, Set<String> fieldNames) {
        if (CollectionUtil.isNotEmpty(fieldNames)) {
            Set<String> elsFieldNames = TaskVariableTemplate.getElsFieldsByGraphqlFields(fieldNames);
            elsFieldNames.add("id");
            elsFieldNames.add("name");
            elsFieldNames.add("taskId");
            String[] includesFields = elsFieldNames.toArray(new String[elsFieldNames.size()]);
            searchRequestBuilder.source(s -> s.filter(f -> f.includes(Arrays.asList(includesFields))));
        }
    }
}

