/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.TaskEntity;
import io.camunda.tasklist.entities.TaskState;
import io.camunda.tasklist.entities.TaskVariableEntity;
import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.queries.RangeValueFilter;
import io.camunda.tasklist.queries.Sort;
import io.camunda.tasklist.queries.TaskByVariables;
import io.camunda.tasklist.queries.TaskOrderBy;
import io.camunda.tasklist.queries.TaskQuery;
import io.camunda.tasklist.queries.TaskSortFields;
import io.camunda.tasklist.schema.templates.TaskTemplate;
import io.camunda.tasklist.schema.templates.TaskVariableTemplate;
import io.camunda.tasklist.store.TaskStore;
import io.camunda.tasklist.store.VariableStore;
import io.camunda.tasklist.store.util.TaskVariableSearchUtil;
import io.camunda.tasklist.tenant.TenantAwareOpenSearchClient;
import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.util.OpenSearchUtil;
import io.camunda.tasklist.views.TaskSearchView;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.ScriptSortType;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.query_dsl.MatchAllQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class TaskStoreOpenSearch
implements TaskStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStoreOpenSearch.class);
    private static final Map<TaskState, String> SORT_FIELD_PER_STATE = Map.of(TaskState.CREATED, "creationTime", TaskState.COMPLETED, "completionTime", TaskState.CANCELED, "completionTime");
    @Autowired
    @Qualifier(value="tasklistOsClient")
    private OpenSearchClient osClient;
    @Autowired
    private TenantAwareOpenSearchClient tenantAwareClient;
    @Autowired
    private TaskTemplate taskTemplate;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private VariableStore variableStoreElasticSearch;
    @Autowired
    private TaskVariableTemplate taskVariableTemplate;
    @Autowired
    private TaskVariableSearchUtil taskVariableSearchUtil;

    @Override
    public TaskEntity getTask(String id) {
        try {
            return OpenSearchUtil.getRawResponseWithTenantCheck(id, this.taskTemplate, OpenSearchUtil.QueryType.ALL, this.tenantAwareClient, TaskEntity.class);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<String> getTaskIdsByProcessInstanceId(String processInstanceId) {
        SearchRequest.Builder searchRequest = OpenSearchUtil.createSearchRequest(this.taskTemplate).query(q -> q.term(term -> term.field("processInstanceId").value(FieldValue.of((String)processInstanceId)))).fields(f -> f.field("id"));
        try {
            return OpenSearchUtil.scrollIdsToList(searchRequest, this.osClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getTaskIdsWithIndexByProcessDefinitionId(String processDefinitionId) {
        SearchRequest.Builder searchRequest = OpenSearchUtil.createSearchRequest(this.taskTemplate).query(q -> q.term(term -> term.field("processDefinitionId").value(FieldValue.of((String)processDefinitionId)))).fields(f -> f.field("id"));
        try {
            return OpenSearchUtil.scrollIdsWithIndexToMap(searchRequest, this.osClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<TaskSearchView> getTasks(TaskQuery query) {
        List<TaskSearchView> response = this.queryTasks(query);
        if (query.getSearchAfterOrEqual() != null || query.getSearchBeforeOrEqual() != null) {
            this.adjustResponse(response, query);
        }
        if (response.size() > 0 && (query.getSearchAfter() != null || query.getSearchAfterOrEqual() != null)) {
            TaskSearchView firstTask = response.get(0);
            firstTask.setFirst(this.checkTaskIsFirst(query, firstTask.getId()));
        }
        return response;
    }

    @Override
    public TaskEntity persistTaskCompletion(TaskEntity taskBefore) {
        Hit taskBeforeSearchHit;
        try {
            taskBeforeSearchHit = this.getTaskRawResponse(taskBefore.getId());
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
        TaskEntity completedTask = taskBefore.makeCopy().setState(TaskState.COMPLETED).setCompletionTime(OffsetDateTime.now());
        try {
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            updateFields.put("state", completedTask.getState());
            updateFields.put("completionTime", completedTask.getCompletionTime());
            Map jsonMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class);
            UpdateRequest.Builder updateRequest = new UpdateRequest.Builder();
            updateRequest.index(this.taskTemplate.getFullQualifiedName()).id(taskBeforeSearchHit.id()).doc((Object)jsonMap).refresh(Refresh.WaitFor).ifSeqNo(taskBeforeSearchHit.seqNo()).ifPrimaryTerm(taskBeforeSearchHit.primaryTerm());
            OpenSearchUtil.executeUpdate(this.osClient, updateRequest.build());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return completedTask;
    }

    @Override
    public TaskEntity rollbackPersistTaskCompletion(TaskEntity taskBefore) {
        Hit taskBeforeSearchHit;
        try {
            taskBeforeSearchHit = this.getTaskRawResponse(taskBefore.getId());
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
        TaskEntity completedTask = taskBefore.makeCopy().setCompletionTime(null);
        try {
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            updateFields.put("state", completedTask.getState());
            updateFields.put("completionTime", completedTask.getCompletionTime());
            Map jsonMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class);
            UpdateRequest.Builder updateRequest = new UpdateRequest.Builder();
            updateRequest.index(this.taskTemplate.getFullQualifiedName()).id(taskBeforeSearchHit.id()).doc((Object)jsonMap).refresh(Refresh.WaitFor).ifSeqNo(taskBeforeSearchHit.seqNo()).ifPrimaryTerm(taskBeforeSearchHit.primaryTerm());
            OpenSearchUtil.executeUpdate(this.osClient, updateRequest.build());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return completedTask;
    }

    @Override
    public TaskEntity persistTaskClaim(TaskEntity taskBefore, String assignee) {
        this.updateTask(taskBefore.getId(), CollectionUtil.asMap((Object[])new Object[]{"assignee", assignee}));
        return taskBefore.makeCopy().setAssignee(assignee);
    }

    @Override
    public TaskEntity persistTaskUnclaim(TaskEntity task) {
        this.updateTask(task.getId(), CollectionUtil.asMap((Object[])new Object[]{"assignee", null}));
        return task.makeCopy().setAssignee(null);
    }

    @Override
    public List<TaskEntity> getTasksById(List<String> ids) {
        try {
            List<Hit<TaskEntity>> response = this.getTasksRawResponse(ids);
            return response.stream().map(Hit::source).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateTaskLinkedForm(TaskEntity task, String formBpmnId, long formVersion) {
        this.updateTask(task.getId(), CollectionUtil.asMap((Object[])new Object[]{"formId", formBpmnId, "formVersion", formVersion}));
    }

    private void adjustResponse(List<TaskSearchView> response, TaskQuery request) {
        String taskId = null;
        if (request.getSearchAfterOrEqual() != null) {
            taskId = request.getSearchAfterOrEqual()[1];
        } else if (request.getSearchBeforeOrEqual() != null) {
            taskId = request.getSearchBeforeOrEqual()[1];
        }
        TaskQuery newRequest = request.createCopy().setSearchAfter(null).setSearchAfterOrEqual(null).setSearchBefore(null).setSearchBeforeOrEqual(null);
        List<TaskSearchView> tasks = this.queryTasks(newRequest, taskId);
        if (tasks.size() > 0) {
            TaskSearchView entity = tasks.get(0);
            entity.setFirst(false);
            if (request.getSearchAfterOrEqual() != null) {
                if (response.size() == request.getPageSize()) {
                    response.remove(response.size() - 1);
                }
                response.add(0, entity);
            } else if (request.getSearchBeforeOrEqual() != null) {
                if (response.size() == request.getPageSize()) {
                    response.remove(0);
                }
                response.add(entity);
            }
        }
    }

    private List<TaskSearchView> queryTasks(TaskQuery query) {
        return this.queryTasks(query, null);
    }

    private List<TaskSearchView> queryTasks(TaskQuery query, String taskId) {
        List<String> tasksIds = null;
        if (query.getTaskVariables() != null && query.getTaskVariables().length > 0 && (tasksIds = this.getTasksContainsVarNameAndValue(query.getTaskVariables())).isEmpty()) {
            return new ArrayList<TaskSearchView>();
        }
        if (taskId != null && !taskId.isEmpty()) {
            if (query.getTaskVariables() != null && query.getTaskVariables().length > 0) {
                if ((tasksIds = tasksIds.stream().filter(id -> !id.equals(taskId)).collect(Collectors.toList())).isEmpty()) {
                    return new ArrayList<TaskSearchView>();
                }
            } else {
                tasksIds = new ArrayList<String>();
                tasksIds.add(taskId);
            }
        }
        Query.Builder esQuery = this.buildQuery(query, tasksIds);
        SearchRequest.Builder sourceBuilder = OpenSearchUtil.createSearchRequest(this.taskTemplate, TaskStoreOpenSearch.getQueryTypeByTaskState(query.getState()));
        sourceBuilder.query(esQuery.build());
        this.applySorting(sourceBuilder, query);
        try {
            SearchResponse response = query.getTenantIds() == null ? this.tenantAwareClient.search(sourceBuilder, TaskSearchView.class) : this.tenantAwareClient.searchByTenantIds(sourceBuilder, TaskSearchView.class, Set.of(query.getTenantIds()));
            List<TaskSearchView> tasks = response.hits().hits().stream().map(m -> {
                ((TaskSearchView)m.source()).setSortValues(Arrays.asList(m.sort().toArray()).toArray(new String[0]));
                return (TaskSearchView)m.source();
            }).collect(Collectors.toList());
            if (tasks.size() > 0) {
                if (query.getSearchBefore() != null || query.getSearchBeforeOrEqual() != null) {
                    if (tasks.size() <= query.getPageSize()) {
                        tasks.get(tasks.size() - 1).setFirst(true);
                    } else {
                        tasks.remove(tasks.size() - 1);
                    }
                    Collections.reverse(tasks);
                } else if (query.getSearchAfter() == null && query.getSearchAfterOrEqual() == null) {
                    tasks.get(0).setFirst(true);
                }
            }
            return tasks;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining tasks: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    private List<String> getTasksContainsVarNameAndValue(TaskByVariables[] taskVariablesFilter) {
        List<String> varNames = Arrays.stream(taskVariablesFilter).map(TaskByVariables::getName).collect(Collectors.toList());
        List<String> varValues = Arrays.stream(taskVariablesFilter).map(TaskByVariables::getValue).collect(Collectors.toList());
        List<String> processIdsCreatedFiltered = this.variableStoreElasticSearch.getProcessInstanceIdsWithMatchingVars(varNames, varValues);
        List<String> tasksIdsCreatedFiltered = this.retrieveTaskIdByProcessInstanceId(processIdsCreatedFiltered, taskVariablesFilter);
        List<String> taskIdsCompletedFiltered = this.getTasksIdsCompletedWithMatchingVars(varNames, varValues);
        return Stream.concat(tasksIdsCreatedFiltered.stream(), taskIdsCompletedFiltered.stream()).distinct().collect(Collectors.toList());
    }

    private static OpenSearchUtil.QueryType getQueryTypeByTaskState(TaskState taskState) {
        return TaskState.CREATED == taskState ? OpenSearchUtil.QueryType.ONLY_RUNTIME : OpenSearchUtil.QueryType.ALL;
    }

    private boolean checkTaskIsFirst(TaskQuery query, String id) {
        TaskQuery newRequest = query.createCopy().setSearchAfter(null).setSearchAfterOrEqual(null).setSearchBefore(null).setSearchBeforeOrEqual(null).setPageSize(1);
        List<TaskSearchView> tasks = this.queryTasks(newRequest, null);
        if (tasks.size() > 0) {
            return tasks.get(0).getId().equals(id);
        }
        return false;
    }

    private Query.Builder buildQuery(TaskQuery query, List<String> taskIds) {
        Query.Builder stateQ = new Query.Builder();
        stateQ.bool(b -> b.mustNot(mn -> mn.term(t -> t.field("state").value(FieldValue.of((String)TaskState.CANCELED.name())))));
        if (query.getState() != null) {
            stateQ.term(t -> t.field("state").value(FieldValue.of((String)query.getState().name())));
        }
        Query.Builder assignedQ = null;
        Query.Builder assigneeQ = null;
        if (query.getAssigned() != null) {
            assignedQ = new Query.Builder();
            if (query.getAssigned().booleanValue()) {
                assignedQ.exists(e -> e.field("assignee"));
            } else {
                assignedQ.bool(b -> b.mustNot(mn -> mn.exists(e -> e.field("assignee"))));
            }
        }
        if (query.getAssignee() != null) {
            assigneeQ = new Query.Builder();
            assigneeQ.term(t -> t.field("assignee").value(FieldValue.of((String)query.getAssignee())));
        }
        Query.Builder assigneesQ = null;
        if (query.getAssignees() != null) {
            assigneesQ = new Query.Builder();
            assigneesQ.terms(t -> t.field("assignee").terms(terms -> terms.value(Arrays.stream(query.getAssignees()).map(m -> FieldValue.of((String)m)).toList())));
        }
        Query.Builder idsQuery = null;
        if (taskIds != null) {
            idsQuery = new Query.Builder();
            idsQuery.ids(i -> i.values(taskIds));
        }
        Query.Builder taskDefinitionQ = null;
        if (query.getTaskDefinitionId() != null) {
            taskDefinitionQ = new Query.Builder();
            taskDefinitionQ.term(t -> t.field("flowNodeBpmnId").value(FieldValue.of((String)query.getTaskDefinitionId())));
        }
        Query.Builder candidateGroupQ = null;
        if (query.getCandidateGroup() != null) {
            candidateGroupQ = new Query.Builder();
            candidateGroupQ.term(t -> t.field("candidateGroups").value(FieldValue.of((String)query.getCandidateGroup())));
        }
        Query.Builder candidateGroupsQ = null;
        if (query.getCandidateGroups() != null) {
            candidateGroupsQ = new Query.Builder();
            candidateGroupsQ.terms(t -> t.field("candidateGroups").terms(terms -> terms.value(Arrays.stream(query.getCandidateGroups()).map(m -> FieldValue.of((String)m)).toList())));
        }
        Query.Builder candidateUserQ = null;
        if (query.getCandidateUser() != null) {
            candidateUserQ = new Query.Builder();
            candidateUserQ.term(t -> t.field("candidateUsers").value(FieldValue.of((String)query.getCandidateUser())));
        }
        Query.Builder candidateUsersQ = null;
        if (query.getCandidateUsers() != null) {
            candidateUsersQ = new Query.Builder();
            candidateUsersQ.terms(t -> t.field("candidateUsers").terms(terms -> terms.value(Arrays.stream(query.getCandidateUsers()).map(m -> FieldValue.of((String)m)).toList())));
        }
        Query.Builder candidateGroupsAndUserByCurrentUserQ = null;
        if (query.getTaskByCandidateUserOrGroups() != null) {
            candidateGroupsAndUserByCurrentUserQ = this.returnUserGroupBoolQuery(List.of(query.getTaskByCandidateUserOrGroups().getUserGroups()), query.getTaskByCandidateUserOrGroups().getUserName());
        }
        Query.Builder processInstanceIdQ = null;
        if (query.getProcessInstanceId() != null) {
            processInstanceIdQ = new Query.Builder();
            processInstanceIdQ.term(t -> t.field("processInstanceId").value(FieldValue.of((String)query.getProcessInstanceId())));
        }
        Query.Builder processDefinitionIdQ = null;
        if (query.getProcessDefinitionId() != null) {
            processDefinitionIdQ = new Query.Builder();
            processDefinitionIdQ.term(t -> t.field("processDefinitionId").value(FieldValue.of((String)query.getProcessDefinitionId())));
        }
        Query.Builder followUpQ = null;
        if (query.getFollowUpDate() != null) {
            followUpQ = new Query.Builder();
            followUpQ.range(r -> r.field("followUpDate").from(JsonData.of((Object)query.getFollowUpDate().getFrom())).to(JsonData.of((Object)query.getFollowUpDate().getTo())));
        }
        Query.Builder dueDateQ = null;
        if (query.getDueDate() != null) {
            dueDateQ = new Query.Builder();
            dueDateQ.range(r -> r.field("dueDate").from(JsonData.of((Object)query.getDueDate().getFrom())).to(JsonData.of((Object)query.getDueDate().getTo())));
        }
        Query.Builder implementationQ = null;
        if (query.getImplementation() != null) {
            implementationQ = new Query.Builder();
            implementationQ.term(t -> t.field("implementation").value(FieldValue.of((String)query.getImplementation().name())));
        }
        Query.Builder priorityQ = this.buildPriorityQuery(query);
        Query.Builder jointQ = OpenSearchUtil.joinQueryBuilderWithAnd(new ObjectBuilder[]{stateQ, assignedQ, assigneeQ, assigneesQ, idsQuery, taskDefinitionQ, candidateGroupQ, candidateGroupsQ, candidateUserQ, candidateUsersQ, candidateGroupsAndUserByCurrentUserQ, processInstanceIdQ, processDefinitionIdQ, followUpQ, dueDateQ, implementationQ, priorityQ});
        if (jointQ == null) {
            jointQ.matchAll(new MatchAllQuery.Builder().build());
        }
        Query.Builder result = new Query.Builder();
        result.constantScore(cs -> cs.filter(jointQ.build()));
        return result;
    }

    private Query.Builder returnUserGroupBoolQuery(List<String> userGroups, String userName) {
        Query.Builder userNameAssigneeQ = new Query.Builder();
        userNameAssigneeQ.term(t -> t.field("assignee").value(FieldValue.of((String)userName)));
        Query.Builder userNameCandidateUserQ = new Query.Builder();
        userNameCandidateUserQ.term(t -> t.field("candidateUsers").value(FieldValue.of((String)userName)));
        Query.Builder userNameCandidateGroupsQ = null;
        for (String group : userGroups) {
            Query.Builder singleUserNameCandidateGroupQ = new Query.Builder();
            singleUserNameCandidateGroupQ.term(t -> t.field("candidateGroups").value(FieldValue.of((String)group)));
            if (userNameCandidateGroupsQ == null) {
                userNameCandidateGroupsQ = singleUserNameCandidateGroupQ;
                continue;
            }
            userNameCandidateGroupsQ = OpenSearchUtil.joinQueryBuilderWithOr(new ObjectBuilder[]{userNameCandidateGroupsQ, singleUserNameCandidateGroupQ});
        }
        Query.Builder shouldNotContainCandidateUserQ = new Query.Builder();
        shouldNotContainCandidateUserQ.bool(b -> b.mustNot(mn -> mn.exists(e -> e.field("candidateUsers"))));
        Query.Builder shouldNotContainCandidateGroupQ = new Query.Builder();
        shouldNotContainCandidateGroupQ.bool(b -> b.mustNot(mn -> mn.exists(e -> e.field("candidateGroups"))));
        Query.Builder shouldNotContainCandidateUserAndGroupQ = OpenSearchUtil.joinQueryBuilderWithAnd(new ObjectBuilder[]{shouldNotContainCandidateUserQ, shouldNotContainCandidateGroupQ});
        return OpenSearchUtil.joinQueryBuilderWithOr(new ObjectBuilder[]{userNameAssigneeQ, userNameCandidateUserQ, userNameCandidateGroupsQ, shouldNotContainCandidateUserAndGroupQ});
    }

    private void applySorting(SearchRequest.Builder searchRequestBuilder, TaskQuery query) {
        SortOptions sort2;
        boolean isSortOnRequest = query.getSort() != null;
        boolean directSorting = query.getSearchAfter() != null || query.getSearchAfterOrEqual() != null || query.getSearchBefore() == null && query.getSearchBeforeOrEqual() == null;
        String[] querySearchAfter = null;
        if (directSorting) {
            sort2 = (SortOptions)new SortOptions.Builder().field(f -> f.field("key").order(SortOrder.Asc)).build();
            if (query.getSearchAfter() != null) {
                querySearchAfter = query.getSearchAfter();
            } else if (query.getSearchAfterOrEqual() != null) {
                querySearchAfter = query.getSearchAfterOrEqual();
            }
        } else {
            sort2 = (SortOptions)new SortOptions.Builder().field(f -> f.field("key").order(SortOrder.Desc)).build();
            if (query.getSearchBefore() != null) {
                querySearchAfter = query.getSearchBefore();
            } else if (query.getSearchBeforeOrEqual() != null) {
                querySearchAfter = query.getSearchBeforeOrEqual();
            }
        }
        if (isSortOnRequest) {
            for (int i = 0; i < query.getSort().length; ++i) {
                SortOrder sortOrder;
                TaskOrderBy orderBy = query.getSort()[i];
                String field = orderBy.getField().toString();
                SortOrder sortOrder2 = directSorting ? (orderBy.getOrder().equals((Object)Sort.DESC) ? SortOrder.Desc : SortOrder.Asc) : (sortOrder = orderBy.getOrder().equals((Object)Sort.DESC) ? SortOrder.Asc : SortOrder.Desc);
                if (!orderBy.getField().equals((Object)TaskSortFields.priority)) {
                    searchRequestBuilder.sort(this.applyDateSortScript(orderBy.getOrder(), field, sortOrder));
                    continue;
                }
                searchRequestBuilder.sort(this.mapNullInSort("priority", "50", sortOrder, ScriptSortType.Number));
            }
        } else {
            String sort1Field = (String)CollectionUtil.getOrDefaultFromMap(SORT_FIELD_PER_STATE, (Object)query.getState(), (Object)"creationTime");
            SortOptions sort1 = directSorting ? (SortOptions)new SortOptions.Builder().field(FieldSort.of(f -> f.field(sort1Field).order(SortOrder.Desc).missing(FieldValue.of((String)"_last")))).build() : (SortOptions)new SortOptions.Builder().field(FieldSort.of(f -> f.field(sort1Field).order(SortOrder.Asc).missing(FieldValue.of((String)"_first")))).build();
            searchRequestBuilder.sort(sort1, new SortOptions[0]);
        }
        searchRequestBuilder.sort(sort2, new SortOptions[0]);
        if (query.getSearchBefore() != null || query.getSearchBeforeOrEqual() != null) {
            searchRequestBuilder.size(Integer.valueOf(query.getPageSize() + 1));
        } else {
            searchRequestBuilder.size(Integer.valueOf(query.getPageSize()));
        }
        if (querySearchAfter != null) {
            searchRequestBuilder.searchAfter(Arrays.stream(querySearchAfter).toList());
        }
    }

    private Function<SortOptions.Builder, ObjectBuilder<SortOptions>> applyDateSortScript(Sort sorting, String field, SortOrder sortOrder) {
        String nullDate = sorting.equals((Object)Sort.ASC) ? "2099-12-31" : "1900-01-01";
        Script.Builder scriptBuilder = new Script.Builder();
        scriptBuilder.inline(in -> in.source("def sf = new SimpleDateFormat(\"yyyy-MM-dd\"); def nullDate=sf.parse('" + nullDate + "');if(doc['" + field + "'].size() == 0){nullDate.getTime().toString()}else{doc['" + field + "'].value.getMillis().toString()}"));
        return s -> s.script(script -> script.script(scriptBuilder.build()).order(sortOrder).type(ScriptSortType.String));
    }

    private void updateTask(String taskId, Map<String, Object> updateFields) {
        try {
            Hit searchHit = this.getTaskRawResponse(taskId);
            Map jsonMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class);
            UpdateRequest.Builder updateRequest = new UpdateRequest.Builder();
            updateRequest.index(this.taskTemplate.getFullQualifiedName()).id(taskId).doc((Object)jsonMap).refresh(Refresh.WaitFor).ifSeqNo(searchHit.seqNo()).ifPrimaryTerm(searchHit.primaryTerm());
            OpenSearchUtil.executeUpdate(this.osClient, updateRequest.build());
        }
        catch (Exception e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private Hit getTaskRawResponse(String id) throws IOException {
        SearchRequest.Builder request = OpenSearchUtil.createSearchRequest(this.taskTemplate).query(q -> q.ids(ids -> ids.values(id, new String[0])));
        SearchResponse response = this.osClient.search(request.build(), TaskEntity.class);
        if (response.hits().total().value() == 1L) {
            return (Hit)response.hits().hits().get(0);
        }
        if (response.hits().total().value() > 1L) {
            throw new NotFoundException(String.format("Unique task with id %s was not found", id));
        }
        throw new NotFoundException(String.format("Task with id %s was not found", id));
    }

    private List<Hit<TaskEntity>> getTasksRawResponse(List<String> ids) throws IOException {
        SearchRequest.Builder request = OpenSearchUtil.createSearchRequest(this.taskTemplate).source(s -> s.filter(f -> f.includes(ids)));
        SearchResponse response = this.tenantAwareClient.search(request, TaskEntity.class);
        if (response.hits().total().value() > 0L) {
            return response.hits().hits();
        }
        throw new NotFoundException(String.format("No tasks were found for ids %s", ids.toString()));
    }

    private List<String> getTasksIdsCompletedWithMatchingVars(List<String> varNames, List<String> varValues) {
        ArrayList listOfTaskIdsSets = new ArrayList();
        for (int i = 0; i < varNames.size(); ++i) {
            Query.Builder nameQ = new Query.Builder();
            int finalI = i;
            nameQ.terms(terms -> terms.field("name").terms(t -> t.value(Collections.singletonList(FieldValue.of((String)((String)varNames.get(finalI)))))));
            Query.Builder valueQ = new Query.Builder();
            valueQ.terms(terms -> terms.field("value").terms(t -> t.value(Collections.singletonList(FieldValue.of((String)((String)varValues.get(finalI)))))));
            Query boolQuery = OpenSearchUtil.joinWithAnd(new ObjectBuilder[]{nameQ, valueQ});
            SearchRequest.Builder searchRequestBuilder = new SearchRequest.Builder();
            searchRequestBuilder.index(this.taskVariableTemplate.getAlias(), new String[0]).query(q -> q.constantScore(cs -> cs.filter(boolQuery))).scroll(timeBuilder -> timeBuilder.time("60000ms"));
            HashSet taskIdsForCurrentVar = new HashSet();
            try {
                SearchResponse response = this.osClient.search(searchRequestBuilder.build(), TaskVariableEntity.class);
                List scrollTaskIds = response.hits().hits().stream().map(hit -> ((TaskVariableEntity)hit.source()).getTaskId()).collect(Collectors.toList());
                taskIdsForCurrentVar.addAll(scrollTaskIds);
                String scrollId = response.scrollId();
                while (!scrollTaskIds.isEmpty()) {
                    ScrollRequest scrollRequest = ScrollRequest.of(builder -> builder.scrollId(scrollId).scroll((Time)new Time.Builder().time("60000ms").build()));
                    response = this.osClient.scroll(scrollRequest, TaskVariableEntity.class);
                    scrollTaskIds = response.hits().hits().stream().map(hit -> ((TaskVariableEntity)hit.source()).getTaskId()).collect(Collectors.toList());
                    taskIdsForCurrentVar.addAll(scrollTaskIds);
                }
                OpenSearchUtil.clearScroll(scrollId, this.osClient);
                listOfTaskIdsSets.add(taskIdsForCurrentVar);
                continue;
            }
            catch (IOException e) {
                String message = String.format("Exception occurred while obtaining taskIds: %s", e.getMessage());
                throw new TasklistRuntimeException(message, (Throwable)e);
            }
        }
        return new ArrayList<String>(listOfTaskIdsSets.stream().reduce((set1, set2) -> {
            set1.retainAll((Collection<?>)set2);
            return set1;
        }).orElse(Collections.emptySet()));
    }

    private List<String> retrieveTaskIdByProcessInstanceId(List<String> processIds, TaskByVariables[] taskVariablesFilter) {
        ArrayList<String> taskIdsCreated = new ArrayList<String>();
        Map<String, String> variablesMap = IntStream.range(0, taskVariablesFilter.length).boxed().collect(Collectors.toMap(i -> taskVariablesFilter[i].getName(), i -> taskVariablesFilter[i].getValue()));
        for (String processId : processIds) {
            List<String> taskIds = this.getTaskIdsByProcessInstanceId(processId);
            for (String taskId : taskIds) {
                List<VariableStore.GetVariablesRequest> request;
                TaskEntity taskEntity = this.getTask(taskId);
                if (taskEntity.getState() != TaskState.CREATED || !this.taskVariableSearchUtil.checkIfVariablesExistInTask(request = Collections.singletonList(VariableStore.GetVariablesRequest.createFrom(taskEntity).setVarNames(variablesMap.keySet().stream().toList())), variablesMap).booleanValue()) continue;
                taskIdsCreated.add(taskId);
            }
        }
        return taskIdsCreated;
    }

    private Query.Builder buildPriorityQuery(TaskQuery query) {
        if (query.getPriority() != null) {
            RangeValueFilter priority = query.getPriority();
            if (priority.getEq() != null) {
                return ((Query)new Query.Builder().term(t -> t.field("priority").value(FieldValue.of((long)((Integer)priority.getEq()).intValue()))).build()).toBuilder();
            }
            return ((Query)new Query.Builder().range(r -> {
                r = r.field("priority");
                if (priority.getGt() != null) {
                    r = r.gt(JsonData.of((Object)priority.getGt()));
                }
                if (priority.getGte() != null) {
                    r = r.gte(JsonData.of((Object)priority.getGte()));
                }
                if (priority.getLt() != null) {
                    r = r.lt(JsonData.of((Object)priority.getLt()));
                }
                if (priority.getLte() != null) {
                    r = r.lte(JsonData.of((Object)priority.getLte()));
                }
                return r;
            }).build()).toBuilder();
        }
        return null;
    }

    private Function<SortOptions.Builder, ObjectBuilder<SortOptions>> mapNullInSort(String field, String defaultValue, SortOrder order, ScriptSortType sortType) {
        String nullHandlingScript = String.format("if (doc['%s'].size() == 0) { %s } else { doc['%s'].value }", field, defaultValue, field);
        Script script = (Script)new Script.Builder().inline(i -> i.source(nullHandlingScript)).build();
        return f -> f.script(s -> s.script(script).order(order).type(sortType));
    }
}

