/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.entities.FormEntity;
import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.schema.indices.FormIndex;
import io.camunda.tasklist.schema.indices.ProcessIndex;
import io.camunda.tasklist.schema.templates.TaskTemplate;
import io.camunda.tasklist.store.FormStore;
import io.camunda.tasklist.tenant.TenantAwareElasticsearchClient;
import io.camunda.tasklist.util.ElasticsearchUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class FormStoreElasticSearch
implements FormStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormStoreElasticSearch.class);
    @Autowired
    private FormIndex formIndex;
    @Autowired
    private TaskTemplate taskTemplate;
    @Autowired
    private ProcessIndex processIndex;
    @Autowired
    private TenantAwareElasticsearchClient tenantAwareClient;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;

    @Override
    public FormEntity getForm(String id, String processDefinitionId, Long version) {
        FormEntity formLinked;
        FormEntity formEmbedded;
        FormEntity formEntity = formEmbedded = version == null ? this.getFormEmbedded(id, processDefinitionId) : null;
        if (formEmbedded != null) {
            return formEmbedded;
        }
        if (this.isFormAssociatedToTask(id, processDefinitionId).booleanValue()) {
            FormEntity formLinked2 = this.getLinkedForm(id, version);
            if (formLinked2 != null) {
                return formLinked2;
            }
        } else if (this.isFormAssociatedToProcess(id, processDefinitionId).booleanValue() && (formLinked = this.getLinkedForm(id, version)) != null) {
            return formLinked;
        }
        throw new NotFoundException(String.format("form with id %s was not found", id));
    }

    @Override
    public List<String> getFormIdsByProcessDefinitionId(String processDefinitionId) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.formIndex.getFullQualifiedName()}).source(SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.termQuery((String)"processDefinitionId", (String)processDefinitionId)).fetchField("id"));
        try {
            return ElasticsearchUtil.scrollIdsToList(searchRequest, this.esClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Optional<FormStore.FormIdView> getFormByKey(String formKey) {
        GetRequest getRequest = new GetRequest(this.formIndex.getFullQualifiedName(), formKey);
        try {
            GetResponse response = this.esClient.get(getRequest, RequestOptions.DEFAULT);
            if (response.isExists()) {
                Map sourceAsMap = response.getSourceAsMap();
                return Optional.of(new FormStore.FormIdView((String)sourceAsMap.get("id"), (String)sourceAsMap.get("bpmnId"), ((Number)sourceAsMap.get("version")).longValue()));
            }
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error retrieving the last version for the formKey: %s", formKey), (Throwable)e);
        }
        return Optional.empty();
    }

    private FormEntity getFormEmbedded(String id, String processDefinitionId) {
        try {
            String formId = String.format("%s_%s", processDefinitionId, id);
            SearchHit formSearchHit = ElasticsearchUtil.getRawResponseWithTenantCheck(formId, this.formIndex, ElasticsearchUtil.QueryType.ONLY_RUNTIME, this.tenantAwareClient);
            return ElasticsearchUtil.fromSearchHit(formSearchHit.getSourceAsString(), this.objectMapper, FormEntity.class);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private FormEntity getLinkedForm(String formId, Long formVersion) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.formIndex.getFullQualifiedName()});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"bpmnId", (String)formId)).should((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)formId)).minimumShouldMatch(1));
        if (formVersion != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"version", (Object)formVersion));
        } else {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"isDeleted", (boolean)false));
            searchSourceBuilder.sort("version", SortOrder.DESC);
            searchSourceBuilder.size(1);
        }
        searchSourceBuilder.query((QueryBuilder)boolQuery);
        searchRequest.source(searchSourceBuilder);
        try {
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            if (searchResponse.getHits().getHits().length > 0) {
                Map sourceAsMap = searchResponse.getHits().getHits()[0].getSourceAsMap();
                FormEntity formEntity = new FormEntity();
                formEntity.setBpmnId((String)sourceAsMap.get("bpmnId"));
                formEntity.setVersion(Long.valueOf(((Number)sourceAsMap.get("version")).longValue()));
                formEntity.setEmbedded((Boolean)sourceAsMap.get("embedded"));
                formEntity.setSchema((String)sourceAsMap.get("schema"));
                formEntity.setTenantId((String)sourceAsMap.get("tenantId"));
                formEntity.setIsDeleted((Boolean)sourceAsMap.get("isDeleted"));
                return formEntity;
            }
        }
        catch (IOException e) {
            String formIdNotFoundMessage = String.format("Error retrieving the version for the formId: [%s]", formId);
            throw new TasklistRuntimeException(formIdNotFoundMessage);
        }
        return null;
    }

    private Boolean isFormAssociatedToTask(String formId, String processDefinitionId) {
        try {
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"formId", (Object)formId)).should((QueryBuilder)QueryBuilders.matchQuery((String)"formKey", (Object)formId)).minimumShouldMatch(1)).must((QueryBuilder)QueryBuilders.matchQuery((String)"processDefinitionId", (Object)processDefinitionId));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)boolQuery);
            SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.taskTemplate, ElasticsearchUtil.QueryType.ALL);
            searchRequest.source(searchSourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            return searchResponse.getHits().getTotalHits().value > 0L;
        }
        catch (IOException e) {
            String formIdNotFoundMessage = String.format("Error retrieving the version for the formId: [%s]", formId);
            throw new TasklistRuntimeException(formIdNotFoundMessage);
        }
    }

    private Boolean isFormAssociatedToProcess(String formId, String processDefinitionId) {
        try {
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"formId", (Object)formId)).must((QueryBuilder)QueryBuilders.matchQuery((String)"id", (Object)processDefinitionId));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)boolQuery);
            SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.processIndex, ElasticsearchUtil.QueryType.ALL);
            searchRequest.source(searchSourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            return searchResponse.getHits().getTotalHits().value > 0L;
        }
        catch (IOException e) {
            String formIdNotFoundMessage = String.format("Error retrieving the version for the formId: [%s]", formId);
            throw new TasklistRuntimeException(formIdNotFoundMessage);
        }
    }
}

