/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.schema.migration.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.es.RetryElasticsearchClient;
import io.camunda.tasklist.exceptions.MigrationException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.MigrationRepositoryIndex;
import io.camunda.tasklist.schema.migration.Step;
import io.camunda.tasklist.schema.migration.StepsRepository;
import io.camunda.tasklist.util.ElasticsearchUtil;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ElasticsearchStepsRepository
implements StepsRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchStepsRepository.class);
    private static final String STEP_FILE_EXTENSION = ".json";
    private static final String DEFAULT_SCHEMA_CHANGE_FOLDER = "/schema/es/change";
    @Autowired
    private RetryElasticsearchClient retryElasticsearchClient;
    @Qualifier(value="tasklistObjectMapper")
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    private MigrationRepositoryIndex migrationRepositoryIndex;

    @Override
    public void updateSteps() throws IOException, MigrationException {
        List<Step> stepsFromFiles = this.readStepsFromClasspath();
        List<Step> stepsFromRepository = this.findAll();
        for (Step step : stepsFromFiles) {
            if (stepsFromRepository.contains(step)) continue;
            step.setCreatedDate(OffsetDateTime.now());
            LOGGER.info("Add new step {} to repository.", (Object)step);
            this.save(step);
        }
        this.retryElasticsearchClient.refresh(this.migrationRepositoryIndex.getFullQualifiedName());
    }

    @Override
    public void save(Step step) throws MigrationException, IOException {
        boolean createdOrUpdated = this.retryElasticsearchClient.createOrUpdateDocument(this.migrationRepositoryIndex.getFullQualifiedName(), this.idFromStep(step), this.objectMapper.writeValueAsString((Object)step));
        if (!createdOrUpdated) {
            throw new MigrationException(String.format("Error in save step %s:  document wasn't created/updated.", step));
        }
        LOGGER.info("Step {}  saved.", (Object)step);
    }

    @Override
    public List<Step> findAll() {
        LOGGER.debug("Find all steps from Elasticsearch at {}:{} ", (Object)this.tasklistProperties.getElasticsearch().getHost(), (Object)this.tasklistProperties.getElasticsearch().getPort());
        return this.findBy(Optional.empty());
    }

    @Override
    public List<Step> findNotAppliedFor(String indexName) {
        LOGGER.debug("Find 'not applied steps' for index {} from Elasticsearch at {}:{} ", new Object[]{indexName, this.tasklistProperties.getElasticsearch().getHost(), this.tasklistProperties.getElasticsearch().getPort()});
        return this.findBy(Optional.ofNullable(ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"indexName.keyword", (String)indexName), QueryBuilders.termQuery((String)"applied", (boolean)false)})));
    }

    private List<Step> readStepsFromClasspath() throws IOException {
        ArrayList<Step> steps = new ArrayList<Step>();
        List<Resource> resources = this.getResourcesFor("/schema/es/change/*.json");
        for (Resource resource : resources) {
            LOGGER.info("Read step {} ", (Object)resource.getFilename());
            steps.add(this.readStepFromFile(resource.getInputStream()));
        }
        steps.sort(Step.SEMANTICVERSION_ORDER_COMPARATOR);
        return steps;
    }

    private List<Resource> getResourcesFor(String pattern) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            return Arrays.asList(resolver.getResources(pattern));
        }
        catch (IOException e) {
            LOGGER.info("No resources found for {} ", (Object)pattern);
            return List.of();
        }
    }

    private Step readStepFromFile(InputStream is) throws IOException {
        return (Step)this.objectMapper.readValue(is, Step.class);
    }

    protected String idFromStep(Step step) {
        return step.getVersion() + "-" + step.getOrder();
    }

    protected List<Step> findBy(Optional<QueryBuilder> query) {
        SearchSourceBuilder searchSpec = new SearchSourceBuilder().sort("version.keyword", SortOrder.ASC);
        query.ifPresent(arg_0 -> ((SearchSourceBuilder)searchSpec).query(arg_0));
        SearchRequest request = new SearchRequest(new String[]{this.migrationRepositoryIndex.getFullQualifiedName()}).source(searchSpec).indicesOptions(ElasticsearchUtil.LENIENT_EXPAND_OPEN_IGNORE_THROTTLED);
        return this.retryElasticsearchClient.searchWithScroll(request, Step.class, this.objectMapper);
    }
}

