/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.os;

import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.os.RetryOpenSearchClient;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.IndexMapping;
import io.camunda.tasklist.schema.IndexSchemaValidator;
import io.camunda.tasklist.schema.indices.IndexDescriptor;
import io.camunda.tasklist.schema.manager.SchemaManager;
import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.util.IndexSchemaValidatorUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class IndexSchemaValidatorOpenSearch
extends IndexSchemaValidatorUtil
implements IndexSchemaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexSchemaValidatorOpenSearch.class);
    @Autowired
    Set<IndexDescriptor> indexDescriptors;
    @Autowired
    TasklistProperties tasklistProperties;
    @Autowired
    RetryOpenSearchClient retryOpenSearchClient;
    @Autowired
    SchemaManager schemaManager;

    private Set<String> getAllIndexNamesForIndex(String index) {
        String indexPattern = String.format("%s-%s*", this.getIndexPrefix(), index);
        LOGGER.debug("Getting all indices for {}", (Object)indexPattern);
        Set<String> indexNames = this.retryOpenSearchClient.getIndexNames(indexPattern);
        String patternWithVersion = String.format("%s-%s-\\d.*", this.getIndexPrefix(), index);
        return indexNames.stream().filter(n -> n.matches(patternWithVersion)).collect(Collectors.toSet());
    }

    @Override
    public boolean isHealthCheckEnabled() {
        return this.tasklistProperties.getOpenSearch().isHealthCheckEnabled();
    }

    @Override
    public boolean hasAnyTasklistIndices() {
        Set<String> indices = this.retryOpenSearchClient.getIndexNames(this.tasklistProperties.getOpenSearch().getIndexPrefix() + "*");
        return !indices.isEmpty();
    }

    @Override
    public boolean schemaExists() {
        try {
            Set<String> indices = this.retryOpenSearchClient.getIndexNames(this.tasklistProperties.getOpenSearch().getIndexPrefix() + "*");
            List allIndexNames = CollectionUtil.map(this.indexDescriptors, IndexDescriptor::getFullQualifiedName);
            return indices.containsAll(allIndexNames) && this.validateNumberOfReplicas(allIndexNames);
        }
        catch (Exception e) {
            LOGGER.error("Check for existing schema failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public void validateIndexVersions() {
        if (!this.hasAnyTasklistIndices()) {
            return;
        }
        HashSet errors = new HashSet();
        this.indexDescriptors.forEach(indexDescriptor -> {
            Set<String> oldVersions = this.olderVersionsForIndex((IndexDescriptor)indexDescriptor, this.versionsForIndex((IndexDescriptor)indexDescriptor));
            Set<String> newerVersions = this.newerVersionsForIndex((IndexDescriptor)indexDescriptor, this.versionsForIndex((IndexDescriptor)indexDescriptor));
            if (oldVersions.size() > 1) {
                errors.add(String.format("More than one older version for %s (%s) found: %s", indexDescriptor.getIndexName(), indexDescriptor.getVersion(), oldVersions));
            }
            if (!newerVersions.isEmpty()) {
                errors.add(String.format("Newer version(s) for %s (%s) already exists: %s", indexDescriptor.getIndexName(), indexDescriptor.getVersion(), newerVersions));
            }
        });
        if (!errors.isEmpty()) {
            throw new TasklistRuntimeException("Error(s) in index schema: " + String.join((CharSequence)";", errors));
        }
    }

    @Override
    public Map<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> validateIndexMappings() throws IOException {
        return this.validateIndexMappings(this.indexDescriptors);
    }

    @Override
    public Set<String> olderVersionsForIndex(IndexDescriptor indexDescriptor) {
        Set<String> versions = this.getAllIndexNamesForIndex(indexDescriptor.getIndexName());
        return this.olderVersionsForIndex(indexDescriptor, versions);
    }

    @Override
    public Set<String> newerVersionsForIndex(IndexDescriptor indexDescriptor) {
        Set<String> versions = this.getAllIndexNamesForIndex(indexDescriptor.getIndexName());
        return this.newerVersionsForIndex(indexDescriptor, versions);
    }

    private Set<String> versionsForIndex(IndexDescriptor indexDescriptor) {
        Set<String> allIndexNames = this.getAllIndexNamesForIndex(indexDescriptor.getIndexName());
        return allIndexNames.stream().map(this::getVersionFromIndexName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    public boolean validateNumberOfReplicas(List<String> indexes) {
        for (String index : indexes) {
            IndexSettings response = this.retryOpenSearchClient.getIndexSettingsFor(index, "index.number_of_replicas");
            if (response.numberOfReplicas().equals(String.valueOf(this.tasklistProperties.getOpenSearch().getNumberOfReplicas()))) continue;
            return false;
        }
        return true;
    }
}

