/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.os;

import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.management.ILMPolicyUpdate;
import io.camunda.tasklist.os.RetryOpenSearchClient;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.manager.OpenSearchSchemaManager;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ILMPolicyUpdateOpenSearch
implements ILMPolicyUpdate {
    private static final String TASKLIST_DELETE_ARCHIVED_INDICES = "tasklist_delete_archived_indices";
    private static final Logger LOGGER = LoggerFactory.getLogger(ILMPolicyUpdateOpenSearch.class);
    @Autowired
    private RetryOpenSearchClient retryOpenSearchClient;
    @Autowired
    private OpenSearchSchemaManager schemaManager;
    @Autowired
    private TasklistProperties tasklistProperties;

    @Override
    public void applyIlmPolicyToAllIndices() throws IOException {
        LOGGER.info("Applying ISM policy to index templates and existing indices");
        this.schemaManager.createIndexLifeCyclesIfNotExist();
        this.applyIlmPolicyToIndexTemplate(true);
        this.applyIlmPolicyToExistingIndices();
    }

    @Override
    public void removeIlmPolicyFromAllIndices() throws IOException {
        LOGGER.info("Removing ISM policy from index templates and existing indices");
        this.applyIlmPolicyToIndexTemplate(false);
        this.removeIlmPolicyFromExistingIndices();
    }

    private void applyIlmPolicyToIndexTemplate(boolean applyPolicy) throws IOException {
        String taskListIndexWildCard = this.tasklistProperties.getOpenSearch().getIndexPrefix() + "-*";
        JsonArray templates = this.retryOpenSearchClient.getIndexTemplateSettings(taskListIndexWildCard);
        if (templates != null) {
            for (JsonObject templateData : templates.getValuesAs(JsonObject.class)) {
                String requiredPolicyId;
                String templateName = templateData.getString("name");
                JsonObject template = templateData.getJsonObject("index_template");
                JsonObject innerTemplate = template.getJsonObject("template");
                JsonObject existingSettings = innerTemplate != null && innerTemplate.containsKey((Object)"settings") ? innerTemplate.getJsonObject("settings") : Json.createObjectBuilder().build();
                JsonObjectBuilder settingsBuilder = Json.createObjectBuilder();
                for (String key : existingSettings.keySet()) {
                    settingsBuilder.add(key, (JsonValue)existingSettings.get((Object)key));
                }
                if (applyPolicy) {
                    settingsBuilder.add("plugins.index_state_management.policy_id", TASKLIST_DELETE_ARCHIVED_INDICES);
                } else {
                    settingsBuilder.add("plugins.index_state_management.policy_id", JsonObject.NULL);
                }
                String string = requiredPolicyId = applyPolicy ? TASKLIST_DELETE_ARCHIVED_INDICES : null;
                if (ILMPolicyUpdateOpenSearch.isPolicyAlreadyAppliedForTemplate(existingSettings, requiredPolicyId)) {
                    LOGGER.info("ISM policy already {} index template {}", (Object)(applyPolicy ? "applied to" : "removed from"), (Object)templateName);
                    continue;
                }
                JsonObject newSettings = settingsBuilder.build();
                JsonObjectBuilder updatedInnerTemplateBuilder = Json.createObjectBuilder().add("settings", (JsonValue)newSettings);
                for (String key : innerTemplate.keySet()) {
                    if ("settings".equals(key)) continue;
                    updatedInnerTemplateBuilder.add(key, (JsonValue)innerTemplate.get((Object)key));
                }
                JsonObject updatedInnerTemplate = updatedInnerTemplateBuilder.build();
                JsonObjectBuilder updatedTemplateBuilder = Json.createObjectBuilder().add("index_patterns", (JsonValue)template.getJsonArray("index_patterns")).add("template", (JsonValue)updatedInnerTemplate);
                for (String key : template.keySet()) {
                    if ("index_patterns".equals(key) || "template".equals(key)) continue;
                    updatedTemplateBuilder.add(key, (JsonValue)template.get((Object)key));
                    LOGGER.info("ISM Policy updated for index template {}", (Object)templateName);
                }
                String updatedTemplate = updatedTemplateBuilder.build().toString();
                this.retryOpenSearchClient.putIndexTemplateSettings(templateName, updatedTemplate);
            }
        }
    }

    private void applyIlmPolicyToExistingIndices() throws IOException {
        String taskListIndexWildCard = this.tasklistProperties.getOpenSearch().getIndexPrefix() + "-*";
        String archiveTemplatePatterndNameRegex = "^" + this.tasklistProperties.getOpenSearch().getIndexPrefix() + "-.*-\\d+\\.\\d+\\.\\d+_\\d{4}-\\d{2}-\\d{2}$";
        Pattern indexNamePattern = Pattern.compile(archiveTemplatePatterndNameRegex);
        Set<String> response = this.retryOpenSearchClient.getIndexNames(taskListIndexWildCard);
        for (String indexName : response) {
            if (!indexNamePattern.matcher(indexName).matches()) continue;
            try {
                if (ILMPolicyUpdateOpenSearch.isPolicyAlreadyAppliedForIndex(indexName, this.retryOpenSearchClient, false)) {
                    LOGGER.info("ISM policy already applied for index {}", (Object)indexName);
                    continue;
                }
                this.retryOpenSearchClient.addISMPolicyToIndex(indexName, TASKLIST_DELETE_ARCHIVED_INDICES);
                LOGGER.info("ISM policy updated to index {}", (Object)indexName);
            }
            catch (IOException e) {
                LOGGER.error("Failed to apply ISM policy for index {}: {}", (Object)indexName, (Object)e.getMessage());
            }
        }
    }

    private void removeIlmPolicyFromExistingIndices() throws IOException {
        String taskListIndexWildCard = this.tasklistProperties.getOpenSearch().getIndexPrefix() + "-*";
        String archiveTemplatePatterndNameRegex = "^" + this.tasklistProperties.getOpenSearch().getIndexPrefix() + "-.*-\\d+\\.\\d+\\.\\d+_\\d{4}-\\d{2}-\\d{2}$";
        Pattern indexNamePattern = Pattern.compile(archiveTemplatePatterndNameRegex);
        Set<String> response = this.retryOpenSearchClient.getIndexNames(taskListIndexWildCard);
        for (String indexName : response) {
            if (!indexNamePattern.matcher(indexName).matches()) continue;
            if (ILMPolicyUpdateOpenSearch.isPolicyAlreadyAppliedForIndex(indexName, this.retryOpenSearchClient, true)) {
                LOGGER.info("ISM policy already removed for the index {}", (Object)indexName);
                continue;
            }
            this.retryOpenSearchClient.removeISMPolicyFromIndex(indexName);
            LOGGER.info("ISM policy removed from index {}", (Object)indexName);
        }
    }

    private static boolean isPolicyAlreadyAppliedForTemplate(JsonObject existingSettings, String requiredPolicyId) {
        JsonObject ismSettings = Optional.ofNullable(existingSettings.getJsonObject("index")).map(index -> index.getJsonObject("plugins")).map(plugins -> plugins.getJsonObject("index_state_management")).orElse(null);
        if (ismSettings == null || !ismSettings.containsKey((Object)"policy_id")) {
            return false;
        }
        String currentPolicyId = ismSettings.getString("policy_id", null);
        return Objects.equals(requiredPolicyId, currentPolicyId);
    }

    private static boolean isPolicyAlreadyAppliedForIndex(String indexName, RetryOpenSearchClient retryOpenSearchClient, boolean isRemove) throws IOException {
        JsonObject explainResponse = retryOpenSearchClient.getExplainIndexResponse(indexName);
        if (isRemove) {
            return !explainResponse.containsKey((Object)"policy_id");
        }
        if (explainResponse == null || !explainResponse.containsKey((Object)"policy_id")) {
            return false;
        }
        String currentPolicyId = explainResponse.getString("policy_id", null);
        return Objects.equals(TASKLIST_DELETE_ARCHIVED_INDICES, currentPolicyId);
    }
}

