/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.management;

import io.camunda.tasklist.schema.IndexSchemaValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component(value="searchEngineCheck")
public class SearchEngineHealthIndicator
implements HealthIndicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchEngineHealthIndicator.class);
    @Autowired
    private IndexSchemaValidator indexSchemaValidator;

    public Health getHealth(boolean includeDetails) {
        return this.health();
    }

    public Health health() {
        LOGGER.debug("Search engine check is called");
        if (!this.indexSchemaValidator.isHealthCheckEnabled() || this.indexSchemaValidator.schemaExists()) {
            return Health.up().build();
        }
        return Health.down().build();
    }
}

