/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.store.elasticsearch.dao.response.TaskResponse;
import io.camunda.tasklist.util.Either;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.tasks.GetTaskResponse;
import org.elasticsearch.tasks.RawTaskStatus;
import org.elasticsearch.tasks.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ElasticsearchInternalTask {
    public static final String ID = "id";
    public static final String ERROR = "error";
    public static final String REASON = "reason";
    public static final String RESPONSE = "response";
    public static final String FAILURES = "failures";
    public static final String CAUSE = "cause";
    public static final String SYSTEM_TASKS_INDEX = ".tasks";
    public static final String TOTAL = "total";
    public static final String CREATED = "created";
    public static final String UPDATED = "updated";
    public static final String DELETED = "deleted";
    public static final String TASK_ACTION = "task.action";
    public static final String TASK_ACTION_INDICES_REINDEX = "indices:data/write/reindex";
    public static final String TASK = "task";
    public static final String DESCRIPTION = "description";
    public static final String DESCRIPTION_PREFIX_FROM_INDEX = "reindex from [";
    public static final String DESCRIPTION_PREFIX_TO_INDEX = "to [";
    public static final String NODE = "node";
    public static final int MAX_TASKS_ENTRIES = 2000;
    private static final String TASKS_ENDPOINT = "_tasks";
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchInternalTask.class);
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    public Either<IOException, TaskResponse> getTaskResponse(String taskId) {
        try {
            Request request = new Request("GET", "/_tasks/" + taskId);
            Response response = this.esClient.getLowLevelClient().performRequest(request);
            TaskResponse taskResponse = (TaskResponse)this.objectMapper.readValue(response.getEntity().getContent(), TaskResponse.class);
            return Either.right((Object)taskResponse);
        }
        catch (IOException e) {
            return Either.left((Object)e);
        }
    }

    public void checkForErrorsOrFailures(TaskResponse taskResponse) throws IOException {
        this.checkForErrors(taskResponse);
        this.checkForFailures(taskResponse);
    }

    public List<String> getRunningReindexTasksIdsFor(String fromIndex, String toIndex) throws IOException {
        if (!this.systemTaskIndexExists() || fromIndex == null || toIndex == null) {
            return List.of();
        }
        return this.getReindexTasks().stream().filter(taskInfo -> this.descriptionContainsReindexFromTo(taskInfo.getDescription(), fromIndex, toIndex)).map(this::toTaskId).toList();
    }

    private String toTaskId(TaskInfo taskInfo) {
        return String.format("%s:%s", taskInfo.getTaskId().getNodeId(), taskInfo.getTaskId().getId());
    }

    private boolean descriptionContainsReindexFromTo(String description, String fromIndex, String toIndex) {
        return description != null && description.contains(DESCRIPTION_PREFIX_FROM_INDEX + fromIndex) && description.contains(DESCRIPTION_PREFIX_TO_INDEX + toIndex);
    }

    private List<TaskInfo> getReindexTasks() throws IOException {
        ListTasksResponse response = this.esClient.tasks().list(((ListTasksRequest)new ListTasksRequest().setActions(new String[]{TASK_ACTION_INDICES_REINDEX})).setDetailed(true), RequestOptions.DEFAULT);
        return response.getTasks();
    }

    private boolean systemTaskIndexExists() throws IOException {
        return this.esClient.indices().exists(new GetIndexRequest(new String[]{SYSTEM_TASKS_INDEX}), RequestOptions.DEFAULT);
    }

    private String toTaskId(Map<String, Object> taskState) {
        return String.format("%s:%s", taskState.get(NODE), taskState.get(ID));
    }

    private boolean descriptionContainsReindexFromTo(Map<String, Object> taskState, String fromIndex, String toIndex) {
        String desc = (String)taskState.get(DESCRIPTION);
        return desc != null && desc.contains(DESCRIPTION_PREFIX_FROM_INDEX + fromIndex) && desc.contains(DESCRIPTION_PREFIX_TO_INDEX + toIndex);
    }

    private void checkForErrors(TaskResponse taskResponse) {
        if (taskResponse != null && taskResponse.getError() != null) {
            TaskResponse.Error error = taskResponse.getError();
            LOGGER.error("Task status contains error: " + String.valueOf(error));
            throw new TasklistRuntimeException(error.getReason());
        }
    }

    private void checkForFailures(TaskResponse taskStatus) {
        TaskResponse.TaskResponseDetails taskResponse;
        List<Object> failures;
        if (taskStatus != null && taskStatus.getResponseDetails() != null && !(failures = (taskResponse = taskStatus.getResponseDetails()).getFailures()).isEmpty()) {
            Map failure = (Map)failures.get(0);
            Map cause = (Map)failure.get(CAUSE);
            throw new TasklistRuntimeException((String)cause.get(REASON));
        }
    }

    public boolean needsToPollAgain(Optional<TaskResponse> maybeTaskResponse) {
        return maybeTaskResponse.filter(tr -> !tr.isCompleted()).isPresent();
    }

    private Map<String, Object> getTaskStatusMap(GetTaskResponse taskResponse) {
        return ((RawTaskStatus)taskResponse.getTaskInfo().getStatus()).toMap();
    }

    public int getTotal(GetTaskResponse taskResponse) {
        return (Integer)this.getTaskStatusMap(taskResponse).get(TOTAL);
    }
}

