/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.os;

import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.camunda.search.connect.plugin.PluginRepository;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.OpenSearchProperties;
import io.camunda.tasklist.property.SslProperties;
import io.camunda.tasklist.property.TasklistOpenSearchProperties;
import io.camunda.tasklist.property.TasklistProperties;
import io.github.acm19.aws.interceptor.http.AwsRequestSigningApacheInterceptor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.util.Timeout;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.opensearch.client.RestClient;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.cluster.HealthRequest;
import org.opensearch.client.opensearch.cluster.HealthResponse;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.aws.AwsSdk2Transport;
import org.opensearch.client.transport.aws.AwsSdk2TransportOptions;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5Transport;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5TransportBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;

@Configuration
@Conditional(value={OpenSearchCondition.class})
public class OpenSearchConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchConnector.class);
    private static final String AWS_OPENSEARCH_SERVICE_NAME = "es";
    private PluginRepository osClientRepository = new PluginRepository();
    private PluginRepository zeebeOsClientRepository = new PluginRepository();
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper tasklistObjectMapper;

    public void setOsClientRepository(PluginRepository osClientRepository) {
        this.osClientRepository = osClientRepository;
    }

    public void setZeebeOsClientRepository(PluginRepository zeebeOsClientRepository) {
        this.zeebeOsClientRepository = zeebeOsClientRepository;
    }

    public void setTasklistProperties(TasklistProperties tasklistProperties) {
        this.tasklistProperties = tasklistProperties;
    }

    public void setTasklistObjectMapper(ObjectMapper tasklistObjectMapper) {
        this.tasklistObjectMapper = tasklistObjectMapper;
    }

    @Bean
    public OpenSearchClient tasklistOsClient() {
        this.osClientRepository.load(this.tasklistProperties.getOpenSearch().getInterceptorPlugins());
        OpenSearchClient openSearchClient = this.createOsClient(this.tasklistProperties.getOpenSearch(), this.osClientRepository);
        try {
            HealthResponse response = openSearchClient.cluster().health();
            LOGGER.info("OpenSearch cluster health: {}", (Object)response.status());
        }
        catch (IOException e) {
            LOGGER.error("Error in getting health status from localhost:" + this.tasklistProperties.getOpenSearch().getPort(), (Throwable)e);
        }
        return openSearchClient;
    }

    @Bean
    public OpenSearchClient tasklistZeebeOsClient() {
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        this.zeebeOsClientRepository.load(this.tasklistProperties.getZeebeOpenSearch().getInterceptorPlugins());
        return this.createOsClient(this.tasklistProperties.getZeebeOpenSearch(), this.zeebeOsClientRepository);
    }

    @Bean
    public RestClient tasklistOsRestClient() {
        this.osClientRepository.load(this.tasklistProperties.getOpenSearch().getInterceptorPlugins());
        org.apache.http.HttpHost httpHost = this.getHttpHost(this.tasklistProperties.getOpenSearch());
        return RestClient.builder((org.apache.http.HttpHost[])new org.apache.http.HttpHost[]{httpHost}).setHttpClientConfigCallback(b -> this.configureApacheHttpClient(b, this.tasklistProperties.getOpenSearch(), new org.apache.http.HttpRequestInterceptor[]{this.osClientRepository.asRequestInterceptor()})).build();
    }

    @Bean
    public OpenSearchAsyncClient tasklistOsAsyncClient() {
        this.osClientRepository.load(this.tasklistProperties.getOpenSearch().getInterceptorPlugins());
        OpenSearchAsyncClient openSearchClient = this.createAsyncOsClient(this.tasklistProperties.getOpenSearch(), this.osClientRepository);
        try {
            CompletableFuture healthResponse = openSearchClient.cluster().health();
            healthResponse.whenComplete((response, e) -> {
                if (e != null) {
                    LOGGER.error("Error in getting health status from localhost:" + this.tasklistProperties.getOpenSearch().getPort(), e);
                } else {
                    LOGGER.info("OpenSearch cluster health: {}", (Object)response.status());
                }
            });
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return openSearchClient;
    }

    private OpenSearchAsyncClient createAsyncOsClient(OpenSearchProperties osConfig, PluginRepository pluginRepository) {
        LOGGER.debug("Creating Async OpenSearch connection...");
        LOGGER.debug("Creating OpenSearch connection...");
        if (this.hasAwsCredentials()) {
            return this.getAwsAsyncClient(osConfig);
        }
        HttpHost host = this.getHttpHostForClient5(osConfig);
        ApacheHttpClient5TransportBuilder builder = ApacheHttpClient5TransportBuilder.builder((HttpHost[])new HttpHost[]{host});
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            this.configureApacheHttpClient5(httpClientBuilder, osConfig, new HttpRequestInterceptor[]{pluginRepository.asRequestInterceptor()});
            return httpClientBuilder;
        });
        builder.setRequestConfigCallback(requestConfigBuilder -> {
            this.setTimeouts(requestConfigBuilder, osConfig);
            return requestConfigBuilder;
        });
        JacksonJsonpMapper jsonpMapper = new JacksonJsonpMapper();
        jsonpMapper.objectMapper().registerModule((Module)new JavaTimeModule());
        builder.setMapper((JsonpMapper)jsonpMapper);
        ApacheHttpClient5Transport transport = builder.build();
        OpenSearchAsyncClient openSearchAsyncClient = new OpenSearchAsyncClient((OpenSearchTransport)transport);
        try {
            CompletableFuture healthResponse = openSearchAsyncClient.cluster().health();
            healthResponse.whenComplete((response, e) -> {
                if (e != null) {
                    LOGGER.error("Error in getting health status from localhost:" + this.tasklistProperties.getOpenSearch().getPort(), e);
                } else {
                    LOGGER.info("OpenSearch cluster health: {}", (Object)response.status());
                }
            });
        }
        catch (IOException e2) {
            throw new TasklistRuntimeException(e2);
        }
        if (!this.checkHealth(openSearchAsyncClient)) {
            LOGGER.warn("OpenSearch cluster is not accessible");
        } else {
            LOGGER.debug("OpenSearch connection was successfully created.");
        }
        return openSearchAsyncClient;
    }

    protected OpenSearchClient createOsClient(OpenSearchProperties osConfig, PluginRepository pluginRepository) {
        LOGGER.debug("Creating OpenSearch connection...");
        if (this.hasAwsCredentials()) {
            return this.getAwsClient(osConfig);
        }
        HttpHost host = this.getHttpHostForClient5(osConfig);
        ApacheHttpClient5TransportBuilder builder = ApacheHttpClient5TransportBuilder.builder((HttpHost[])new HttpHost[]{host});
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            this.configureApacheHttpClient5(httpClientBuilder, osConfig, new HttpRequestInterceptor[]{pluginRepository.asRequestInterceptor()});
            return httpClientBuilder;
        });
        builder.setRequestConfigCallback(requestConfigBuilder -> {
            this.setTimeouts(requestConfigBuilder, osConfig);
            return requestConfigBuilder;
        });
        JacksonJsonpMapper jsonpMapper = new JacksonJsonpMapper(this.tasklistObjectMapper);
        builder.setMapper((JsonpMapper)jsonpMapper);
        ApacheHttpClient5Transport transport = builder.build();
        OpenSearchClient openSearchClient = new OpenSearchClient((OpenSearchTransport)transport);
        try {
            HealthResponse response = openSearchClient.cluster().health();
            LOGGER.info("OpenSearch cluster health: {}", (Object)response.status());
        }
        catch (IOException e) {
            LOGGER.error("Error in getting health status from localhost:" + this.tasklistProperties.getOpenSearch().getPort(), (Throwable)e);
        }
        if (!this.checkHealth(openSearchClient)) {
            LOGGER.warn("OpenSearch cluster is not accessible");
        } else {
            LOGGER.debug("OpenSearch connection was successfully created.");
        }
        return openSearchClient;
    }

    private HttpHost getHttpHostForClient5(OpenSearchProperties osConfig) {
        URI uri = this.getOsUri(osConfig);
        return new HttpHost(uri.getScheme(), uri.getHost(), uri.getPort());
    }

    private org.apache.http.HttpHost getHttpHost(OpenSearchProperties osConfig) {
        URI uri = this.getOsUri(osConfig);
        return new org.apache.http.HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
    }

    private URI getOsUri(OpenSearchProperties osConfig) {
        try {
            return new URI(osConfig.getUrl());
        }
        catch (URISyntaxException e) {
            throw new TasklistRuntimeException("Error in url: " + osConfig.getUrl(), e);
        }
    }

    private HttpAsyncClientBuilder setupAuthentication(HttpAsyncClientBuilder builder, OpenSearchProperties osConfig) {
        if (!this.useBasicAuthentication(osConfig)) {
            LOGGER.warn("Username and/or password for are empty. Basic authentication for OpenSearch is not used.");
            return builder;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new org.apache.hc.client5.http.auth.AuthScope(this.getHttpHostForClient5(osConfig)), (org.apache.hc.client5.http.auth.Credentials)new UsernamePasswordCredentials(osConfig.getUsername(), osConfig.getPassword().toCharArray()));
        builder.setDefaultCredentialsProvider((org.apache.hc.client5.http.auth.CredentialsProvider)credentialsProvider);
        return builder;
    }

    private void setupSSLContext(HttpAsyncClientBuilder httpAsyncClientBuilder, SslProperties sslConfig) {
        try {
            ClientTlsStrategyBuilder tlsStrategyBuilder = ClientTlsStrategyBuilder.create();
            tlsStrategyBuilder.setSslContext(this.getSSLContext(sslConfig));
            if (!sslConfig.isVerifyHostname()) {
                tlsStrategyBuilder.setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            TlsStrategy tlsStrategy = tlsStrategyBuilder.build();
            PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).build();
            httpAsyncClientBuilder.setConnectionManager((AsyncClientConnectionManager)connectionManager);
        }
        catch (Exception e) {
            LOGGER.error("Error in setting up SSLContext", (Throwable)e);
        }
    }

    private SSLContext getSSLContext(SslProperties sslConfig) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        TrustSelfSignedStrategy trustStrategy;
        KeyStore truststore = this.loadCustomTrustStore(sslConfig);
        TrustSelfSignedStrategy trustSelfSignedStrategy = trustStrategy = sslConfig.isSelfSigned() ? new TrustSelfSignedStrategy() : null;
        if (truststore.size() > 0) {
            return SSLContexts.custom().loadTrustMaterial(truststore, (TrustStrategy)trustStrategy).build();
        }
        return SSLContext.getDefault();
    }

    private KeyStore loadCustomTrustStore(SslProperties sslConfig) {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null);
            String serverCertificate = sslConfig.getCertificatePath();
            if (serverCertificate != null) {
                this.setCertificateInTrustStore(trustStore, serverCertificate);
            }
            return trustStore;
        }
        catch (Exception e) {
            String message = "Could not create certificate trustStore for the secured OpenSearch Connection!";
            throw new TasklistRuntimeException("Could not create certificate trustStore for the secured OpenSearch Connection!", e);
        }
    }

    private void setCertificateInTrustStore(KeyStore trustStore, String serverCertificate) {
        try {
            Certificate cert = this.loadCertificateFromPath(serverCertificate);
            trustStore.setCertificateEntry("opensearch-host", cert);
        }
        catch (Exception e) {
            String message = "Could not load configured server certificate for the secured OpenSearch Connection!";
            throw new TasklistRuntimeException("Could not load configured server certificate for the secured OpenSearch Connection!", e);
        }
    }

    private Certificate loadCertificateFromPath(String certificatePath) throws IOException, CertificateException {
        Certificate cert;
        block6: {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(certificatePath));){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                if (bis.available() > 0) {
                    cert = cf.generateCertificate(bis);
                    LOGGER.debug("Found certificate: {}", (Object)cert);
                    break block6;
                }
                throw new TasklistRuntimeException("Could not load certificate from file, file is empty. File: " + certificatePath);
            }
        }
        return cert;
    }

    private HttpAsyncClientBuilder configureApacheHttpClient5(HttpAsyncClientBuilder httpAsyncClientBuilder, OpenSearchProperties osConfig, HttpRequestInterceptor ... httpRequestInterceptors) {
        this.setupAuthentication(httpAsyncClientBuilder, osConfig);
        LOGGER.trace("Attempt to load interceptor plugins");
        for (HttpRequestInterceptor interceptor : httpRequestInterceptors) {
            httpAsyncClientBuilder.addRequestInterceptorFirst(interceptor);
        }
        if (osConfig.getSsl() != null) {
            this.setupSSLContext(httpAsyncClientBuilder, osConfig.getSsl());
        }
        return httpAsyncClientBuilder;
    }

    private RequestConfig.Builder setTimeouts(RequestConfig.Builder builder, OpenSearchProperties os) {
        if (os.getSocketTimeout() != null) {
            builder.setResponseTimeout(Timeout.ofMilliseconds((long)os.getSocketTimeout().intValue()));
        }
        if (os.getConnectTimeout() != null) {
            builder.setConnectTimeout(Timeout.ofMilliseconds((long)os.getConnectTimeout().intValue()));
        }
        return builder;
    }

    public boolean checkHealth(OpenSearchClient osClient) {
        TasklistOpenSearchProperties osConfig = this.tasklistProperties.getOpenSearch();
        RetryPolicy<Boolean> retryPolicy = this.getConnectionRetryPolicy(osConfig);
        return (Boolean)Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> {
            HealthResponse clusterHealthResponse = osClient.cluster().health(new HealthRequest.Builder().build());
            return clusterHealthResponse.clusterName().equals(osConfig.getClusterName());
        });
    }

    public boolean checkHealth(OpenSearchAsyncClient osAsyncClient) {
        TasklistOpenSearchProperties osConfig = this.tasklistProperties.getOpenSearch();
        RetryPolicy<Boolean> retryPolicy = this.getConnectionRetryPolicy(osConfig);
        return (Boolean)Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> {
            CompletableFuture clusterHealthResponse = osAsyncClient.cluster().health(new HealthRequest.Builder().build());
            clusterHealthResponse.whenComplete((response, e) -> {
                if (e != null) {
                    LOGGER.error(String.format("Error checking async health %", e.getMessage()));
                } else {
                    LOGGER.debug("Succesfully returned checkHealth");
                }
            });
            return ((HealthResponse)clusterHealthResponse.get()).clusterName().equals(osConfig.getClusterName());
        });
    }

    private RetryPolicy<Boolean> getConnectionRetryPolicy(OpenSearchProperties osConfig) {
        String logMessage = String.format("connect to OpenSearch at %s", osConfig.getUrl());
        return ((RetryPolicy)new RetryPolicy().handle(new Class[]{IOException.class, OpenSearchException.class})).withDelay(Duration.ofSeconds(3L)).withMaxAttempts(50).onRetry(e -> LOGGER.info("Retrying #{} {} due to {}", new Object[]{e.getAttemptCount(), logMessage, e.getLastFailure()})).onAbort(e -> LOGGER.error("Abort {} by {}", (Object)logMessage, (Object)e.getFailure())).onRetriesExceeded(e -> LOGGER.error("Retries {} exceeded for {}", (Object)e.getAttemptCount(), (Object)logMessage));
    }

    public boolean hasAwsCredentials() {
        if (!this.tasklistProperties.getOpenSearch().isAwsEnabled()) {
            return false;
        }
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.create();
        try {
            credentialsProvider.resolveCredentials();
            LOGGER.info("AWS Credentials can be resolved. Use AWS Opensearch");
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("AWS not configured due to: {} ", (Object)e.getMessage());
            return false;
        }
    }

    private OpenSearchAsyncClient getAwsAsyncClient(OpenSearchProperties osConfig) {
        String region = new DefaultAwsRegionProviderChain().getRegion();
        SdkAsyncHttpClient httpClient = NettyNioAsyncHttpClient.builder().build();
        AwsSdk2Transport transport = new AwsSdk2Transport(httpClient, osConfig.getHost(), Region.of((String)region), AwsSdk2TransportOptions.builder().setMapper((JsonpMapper)new JacksonJsonpMapper(this.tasklistObjectMapper)).build());
        return new OpenSearchAsyncClient((OpenSearchTransport)transport);
    }

    private OpenSearchClient getAwsClient(OpenSearchProperties osConfig) {
        String region = new DefaultAwsRegionProviderChain().getRegion();
        SdkAsyncHttpClient httpClient = NettyNioAsyncHttpClient.builder().build();
        AwsSdk2Transport transport = new AwsSdk2Transport(httpClient, osConfig.getHost(), Region.of((String)region), AwsSdk2TransportOptions.builder().setMapper((JsonpMapper)new JacksonJsonpMapper(this.tasklistObjectMapper)).build());
        return new OpenSearchClient((OpenSearchTransport)transport);
    }

    private org.apache.http.impl.nio.client.HttpAsyncClientBuilder configureApacheHttpClient(org.apache.http.impl.nio.client.HttpAsyncClientBuilder builder, OpenSearchProperties osConfig, org.apache.http.HttpRequestInterceptor ... httpRequestInterceptors) {
        for (org.apache.http.HttpRequestInterceptor httpRequestInterceptor : httpRequestInterceptors) {
            builder.addInterceptorLast(httpRequestInterceptor);
        }
        if (this.hasAwsCredentials()) {
            this.configureAwsSigningForApacheHttpClient(builder);
        } else if (this.useBasicAuthentication(osConfig)) {
            this.configureBasicAuthenticationForApacheHttpClient(osConfig, builder);
        }
        return builder;
    }

    private void configureAwsSigningForApacheHttpClient(org.apache.http.impl.nio.client.HttpAsyncClientBuilder builder) {
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.create();
        credentialsProvider.resolveCredentials();
        Aws4Signer signer = Aws4Signer.create();
        AwsRequestSigningApacheInterceptor signInterceptor = new AwsRequestSigningApacheInterceptor(AWS_OPENSEARCH_SERVICE_NAME, (Signer)signer, (AwsCredentialsProvider)credentialsProvider, new DefaultAwsRegionProviderChain().getRegion());
        builder.addInterceptorLast((org.apache.http.HttpRequestInterceptor)signInterceptor);
    }

    private void configureBasicAuthenticationForApacheHttpClient(OpenSearchProperties osConfig, org.apache.http.impl.nio.client.HttpAsyncClientBuilder builder) {
        org.apache.http.impl.client.BasicCredentialsProvider credentialsProvider = new org.apache.http.impl.client.BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(this.getHttpHost(osConfig)), (Credentials)new org.apache.http.auth.UsernamePasswordCredentials(osConfig.getUsername(), osConfig.getPassword()));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    private boolean useBasicAuthentication(OpenSearchProperties osConfig) {
        return StringUtils.hasText((String)osConfig.getUsername()) && StringUtils.hasText((String)osConfig.getPassword());
    }
}

