/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.entities.meta;

import io.camunda.tasklist.entities.TasklistEntity;
import java.util.Objects;

public class ImportPositionEntity
extends TasklistEntity<ImportPositionEntity> {
    private String aliasName;
    private int partitionId;
    private long position;
    private long sequence;
    private String indexName;

    public String getAliasName() {
        return this.aliasName;
    }

    public ImportPositionEntity setAliasName(String aliasName) {
        this.aliasName = aliasName;
        return this;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ImportPositionEntity setPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public long getSequence() {
        return this.sequence;
    }

    public ImportPositionEntity setSequence(long sequence) {
        this.sequence = sequence;
        return this;
    }

    public long getPosition() {
        return this.position;
    }

    public ImportPositionEntity setPosition(long position) {
        this.position = position;
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ImportPositionEntity setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    @Override
    public String getId() {
        return String.format("%s-%s", this.partitionId, this.aliasName);
    }

    public static ImportPositionEntity createFrom(long sequence, ImportPositionEntity importPositionEntity, long newPosition, String indexName) {
        return new ImportPositionEntity().setSequence(sequence).setAliasName(importPositionEntity.getAliasName()).setPartitionId(importPositionEntity.getPartitionId()).setIndexName(indexName).setPosition(newPosition);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImportPositionEntity that = (ImportPositionEntity)o;
        return this.partitionId == that.partitionId && this.position == that.position && this.sequence == that.sequence && Objects.equals(this.aliasName, that.aliasName) && Objects.equals(this.indexName, that.indexName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sequence, this.aliasName, this.partitionId, this.position, this.indexName);
    }

    @Override
    public String toString() {
        return "ImportPositionEntity{aliasName='" + this.aliasName + "', sequence=" + this.sequence + ", partitionId=" + this.partitionId + ", position=" + this.position + ", indexName='" + this.indexName + "'}";
    }
}

