/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.entities;

import io.camunda.tasklist.entities.TenantAwareTasklistEntity;
import java.util.Objects;

public class FormEntity
extends TenantAwareTasklistEntity<FormEntity> {
    private String bpmnId;
    private String processDefinitionId;
    private String schema;
    private Long version;
    private String tenantId;
    private Boolean embedded;
    private Boolean isDeleted;

    public FormEntity() {
    }

    public FormEntity(String processDefinitionId, String bpmnId, String schema, Long version, String tenantId, String formKey, Boolean embedded, Boolean isDeleted) {
        if (embedded.booleanValue()) {
            this.setId(FormEntity.createId(processDefinitionId, bpmnId));
        } else {
            this.setId(formKey);
        }
        this.bpmnId = bpmnId;
        this.processDefinitionId = processDefinitionId;
        this.schema = schema;
        this.version = version;
        this.tenantId = tenantId;
        this.embedded = embedded;
        this.isDeleted = isDeleted;
    }

    public FormEntity(String processDefinitionId, String bpmnId, String schema) {
        this(processDefinitionId, bpmnId, schema, "<default>");
    }

    public FormEntity(String processDefinitionId, String bpmnId, String schema, String tenantId) {
        this.setId(FormEntity.createId(processDefinitionId, bpmnId));
        this.setTenantId(tenantId);
        this.bpmnId = bpmnId;
        this.processDefinitionId = processDefinitionId;
        this.schema = schema;
        this.tenantId = tenantId;
        this.embedded = true;
        this.isDeleted = false;
    }

    public Boolean getEmbedded() {
        return this.embedded;
    }

    public FormEntity setEmbedded(Boolean embedded) {
        this.embedded = embedded;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public FormEntity setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public String getBpmnId() {
        return this.bpmnId;
    }

    public FormEntity setBpmnId(String bpmnId) {
        this.bpmnId = bpmnId;
        return this;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public FormEntity setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public FormEntity setVersion(Long version) {
        this.version = version;
        return this;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public FormEntity setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FormEntity that = (FormEntity)o;
        return Objects.equals(this.bpmnId, that.bpmnId) && Objects.equals(this.processDefinitionId, that.processDefinitionId) && Objects.equals(this.schema, that.schema) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.embedded, that.embedded) && Objects.equals(this.isDeleted, that.isDeleted) && Objects.equals(this.version, that.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bpmnId, this.processDefinitionId, this.schema, this.version);
    }

    @Override
    public String toString() {
        return "FormEntity{formKey='" + this.bpmnId + "', processId='" + this.processDefinitionId + "', schema='" + this.schema + "', version='" + this.version + "', isDeleted=" + this.isDeleted + "}";
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public FormEntity setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        return this;
    }

    public static String createId(String processId, String formKey) {
        return String.format("%s_%s", processId, formKey);
    }
}

