/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.camunda.tasklist.es.ElasticsearchConnector;
import io.camunda.tasklist.property.TasklistProperties;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration
public class JacksonConfig {
    @Autowired
    private TasklistProperties tasklistProperties;

    @Bean(value={"tasklistObjectMapper"})
    public ObjectMapper objectMapper() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(OffsetDateTime.class, (JsonSerializer)new ElasticsearchConnector.CustomOffsetDateTimeSerializer(this.dateTimeFormatter()));
        javaTimeModule.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new ElasticsearchConnector.CustomOffsetDateTimeDeserializer(this.dateTimeFormatter()));
        javaTimeModule.addDeserializer(Instant.class, (JsonDeserializer)new ElasticsearchConnector.CustomInstantDeserializer());
        return Jackson2ObjectMapperBuilder.json().modules(new Module[]{javaTimeModule, new Jdk8Module()}).featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES}).featuresToEnable(new Object[]{JsonParser.Feature.ALLOW_COMMENTS, SerializationFeature.INDENT_OUTPUT}).build();
    }

    private DateTimeFormatter dateTimeFormatter() {
        return DateTimeFormatter.ofPattern(this.tasklistProperties.getElasticsearch().getDateFormat());
    }

    private DateTimeFormatter localDateFormatter() {
        return DateTimeFormatter.ofPattern(this.tasklistProperties.getZeebeElasticsearch().getDateFormat());
    }
}

