/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.auth;

import io.camunda.operate.auth.Authentication;
import io.camunda.operate.auth.SimpleCredential;
import java.lang.invoke.MethodHandles;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthentication
implements Authentication {
    private static final Set<String> CSRF_HEADER_CANDIDATES = Set.of("X-CSRF-TOKEN", "OPERATE-X-CSRF-TOKEN");
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SimpleCredential simpleCredential;
    private SimpleAuthToken token;

    public SimpleAuthentication(SimpleCredential simpleCredential) {
        this.simpleCredential = simpleCredential;
    }

    private SimpleAuthToken retrieveToken() {
        SimpleAuthToken simpleAuthToken;
        block11: {
            CloseableHttpClient client = HttpClients.createSystem();
            try {
                HttpPost request = this.buildRequest(this.simpleCredential);
                SimpleAuthToken simpleAuthToken2 = (SimpleAuthToken)client.execute((ClassicHttpRequest)request, response -> {
                    if (response.getCode() > 299) {
                        throw new RuntimeException("Unable to login, response code " + response.getCode());
                    }
                    String csrfTokenCandidate = null;
                    String csrfTokenHeaderName = null;
                    Header csrfTokenHeader = this.findCsrfTokenHeader(response);
                    if (csrfTokenHeader != null) {
                        csrfTokenCandidate = csrfTokenHeader.getValue();
                        csrfTokenHeaderName = csrfTokenHeader.getName();
                    }
                    Header[] cookieHeaders = response.getHeaders("Set-Cookie");
                    String sessionCookie = null;
                    String csrfCookie = null;
                    String sessionCookieName = "OPERATE-SESSION";
                    for (Header cookieHeader : cookieHeaders) {
                        if (cookieHeader.getValue().startsWith(sessionCookieName)) {
                            sessionCookie = cookieHeader.getValue();
                        }
                        for (String candidate : CSRF_HEADER_CANDIDATES) {
                            if (!cookieHeader.getValue().startsWith(candidate)) continue;
                            csrfCookie = cookieHeader.getValue();
                        }
                    }
                    return new SimpleAuthToken(sessionCookie, csrfCookie, csrfTokenCandidate, csrfTokenHeaderName, LocalDateTime.now().plus(this.simpleCredential.sessionTimeout()));
                });
                if (simpleAuthToken2.sessionCookie() == null) {
                    throw new RuntimeException("Unable to authenticate due to missing Set-Cookie OPERATE-SESSION");
                }
                if (simpleAuthToken2.csrfToken() == null) {
                    LOG.info("No CSRF token found");
                }
                if (simpleAuthToken2.csrfCookie() == null) {
                    LOG.info("No CSRF cookie found");
                }
                simpleAuthToken = simpleAuthToken2;
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to authenticate", e);
                }
            }
            client.close();
        }
        return simpleAuthToken;
    }

    private Header findCsrfTokenHeader(ClassicHttpResponse response) throws ProtocolException {
        if (this.token != null) {
            return response.getHeader(this.token.csrfTokenHeaderName());
        }
        for (String candidate : CSRF_HEADER_CANDIDATES) {
            if (!response.containsHeader(candidate)) continue;
            return response.getHeader(candidate);
        }
        return null;
    }

    private HttpPost buildRequest(SimpleCredential simpleCredential) {
        HttpPost httpPost = new HttpPost(simpleCredential.baseUrl().toString() + "/api/login");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("username", simpleCredential.username()));
        params.add(new BasicNameValuePair("password", simpleCredential.password()));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return httpPost;
    }

    @Override
    public Map<String, String> getTokenHeader() {
        if (this.token == null || this.token.sessionTimeout().isBefore(LocalDateTime.now())) {
            this.token = this.retrieveToken();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.token.csrfToken() != null) {
            headers.put(this.token.csrfTokenHeaderName(), this.token.csrfToken());
        }
        headers.put("Cookie", Stream.of(this.token.sessionCookie(), this.token.csrfCookie()).filter(Objects::nonNull).collect(Collectors.joining(";")));
        return headers;
    }

    @Override
    public void resetToken() {
        this.token = null;
    }

    private record SimpleAuthToken(String sessionCookie, String csrfCookie, String csrfToken, String csrfTokenHeaderName, LocalDateTime sessionTimeout) {
    }
}

