/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate;

import io.camunda.common.http.HttpClient;
import io.camunda.operate.CamundaOperateClientBuilder;
import io.camunda.operate.exception.OperateException;
import io.camunda.operate.model.ChangeStatus;
import io.camunda.operate.model.DecisionDefinition;
import io.camunda.operate.model.DecisionInstance;
import io.camunda.operate.model.DecisionRequirements;
import io.camunda.operate.model.FlowNodeInstance;
import io.camunda.operate.model.FlowNodeStatistics;
import io.camunda.operate.model.Incident;
import io.camunda.operate.model.ListTypeToken;
import io.camunda.operate.model.ProcessDefinition;
import io.camunda.operate.model.ProcessInstance;
import io.camunda.operate.model.SearchResult;
import io.camunda.operate.model.SearchResultTypeToken;
import io.camunda.operate.model.Variable;
import io.camunda.operate.search.SearchQuery;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CamundaOperateClient {
    private HttpClient httpClient;

    public static CamundaOperateClientBuilder builder() {
        return new CamundaOperateClientBuilder();
    }

    public ProcessDefinition getProcessDefinition(Long key) throws OperateException {
        return (ProcessDefinition)this.httpClient.get(ProcessDefinition.class, key);
    }

    public BpmnModelInstance getProcessDefinitionModel(Long key) throws OperateException {
        String xml = this.getProcessDefinitionXml(key);
        try {
            ByteArrayInputStream processInputStream = new ByteArrayInputStream(xml.getBytes());
            return Bpmn.readModelFromStream((InputStream)processInputStream);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    public String getProcessDefinitionXml(Long key) throws OperateException {
        return this.httpClient.getXml(ProcessDefinition.class, key);
    }

    public List<ProcessDefinition> searchProcessDefinitions(SearchQuery query) throws OperateException {
        return this.searchProcessDefinitionResults(query).getItems();
    }

    public SearchResult<ProcessDefinition> searchProcessDefinitionResults(SearchQuery query) throws OperateException {
        return (SearchResult)this.httpClient.post(SearchResult.class, ProcessDefinition.class, SearchResultTypeToken.searchResultProcessDefinition, (Object)query);
    }

    public List<DecisionDefinition> searchDecisionDefinitions(SearchQuery query) throws OperateException {
        return this.searchDecisionDefinitionResults(query).getItems();
    }

    public SearchResult<DecisionDefinition> searchDecisionDefinitionResults(SearchQuery query) throws OperateException {
        return (SearchResult)this.httpClient.post(SearchResult.class, DecisionDefinition.class, SearchResultTypeToken.searchResultDecisionDefinition, (Object)query);
    }

    public List<DecisionInstance> searchDecisionInstances(SearchQuery query) throws OperateException {
        return this.searchDecisionInstanceResults(query).getItems();
    }

    public SearchResult<DecisionInstance> searchDecisionInstanceResults(SearchQuery query) throws OperateException {
        return (SearchResult)this.httpClient.post(SearchResult.class, DecisionInstance.class, SearchResultTypeToken.searchResultDecisionInstance, (Object)query);
    }

    public List<FlowNodeInstance> searchFlowNodeInstances(SearchQuery query) throws OperateException {
        return this.searchFlowNodeInstanceResults(query).getItems();
    }

    public SearchResult<FlowNodeInstance> searchFlowNodeInstanceResults(SearchQuery query) throws OperateException {
        return (SearchResult)this.httpClient.post(SearchResult.class, FlowNodeInstance.class, SearchResultTypeToken.searchResultFlowNodeInstance, (Object)query);
    }

    public List<Variable> searchVariables(SearchQuery query) throws OperateException {
        return this.searchVariableResults(query).getItems();
    }

    public SearchResult<Variable> searchVariableResults(SearchQuery query) throws OperateException {
        return (SearchResult)this.httpClient.post(SearchResult.class, Variable.class, SearchResultTypeToken.searchResultVariable, (Object)query);
    }

    public List<ProcessInstance> searchProcessInstances(SearchQuery query) throws OperateException {
        return this.searchProcessInstanceResults(query).getItems();
    }

    public SearchResult<ProcessInstance> searchProcessInstanceResults(SearchQuery query) throws OperateException {
        return (SearchResult)this.httpClient.post(SearchResult.class, ProcessInstance.class, SearchResultTypeToken.searchResultProcessInstance, (Object)query);
    }

    public List<DecisionRequirements> searchDecisionRequirements(SearchQuery query) throws OperateException {
        return this.searchDecisionRequirementsResults(query).getItems();
    }

    public SearchResult<DecisionRequirements> searchDecisionRequirementsResults(SearchQuery query) throws OperateException {
        return (SearchResult)this.httpClient.post(SearchResult.class, DecisionRequirements.class, SearchResultTypeToken.searchResultDecisionRequirements, (Object)query);
    }

    public List<Incident> searchIncidents(SearchQuery query) throws OperateException {
        return this.searchIncidentResults(query).getItems();
    }

    public SearchResult<Incident> searchIncidentResults(SearchQuery query) throws OperateException {
        return (SearchResult)this.httpClient.post(SearchResult.class, Incident.class, SearchResultTypeToken.searchResultIncident, (Object)query);
    }

    public ProcessInstance getProcessInstance(Long key) throws OperateException {
        return (ProcessInstance)this.httpClient.get(ProcessInstance.class, key);
    }

    public ChangeStatus deleteProcessInstance(Long key) throws OperateException {
        return (ChangeStatus)this.httpClient.delete(ChangeStatus.class, ProcessInstance.class, key);
    }

    public List<FlowNodeStatistics> getFlowNodeStatistics(Long key) throws OperateException {
        return (List)this.httpClient.get(List.class, FlowNodeStatistics.class, ListTypeToken.listFlowNodeStatistics, key);
    }

    public List<String> getSequenceFlows(Long key) throws OperateException {
        return (List)this.httpClient.get(List.class, String.class, ListTypeToken.listSequenceFlows, key);
    }

    public FlowNodeInstance getFlowNodeInstance(Long key) throws OperateException {
        return (FlowNodeInstance)this.httpClient.get(FlowNodeInstance.class, key);
    }

    public Incident getIncident(Long key) throws OperateException {
        return (Incident)this.httpClient.get(Incident.class, key);
    }

    public DecisionDefinition getDecisionDefinition(Long key) throws OperateException {
        return (DecisionDefinition)this.httpClient.get(DecisionDefinition.class, key);
    }

    public DecisionRequirements getDecisionRequirements(Long key) throws OperateException {
        return (DecisionRequirements)this.httpClient.get(DecisionRequirements.class, key);
    }

    public String getDecisionRequirementsXml(Long key) throws OperateException {
        return this.httpClient.getXml(DecisionRequirements.class, key);
    }

    public DecisionInstance getDecisionInstance(String id) throws OperateException {
        return (DecisionInstance)this.httpClient.get(DecisionInstance.class, id);
    }

    public Variable getVariable(Long key) throws OperateException {
        return (Variable)this.httpClient.get(Variable.class, key);
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

