/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.zeebe.operation.process.modify;

import io.camunda.operate.entities.FlowNodeState;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.webapp.reader.FlowNodeInstanceReader;
import io.camunda.operate.webapp.rest.dto.operation.ModifyProcessInstanceRequestDto;
import io.camunda.zeebe.client.api.command.ModifyProcessInstanceCommandStep1;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MoveTokenHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveTokenHandler.class);
    private final FlowNodeInstanceReader flowNodeInstanceReader;

    public MoveTokenHandler(FlowNodeInstanceReader flowNodeInstanceReader) {
        this.flowNodeInstanceReader = flowNodeInstanceReader;
    }

    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep2 moveToken(ModifyProcessInstanceCommandStep1 currentStep, Long processInstanceKey, ModifyProcessInstanceRequestDto.Modification modification) {
        int newTokensCount = this.calculateNewTokensCount(modification, processInstanceKey);
        if (newTokensCount > 0) {
            ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 nextStep = this.activateNewNodes(currentStep, modification, newTokensCount);
            this.moveGlobalVariables(nextStep, modification);
            return this.cancelTokensOnOriginalNodes((ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep2)nextStep, processInstanceKey, modification);
        }
        LOGGER.info("Skipping MOVE_TOKEN processing for flowNode {} and process instance {} since newTokensCount is {}", new Object[]{modification.getFromFlowNodeId(), processInstanceKey, newTokensCount});
        return null;
    }

    private ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 activateNewNodes(ModifyProcessInstanceCommandStep1 currentStep, ModifyProcessInstanceRequestDto.Modification modification, int newTokensCount) {
        String toFlowNodeId = modification.getToFlowNodeId();
        Map<Object, Object> variablesToMoveByFlownodeId = modification.variablesForAddToken() == null ? new HashMap() : modification.variablesForAddToken();
        LinkedList activatedNodeVariables = new LinkedList(variablesToMoveByFlownodeId.getOrDefault(toFlowNodeId, List.of()));
        LOGGER.debug("Move [Add token to flowNodeId: {} with variables: {} ]", (Object)toFlowNodeId, activatedNodeVariables);
        if (newTokensCount < activatedNodeVariables.size()) {
            LOGGER.warn("There are {} variables to move but only {} elements to activate, some variables might be lost", (Object)activatedNodeVariables.size(), (Object)newTokensCount);
        }
        ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 nextStep = null;
        for (int i = 0; i < newTokensCount; ++i) {
            if (nextStep != null) {
                nextStep.and();
            }
            nextStep = modification.getAncestorElementInstanceKey() != null ? currentStep.activateElement(toFlowNodeId, modification.getAncestorElementInstanceKey().longValue()) : currentStep.activateElement(toFlowNodeId);
            if (activatedNodeVariables.peek() == null) continue;
            nextStep = nextStep.withVariables((Map)activatedNodeVariables.poll(), toFlowNodeId);
        }
        return nextStep;
    }

    private ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 moveGlobalVariables(ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 nextStep, ModifyProcessInstanceRequestDto.Modification modification) {
        String toFlowNodeId = modification.getToFlowNodeId();
        Map<Object, Object> variablesToMoveByFlownodeId = modification.variablesForAddToken() == null ? new HashMap() : modification.variablesForAddToken();
        for (String string : variablesToMoveByFlownodeId.keySet()) {
            if (string.equals(toFlowNodeId)) continue;
            List flowNodeVars = (List)variablesToMoveByFlownodeId.get(string);
            for (Map vars : flowNodeVars) {
                nextStep.withVariables(vars, string);
            }
        }
        return nextStep;
    }

    private ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep2 cancelTokensOnOriginalNodes(ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep2 nextStep, Long processInstanceKey, ModifyProcessInstanceRequestDto.Modification modification) {
        List<Long> flowNodeInstanceKeysToCancel;
        String fromFlowNodeId = modification.getFromFlowNodeId();
        String fromFlowNodeInstanceKey = modification.getFromFlowNodeInstanceKey();
        if (StringUtils.hasText((String)fromFlowNodeInstanceKey)) {
            Long flowNodeInstanceKey = Long.parseLong(fromFlowNodeInstanceKey);
            flowNodeInstanceKeysToCancel = List.of(flowNodeInstanceKey);
        } else {
            flowNodeInstanceKeysToCancel = this.flowNodeInstanceReader.getFlowNodeInstanceKeysByIdAndStates(processInstanceKey, fromFlowNodeId, List.of(FlowNodeState.ACTIVE));
        }
        if (flowNodeInstanceKeysToCancel.isEmpty()) {
            throw new OperateRuntimeException(String.format("Abort MOVE_TOKEN (CANCEL step): Can't find not finished flowNodeInstance keys for process instance %s and flowNode id %s", processInstanceKey, fromFlowNodeId));
        }
        LOGGER.debug("Move [Cancel token from flowNodeInstanceKeys: {} ]", flowNodeInstanceKeysToCancel);
        for (Long flowNodeInstanceKey : flowNodeInstanceKeysToCancel) {
            nextStep.and().terminateElement(flowNodeInstanceKey.longValue());
        }
        return nextStep;
    }

    private int calculateNewTokensCount(ModifyProcessInstanceRequestDto.Modification modification, Long processInstanceKey) {
        Integer newTokensCount = modification.getNewTokensCount();
        if (newTokensCount == null) {
            if (modification.getFromFlowNodeInstanceKey() != null) {
                newTokensCount = 1;
            } else if (modification.getFromFlowNodeId() != null) {
                newTokensCount = this.flowNodeInstanceReader.getFlowNodeInstanceKeysByIdAndStates(processInstanceKey, modification.getFromFlowNodeId(), List.of(FlowNodeState.ACTIVE)).size();
            } else {
                LOGGER.warn("MOVE_TOKEN attempted with no flowNodeId, flowNodeInstanceKey, or newTokenCount specified");
                newTokensCount = 0;
            }
        }
        LOGGER.info("MOVE_TOKEN has a newTokensCount value of {}", (Object)newTokensCount);
        return newTokensCount;
    }
}

