/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.zeebe.operation;

import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.webapp.zeebe.operation.AbstractOperationHandler;
import io.camunda.operate.webapp.zeebe.operation.OperationHandler;
import io.camunda.zeebe.client.api.response.SetVariablesResponse;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class UpdateVariableHandler
extends AbstractOperationHandler
implements OperationHandler {
    @Override
    public void handleWithException(OperationEntity operation) throws Exception {
        String updateVariableJson = this.mergeVariableJson(operation.getVariableName(), operation.getVariableValue());
        SetVariablesResponse response = (SetVariablesResponse)this.zeebeClient.newSetVariablesCommand(operation.getScopeKey().longValue()).variables(updateVariableJson).local(true).send().join();
        this.markAsSent(operation, response.getKey());
    }

    @Override
    public Set<OperationType> getTypes() {
        return Set.of(OperationType.UPDATE_VARIABLE, OperationType.ADD_VARIABLE);
    }

    private String mergeVariableJson(String variableName, String variableValue) {
        return String.format("{\"%s\":%s}", variableName, variableValue);
    }
}

