/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.zeebe.operation;

import io.camunda.operate.entities.OperateZeebeEntity;
import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.entities.listview.ProcessInstanceState;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.store.ProcessStore;
import io.camunda.operate.util.OperationsManager;
import io.camunda.operate.webapp.reader.ProcessReader;
import io.camunda.operate.webapp.zeebe.operation.AbstractOperationHandler;
import io.camunda.operate.webapp.zeebe.operation.OperationHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteProcessDefinitionHandler
extends AbstractOperationHandler
implements OperationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteProcessDefinitionHandler.class);
    @Autowired
    private OperationsManager operationsManager;
    @Autowired
    private ProcessReader processReader;
    @Autowired
    private ProcessStore processStore;
    @Autowired
    private ListViewTemplate listViewTemplate;

    @Override
    public void handleWithException(OperationEntity operation) throws Exception {
        Long processDefinitionKey = operation.getProcessDefinitionKey();
        if (processDefinitionKey == null) {
            this.failOperation(operation, "No process definition key is provided.");
            return;
        }
        List runningInstances = this.processStore.getProcessInstancesByProcessAndStates(processDefinitionKey.longValue(), Set.of(ProcessInstanceState.ACTIVE), 1, null);
        if (!runningInstances.isEmpty()) {
            this.failOperation(operation, String.format("Cannot delete process definition with key [%s]. Process instances still running.", processDefinitionKey));
            return;
        }
        LOGGER.info(String.format("Operation [%s]: Sending Zeebe delete command for processDefinitionKey [%s]...", operation.getId(), processDefinitionKey));
        this.zeebeClient.newDeleteResourceCommand(processDefinitionKey.longValue()).send().join();
        this.markAsSent(operation);
        LOGGER.info(String.format("Operation [%s]: Delete command sent to Zeebe for processDefinitionKey [%s]", operation.getId(), processDefinitionKey));
        this.cascadeDeleteProcessInstances(processDefinitionKey, operation);
        long deleted = this.processStore.deleteProcessDefinitionsByKeys(new Long[]{processDefinitionKey});
        LOGGER.info(String.format("Operation [%s]: Total process definitions deleted: %s", operation.getId(), deleted));
        this.completeOperation(operation);
        LOGGER.info(String.format("Operation [%s]: Completed.", operation.getId()));
    }

    @Override
    public Set<OperationType> getTypes() {
        return Set.of(OperationType.DELETE_PROCESS_DEFINITION);
    }

    private void cascadeDeleteProcessInstances(Long processDefinitionKey, OperationEntity operation) throws PersistenceException {
        List processInstances;
        int blockSize = this.operateProperties.getOperationExecutor().getDeletionBatchSize();
        String[] includeFields = new String[]{"key", "processDefinitionKey"};
        Set<ProcessInstanceState> states = Set.of(ProcessInstanceState.CANCELED, ProcessInstanceState.COMPLETED);
        long totalDeleted = 0L;
        while (!(processInstances = this.processStore.getProcessInstancesByProcessAndStates(processDefinitionKey.longValue(), states, blockSize, includeFields)).isEmpty()) {
            ArrayList<List> treeLevels = new ArrayList<List>();
            treeLevels.add(processInstances);
            int currentLevel = 0;
            while (!treeLevels.isEmpty()) {
                List currentProcessInstances = (List)treeLevels.get(currentLevel);
                Set currentKeys = currentProcessInstances.stream().map(OperateZeebeEntity::getKey).collect(Collectors.toSet());
                List children = this.processStore.getProcessInstancesByParentKeys(currentKeys, blockSize, includeFields);
                if (children.isEmpty()) {
                    long deleted = this.processStore.deleteProcessInstancesAndDependants(currentKeys);
                    this.updateInstancesInBatchOperation(operation, currentKeys.size());
                    LOGGER.info(String.format("Operation [%s]: Deleted %s documents on level %s", operation.getId(), deleted, currentLevel));
                    totalDeleted += deleted;
                    this.processStore.refreshIndices(new String[]{this.listViewTemplate.getAlias()});
                    treeLevels.remove(currentLevel);
                    --currentLevel;
                    continue;
                }
                treeLevels.add(children);
                ++currentLevel;
            }
        }
        LOGGER.info(String.format("Operation [%s]: Total process instances and dependants deleted: %s", operation.getId(), totalDeleted));
    }

    private void completeOperation(OperationEntity operation) throws PersistenceException {
        this.operationsManager.completeOperation(operation);
    }

    private void updateInstancesInBatchOperation(OperationEntity operation, long increment) throws PersistenceException {
        this.operationsManager.updateInstancesInBatchOperation(operation.getBatchOperationId(), increment);
    }
}

