/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.OperationState;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.OperationTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.ListViewStore;
import io.camunda.operate.store.OperationStore;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.webapp.reader.IncidentReader;
import io.camunda.operate.webapp.rest.dto.operation.CreateBatchOperationRequestDto;
import io.camunda.operate.webapp.rest.dto.operation.ModifyProcessInstanceRequestDto;
import io.camunda.operate.webapp.rest.exception.NotFoundException;
import io.camunda.operate.webapp.security.UserService;
import io.camunda.operate.webapp.writer.ProcessInstanceSource;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PersistOperationHelper {
    private final OperationStore operationStore;
    private final IncidentReader incidentReader;
    private final ListViewStore listViewStore;
    private final OperationTemplate operationTemplate;
    private final ObjectMapper objectMapper;
    private final ListViewTemplate listViewTemplate;
    private final UserService userService;

    public PersistOperationHelper(OperationStore operationStore, ListViewStore listViewStore, OperationTemplate operationTemplate, ListViewTemplate listViewTemplate, IncidentReader incidentReader, UserService userService, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper) {
        this.operationStore = operationStore;
        this.incidentReader = incidentReader;
        this.listViewStore = listViewStore;
        this.operationTemplate = operationTemplate;
        this.objectMapper = objectMapper;
        this.listViewTemplate = listViewTemplate;
        this.userService = userService;
    }

    public int persistOperations(List<ProcessInstanceSource> processInstanceSources, String batchOperationId, CreateBatchOperationRequestDto batchOperationRequest, String incidentId) throws PersistenceException {
        Map processInstanceIdToIndexName;
        BatchRequest batchRequest = this.operationStore.newBatchRequest();
        int operationsCount = 0;
        OperationType operationType = batchOperationRequest.getOperationType();
        List<Long> processInstanceKeys = processInstanceSources.stream().map(ProcessInstanceSource::getProcessInstanceKey).collect(Collectors.toList());
        Map<Object, Object> incidentKeys = new HashMap();
        if (operationType.equals((Object)OperationType.RESOLVE_INCIDENT) && incidentId == null) {
            incidentKeys = this.incidentReader.getIncidentKeysPerProcessInstance(processInstanceKeys);
        }
        try {
            processInstanceIdToIndexName = this.listViewStore.getListViewIndicesForProcessInstances(processInstanceKeys);
        }
        catch (IOException e) {
            throw new NotFoundException("Couldn't find index names for process instances.", e);
        }
        for (ProcessInstanceSource processInstanceSource : processInstanceSources) {
            Long processInstanceKey = processInstanceSource.getProcessInstanceKey();
            if (operationType.equals((Object)OperationType.RESOLVE_INCIDENT) && incidentId == null) {
                List allIncidentKeys = (List)incidentKeys.get(processInstanceKey);
                if (allIncidentKeys != null && !allIncidentKeys.isEmpty()) {
                    for (Long incidentKey : allIncidentKeys) {
                        OperationEntity operationEntity = this.createOperationEntity(processInstanceSource, operationType, batchOperationId).setIncidentKey(incidentKey);
                        batchRequest.add(this.operationTemplate.getFullQualifiedName(), (OperateEntity)operationEntity);
                        ++operationsCount;
                    }
                }
            } else {
                OperationEntity operationEntity = this.createOperationEntity(processInstanceSource, operationType, batchOperationId).setIncidentKey(ConversionUtils.toLongOrNull((String)incidentId));
                if (operationType == OperationType.MIGRATE_PROCESS_INSTANCE) {
                    try {
                        operationEntity.setMigrationPlan(this.objectMapper.writeValueAsString((Object)batchOperationRequest.getMigrationPlan()));
                    }
                    catch (IOException e) {
                        throw new PersistenceException((Throwable)e);
                    }
                }
                if (operationType == OperationType.MODIFY_PROCESS_INSTANCE) {
                    try {
                        ModifyProcessInstanceRequestDto modOp = new ModifyProcessInstanceRequestDto().setProcessInstanceKey(String.valueOf(processInstanceSource.getProcessInstanceKey())).setModifications(batchOperationRequest.getModifications());
                        operationEntity.setModifyInstructions(this.objectMapper.writeValueAsString((Object)modOp));
                    }
                    catch (IOException e) {
                        throw new PersistenceException((Throwable)e);
                    }
                }
                batchRequest.add(this.operationTemplate.getFullQualifiedName(), (OperateEntity)operationEntity);
                ++operationsCount;
            }
            String processInstanceId = String.valueOf(processInstanceKey);
            String indexForProcessInstance = (String)CollectionUtil.getOrDefaultForNullValue((Map)processInstanceIdToIndexName, (Object)processInstanceKey, (Object)this.listViewTemplate.getFullQualifiedName());
            Map<String, String> params = Map.of("batchOperationId", batchOperationId);
            String script = "if (ctx._source.batchOperationIds == null){ctx._source.batchOperationIds = new String[]{params.batchOperationId};} else {ctx._source.batchOperationIds.add(params.batchOperationId);}";
            batchRequest.updateWithScript(indexForProcessInstance, processInstanceId, "if (ctx._source.batchOperationIds == null){ctx._source.batchOperationIds = new String[]{params.batchOperationId};} else {ctx._source.batchOperationIds.add(params.batchOperationId);}", params);
        }
        batchRequest.execute();
        return operationsCount;
    }

    private OperationEntity createOperationEntity(ProcessInstanceSource processInstanceSource, OperationType operationType, String batchOperationId) {
        OperationEntity operationEntity = new OperationEntity();
        operationEntity.generateId();
        operationEntity.setProcessInstanceKey(processInstanceSource.getProcessInstanceKey());
        operationEntity.setProcessDefinitionKey(processInstanceSource.getProcessDefinitionKey());
        operationEntity.setBpmnProcessId(processInstanceSource.getBpmnProcessId());
        operationEntity.setType(operationType);
        operationEntity.setState(OperationState.SCHEDULED);
        operationEntity.setBatchOperationId(batchOperationId);
        operationEntity.setUsername(this.userService.getCurrentUser().getUsername());
        return operationEntity;
    }
}

