/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.transform;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.BatchOperationEntity;
import io.camunda.operate.webapp.rest.dto.operation.BatchOperationDto;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class DataAggregator {
    @Autowired
    @Qualifier(value="operateObjectMapper")
    protected ObjectMapper objectMapper;

    public abstract Map<String, BatchOperationDto> requestAndAddMetadata(Map<String, BatchOperationDto> var1, List<String> var2);

    public List<BatchOperationDto> enrichBatchEntitiesWithMetadata(List<BatchOperationEntity> batchEntities) {
        if (CollectionUtils.isEmpty(batchEntities)) {
            return List.of();
        }
        LinkedHashMap<String, BatchOperationDto> requestDtos = new LinkedHashMap<String, BatchOperationDto>(batchEntities.size());
        batchEntities.forEach(entity -> requestDtos.put(entity.getId(), BatchOperationDto.createFrom(entity, this.objectMapper)));
        List<String> idList = requestDtos.keySet().stream().toList();
        return this.requestAndAddMetadata(requestDtos, idList).values().stream().toList();
    }
}

